-- -------------------------------------------------------------------- 
-- >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<< 
-- -------------------------------------------------------------------- 
-- Copyright (c) 2001 by Lattice Semiconductor Corporation 
-- -------------------------------------------------------------------- 
-- 
-- 
--                     Lattice Semiconductor Corporation 
--                     5555 NE Moore Court 
--                     Hillsboro, OR 97214 
--                     U.S.A 
-- 
--                     TEL: 1-800-Lattice (USA and Canada) 
--                          408-826-6000 (other locations) 
-- 
--                     web: http://www.latticesemi.com/ 
--                     email: techsupport@latticesemi.com 
-- 
-- -------------------------------------------------------------------- 
-- Revision History:

--$Header: R:/src/mod_kits/Mach/vital/rcs/LC5KMX.vhd 1.58 2004/03/12 22:37:22Z jli Exp $

----------------------------------------------------------------
-- 
-- FILE CONTENTS:    LC5KMX VITAL Library 
-- DATE CREATED :    Wen Sept  15 1998
-- 
-- LIBRARY      :    LC5KMX
-- REVISION     :    1.2 
-- TIME SCALE   :    1 ns
-- LOGIC SYSTEM :    IEEE-1164
-- NOTES        :    
-- HISTORY      :
-- 
-- version 1.0, Initial beta version for beta testing 
-- version 1.1, Change the array size to pass model tech.
-- version 1.2, Change the default for setup and hold for DFF/TFF/DLAT
--              Modified the index range to pass Modelsim EE 5.2e warnings
-- version 1.3, Change the default pw, period for FF and LATCH.

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_timing.all;
USE IEEE.VITAL_primitives.all;
 
 
package VLOGTOVITAL_TABLES is
 
---------------------------------------------------------------------------------
-- Local type declaration
---------------------------------------------------------------------------------

    TYPE edge_table IS ARRAY (std_ulogic, std_ulogic) OF boolean ;

---------------------------------------------------------------------------------
-- Contants Specifications
-- posedge, negedge
---------------------------------------------------------------------------------
    CONSTANT POSEDGE : edge_table := (
    --      ---------------------------------------------------------
    --      |  U      X      0      1      Z      W      L      H      - |   |
    --      ---------------------------------------------------------
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

    CONSTANT NEGEDGE : edge_table := (
    --      ---------------------------------------------------- -----
    --      |  U    X    0    1    Z    W    L    H    - |   |
    --      ---------------------------------------------------- -----
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

        -------------------------------------------------------------------------------
        --State Table Declaration
        -------------------------------------------------------------------------------

	CONSTANT dfftab : VitalStateTableType := (
	-- D CLK R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1' ),
	( '-', '0', '1', '*', '1', '1' ),
	( '-', '1', '1', '*', '1', '1' ),
	( '1', '-', '0', '\', '0', 'X' ),---
	( '-', '0', '0', '\', '0', 'X' ),---
	( '-', '1', '0', '\', '0', 'X' ),---
	( '0', '-', '*', '1', '0', '0' ),
	( '-', '0', '*', '1', '0', '0' ),
	( '-', '1', '*', '1', '0', '0' ),
	( '0', '-', '\', '0', '1', 'X' ),--
	( '-', '0', '\', '0', '1', 'X' ),--
	( '-', '1', '\', '0', '1', 'X' ),--
	( '1', 'R', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '-', 'S' ),
	( '-', 'v', '-', '-', '-', 'S' ),
	( '0', 'r', '-', '-', '0', 'S' ),
	( '0', 'f', '-', '-', '0', 'S' ),
	( '1', 'r', '-', '-', '1', 'S' ),
	( '1', 'f', '-', '-', '1', 'S' ),
	( '*', '1', '-', '-', '-', 'S' ),
	( '*', '0', '-', '-', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT latchtab : VitalStateTableType := (
	-- D LAT R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '*', '0', '1', '1', '-', 'S' ),
	( '-', '\', '1', '1', '-', 'S' ),
	( '-', 'v', '1', '1', '-', 'S' ),
	( '-', 'f', '1', '1', '-', 'S' ),
	( '0', '^', '-', '1', '-', '0' ),
	( '1', '^', '1', '-', '-', '1' ),
	( '0', 'r', '1', '1', '0', '0' ),
	( '1', 'r', '1', '1', '1', '1' ),
	( '\', '1', '-', '1', '-', '0' ),
	( 'v', '1', '-', '1', '-', '0' ),
	( '/', '1', '1', '-', '-', '1' ),
	( '^', '1', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '-', '0', '1', '/', '-', 'S' ),
	( '-', '0', '1', '^', '-', 'S' ),
	( '-', '0', '/', '1', '-', 'S' ),
	( '-', '0', '^', '1', '-', 'S' ),
	( '0', '1', '-', '/', '-', '0' ),
	( '0', '1', '-', '^', '-', '0' ),
	( '1', '1', '/', '-', '-', '1' ),
	( '1', '1', '^', '-', '-', '1' ),
	( '1', '1', '1', '/', '-', '1' ),
	( '1', '1', '1', '^', '-', '1' ),
	( '0', '1', '/', '1', '-', '0' ),
	( '0', '1', '^', '1', '-', '0' ),
	( '/', 'X', '1', '-', '1', '1' ),
	( '^', 'X', '1', '-', '1', '1' ),
	( '\', 'X', '-', '1', '0', '0' ),
	( 'v', 'X', '-', '1', '0', '0' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT jkfftab : VitalStateTableType := (
	-- CLK J K S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '0' ),
	( '/', '1', '0', '1', '1', '-', '1' ),
	( '/', '1', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', '-', 'S' ),
	( 'B', '-', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT rsfftab : VitalStateTableType := (
	-- CLK RE SE S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '1', '1', '/', '1', '-', 'S' ),
	( '-', '1', '1', '^', '1', '-', 'S' ),
	( '-', '1', '1', '1', '/', '-', 'S' ),
	( '-', '1', '1', '1', '^', '-', 'S' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '1' ),
	( '/', '1', '0', '1', '1', '-', '0' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '/', '-', 'S' ),----
	( 'S', 'S', 'S', '/', 'S', '-', 'S' ),----
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),----
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ),
	( '-', '*', '-', '1', '1', '-', 'S' ),
	( '-', '-', '*', '1', '1', '-', 'S' ));


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT tfftab : VitalStateTableType := (
	-- CLK T S R lstSt Q
	( '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '1', '0', '-', '0' ),
	( 'X', '0', '1', '-', '0', 'S' ),
	( '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '1', '1', '-', 'S' ),
	( '/', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '1', '-', '0', 'S' ),
	( 'R', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '1', '1', '-', 'S' ),
	( 'f', '-', '-', '1', '1', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT dffcetab : VitalStateTableType := (
	-- D CLK R S CE lstSt Q
	( '-', '-', '0', '1', '-', '-', '0' ),
	( '-', '-', '1', '0', '-', '-', '1' ),
	( '-', '-', '1', '1', '0', '-', 'S' ),
	( '1', '/', '1', '-', '1', '-', '1' ),
	( '0', '/', '-', '1', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1', '1' ),
	( '-', '0', '1', '*', '1', '1', '1' ),
	( '-', '1', '1', '*', '1', '1', '1' ),
	( '0', '-', '*', '1', '1', '0', '0' ),
	( '-', '0', '*', '1', '1', '0', '0' ),
	( '-', '1', '*', '1', '1', '0', '0' ),
	( '1', 'R', '1', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '1', '-', 'S' ),
	( '-', 'v', '-', '-', '1', '-', 'S' ),
	( '0', 'r', '-', '-', '1', '0', 'S' ),
	( '0', 'f', '-', '-', '1', '0', 'S' ),
	( '1', 'r', '-', '-', '1', '1', 'S' ),
	( '1', 'f', '-', '-', '1', '1', 'S' ),
	( '*', '1', '-', '-', '1', '-', 'S' ),
	( '*', '0', '-', '-', '1', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( '-', '-', '1', '1', '*', '-', 'S' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


end VLOGTOVITAL_TABLES;
 
----- VITAL model for cell AND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND2 : entity is TRUE;
end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of AND2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND2_VITAL of AND2 is 
        for VITAL
        end for; 
end CFG_AND2_VITAL;
----- VITAL model for cell AND3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3 : entity is TRUE;
end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of AND3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd) AND (I2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND3_VITAL of AND3 is 
        for VITAL
        end for; 
end CFG_AND3_VITAL;
----- VITAL model for cell AND4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4 : entity is TRUE;
end AND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of AND4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND4_VITAL of AND4 is 
        for VITAL
        end for; 
end CFG_AND4_VITAL;
----- VITAL model for cell AND5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND5 : entity is TRUE;
end AND5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of AND5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND5_VITAL of AND5 is 
        for VITAL
        end for; 
end CFG_AND5_VITAL;
----- VITAL model for cell AND6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND6 : entity is TRUE;
end AND6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of AND6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND6_VITAL of AND6 is 
        for VITAL
        end for; 
end CFG_AND6_VITAL;
----- VITAL model for cell AND7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND7 : entity is TRUE;
end AND7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of AND7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd) AND (I6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND7_VITAL of AND7 is 
        for VITAL
        end for; 
end CFG_AND7_VITAL;
----- VITAL model for cell AND8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND8 : entity is TRUE;
end AND8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of AND8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd) AND (I6_ipd) AND (I7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND8_VITAL of AND8 is 
        for VITAL
        end for; 
end CFG_AND8_VITAL;


----- CELL MUX2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX2 : entity is TRUE;
end MUX2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX2_VITAL of MUX2 is
   for VITAL
   end for;
end CFG_MUX2_VITAL;


----- CELL MUX4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX4 : entity is TRUE;
end MUX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, S0_ipd, S1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I3_ipd, I2_ipd, I1_ipd, I0_ipd),
                  dselect => (S1_ipd, S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 5 => (S1_ipd'last_event, tpd_S1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX4_VITAL of MUX4 is
   for VITAL
   end for;
end CFG_MUX4_VITAL;
 
----- VITAL model for cell BI_DIR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BI_DIR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN        : string  := "Off";
      PULL           : string  := "Off";
      tpd_OE_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BI_DIR : entity is TRUE;
end BI_DIR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BI_DIR is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (IO_ipd, IO, tipd_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

   VITALBehavior : process (OE_ipd, I0_ipd, IO_ipd)


   -- functionality results
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
     VARIABLE IO_GlitchData	: VitalGlitchDataType;
     VARIABLE O_GlitchData	: VitalGlitchDataType;
     VARIABLE IO_zd : std_ulogic ;

   begin
      -------------------------
      --  Functionality Section
      -------------------------

      if (OE_ipd = '0') then
         IO_zd := 'Z';
      elsif (OE_ipd = '1') then
         if (OUTOPEN = "Off") then
             IO_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
             if (I0_ipd = '0') then
                IO_zd := '0';
             elsif (I0_ipd = '1') then
                IO_zd := 'Z';
             else
                IO_zd := 'X';
             end if;
         end if;
      end if;


      if (PULL = "Off") then
           O_zd := TO_X01(IO_ipd);
      elsif (PULL = "Up") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '1';
              WHEN others => O_zd := 'X';
           END CASE;
      elsif (PULL = "Down") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '0';
              WHEN others => O_zd := 'X';
           END CASE;
      elsif (PULL = "Hold") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := O_zd;
              WHEN others => O_zd := 'X';
           END CASE;
      end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_IO), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (IO_ipd'last_event, tpd_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BI_DIR_VITAL of BI_DIR is 
        for VITAL
        end for; 
end CFG_BI_DIR_VITAL;

----- VITAL model for cell BUFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFF : entity is TRUE;
end BUFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of BUFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BUFF_VITAL of BUFF is 
        for VITAL
        end for; 
end CFG_BUFF_VITAL;

----- VITAL model for cell BUFTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTH : entity is TRUE;
end BUFTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BUFTH is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------

       if (OE = '0') then
          O_zd := 'Z';
       elsif (OE = '1') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BUFTH_VITAL of BUFTH is 
        for VITAL
        end for; 
end CFG_BUFTH_VITAL;

----- VITAL model for cell BUFTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN       : string := "Off";
      tpd_OE_O                       :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTL : entity is TRUE;
end BUFTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BUFTL is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       if (OE = '1') then
          O_zd := 'Z';
       elsif (OE = '0') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;
      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BUFTL_VITAL of BUFTL is 
        for VITAL
        end for; 
end CFG_BUFTL_VITAL;

----- VITAL model for cell CLKI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CLKI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PAD_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_PAD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CLKI : entity is TRUE;
end CLKI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of CLKI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_CLKI_VITAL of CLKI is 
        for VITAL
        end for; 
end CFG_CLKI_VITAL;

----- VITAL model for cell DFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 1.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFF : entity is TRUE;
end DFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R ,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFF_VITAL of DFF is 
        for VITAL
        end for; 
end CFG_DFF_VITAL;

----- VITAL model for cell DFFC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge        :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFC : entity is TRUE;
end DFFC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFC is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '1',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly, R ,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFC_VITAL of DFFC is 
        for VITAL
        end for; 
end CFG_DFFC_VITAL;

----- VITAL model for cell DFFCR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCR : entity is TRUE;
end DFFCR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFCR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge or Tviol_CE_CLK_R_EQ_1_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_CLK_dly,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCR_VITAL of DFFCR is 
        for VITAL
        end for; 
end CFG_DFFCR_VITAL;
----- VITAL model for cell DFFCRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		:	VitalDelayType := 1.000 ns;
      tpw_R_posedge 		:	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRH : entity is TRUE;
end DFFCRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFCRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R				: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R				: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(NOT R_CLK_dly)= '1', 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_R_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge or Tviol_CE_CLK_R_EQ_0_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_inverted,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRH_VITAL of DFFCRH is 
        for VITAL
        end for; 
end CFG_DFFCRH_VITAL;

----- VITAL model for cell DFFCS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCS : entity is TRUE;
end DFFCS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFCS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_S_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                          TO_X01((S_CLK_dly) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge or Tviol_CE_CLK_S_EQ_1_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1',S_CLK_dly, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCS_VITAL of DFFCS is 
        for VITAL
        end for; 
end CFG_DFFCS_VITAL;
----- VITAL model for cell DFFCSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCSH : entity is TRUE;
end DFFCSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFCSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_S_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(NOT S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge or Tviol_CE_CLK_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1', S_inverted, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCSH_VITAL of DFFCSH is 
        for VITAL
        end for; 
end CFG_DFFCSH_VITAL;

----- VITAL model for cell DFFCRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFCRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRS : entity is TRUE;
end DFFCRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFCRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_CLK_dly, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE CE_delayed : STD_ULOGIC := 'X';
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_CLK_dly) AND (S_CLK_dly))
                            /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly AND S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge or Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge or Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1 or Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge;
      CE_delayed := CE_CLK_dly;
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_delayed, CLK_delayed, R_CLK_dly, S_CLK_dly,CE_delayed ));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRS_VITAL of DFFCRS is 
        for VITAL
        end for; 
end CFG_DFFCRS_VITAL;
----- VITAL model for cell DFFCRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DFFCRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRSH : entity is TRUE;
end DFFCRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFCRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';


begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_CLK_dly, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE CE_delayed : STD_ULOGIC := 'X';
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_CLK_dly) AND ((NOT
                            S_CLK_dly))) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((NOT R_CLK_dly) AND (NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge or Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge or Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0 or Pviol_R or Pviol_S;
      CE_delayed := CE_CLK_dly;
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      R_inverted := (NOT R_CLK_dly);
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_delayed, CLK_delayed,R_inverted,S_inverted,CE_delayed));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRSH_VITAL of DFFCRSH is 
        for VITAL
        end for; 
end CFG_DFFCRSH_VITAL;

----- VITAL model for cell DFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFR : entity is TRUE;
end DFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_1_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
              D_CLK_dly, CLK_dly, R_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFR_VITAL of DFFR is 
        for VITAL
        end for; 
end CFG_DFFR_VITAL;
----- VITAL model for cell DFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tpw_R_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRH : entity is TRUE;
end DFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRH_VITAL of DFFRH is 
        for VITAL
        end for; 
end CFG_DFFRH_VITAL;
----- VITAL model for cell DFFRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_negedge :	VitalDelayType := 1.000 ns;
      tpw_S_negedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRS : entity is TRUE;
end DFFRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R			: STD_ULOGIC := '0';
   VARIABLE Pviol_S			: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S			: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      Violation := Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_AN_S_EQ_1 or Pviol_R or Pviol_S;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_delayed, CLK_delayed, R_CLK_dly, S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRS_VITAL of DFFRS is 
        for VITAL
        end for; 
end CFG_DFFRS_VITAL;
----- VITAL model for cell DFFRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		     :	VitalDelayType := 1.000 ns;
      tpw_R_posedge 		     :	VitalDelayType := 1.000 ns;
      tpw_S_posedge 		     :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge   	     :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge     :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge     :	VitalDelayType := 0.000 ns;
      ticd_CLK                        :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                      :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                      :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                      :	VitalDelayType := 0.000 ns;
      tipd_D                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                          :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRSH : entity is TRUE;
end DFFRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R			: STD_ULOGIC := '0';
   VARIABLE Pviol_S			: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S			: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE R_inverted: STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) /=
                            '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      R_inverted := NOT R_CLK_dly;
      S_inverted := NOT S_CLK_dly;
      Violation := Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_R_CLK_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_AN_S_EQ_0 or Pviol_R or Pviol_S;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_delayed, CLK_delayed, R_inverted, S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRSH_VITAL of DFFRSH is 
        for VITAL
        end for; 
end CFG_DFFRSH_VITAL;

----- VITAL model for cell DFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFS : entity is TRUE;
end DFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFS_VITAL of DFFS is 
        for VITAL
        end for; 
end CFG_DFFS_VITAL;
----- VITAL model for cell DFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tpw_S_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSH : entity is TRUE;
end DFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSH_VITAL of DFFSH is 
        for VITAL
        end for; 
end CFG_DFFSH_VITAL;
----- VITAL model for cell DLAT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLAT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 1.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 1.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLAT : entity is TRUE;
end DLAT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLAT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLAT_VITAL of DLAT is 
        for VITAL
        end for; 
end CFG_DLAT_VITAL;
----- VITAL model for cell DLATR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.0 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.1 ns;
      thold_R_LAT_posedge_negedge    :	VitalDelayType := 0.0 ns;
      ticd_LAT                       :	VitalDelayType := 0.0 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.0 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.0 ns;
      tipd_D                         :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_R                         :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATR : entity is TRUE;
end DLATR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLATR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_1_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATR_VITAL of DLATR is 
        for VITAL
        end for; 
end CFG_DLATR_VITAL;
----- VITAL model for cell DLATRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.1 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.0 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRH : entity is TRUE;
end DLATRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLATRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((R_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_0_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_0;
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,R_inverted,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRH_VITAL of DLATRH is 
        for VITAL
        end for; 
end CFG_DLATRH_VITAL;
----- VITAL model for cell DLATRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_negedge :	VitalDelayType := 1.000 ns;
      tpw_S_negedge :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge  :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_posedge_negedge :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_posedge_negedge :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRS : entity is TRUE;
end DLATRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLATRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE NOT_S_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly) AND (R_LAT_dly)) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_R_LAT_S_EQ_1_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_S_LAT_R_EQ_1_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1_ANB_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_LAT_dly ) AND ( R_LAT_dly ) ) = '1',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        NOT_S_zd := VitalINV (S_LAT_dly);
        D_in_zd := VitalOR2 (NOT_S_zd , D_LAT_dly);

      Violation := Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge or Tviol_S_LAT_R_EQ_1_negedge or Pviol_LAT_R_EQ_1_ANB_S_EQ_1 or Tviol_R_LAT_S_EQ_1_negedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly, S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE),
                 3 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRS_VITAL of DLATRS is 
        for VITAL
        end for; 
end CFG_DLATRS_VITAL;
----- VITAL model for cell DLATRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge  :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge     :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge     :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRSH : entity is TRUE;
end DLATRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLATRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R : STD_ULOGIC := '0';
   VARIABLE Pviol_S : STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_LAT_dly)) AND ((NOT R_LAT_dly))) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_R_LAT_S_EQ_0_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_S_LAT_R_EQ_0_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0_ANB_S_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0_ANB_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT S_LAT_dly)) AND ((NOT R_LAT_dly))) = '1',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        D_in_zd := VitalOR2 (S_LAT_dly , D_LAT_dly);

      Violation := Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge or Tviol_R_LAT_S_EQ_0_negedge or Tviol_S_LAT_R_EQ_0_negedge or Pviol_LAT_R_EQ_0_ANB_S_EQ_0 or Pviol_R or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_inverted, S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE),
                 3 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRSH_VITAL of DLATRSH is 
        for VITAL
        end for; 
end CFG_DLATRSH_VITAL;
----- VITAL model for cell DLATS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.0 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.1 ns;
      thold_S_LAT_posedge_negedge    :	VitalDelayType := 0.0 ns;
      ticd_LAT                       :	VitalDelayType := 0.0 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.0 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.0 ns;
      tipd_D                         :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_S                         :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATS : entity is TRUE;
end DLATS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLATS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_1,
          PeriodData              => PInfo_LAT_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_1_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1', S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATS_VITAL of DLATS is 
        for VITAL
        end for; 
end CFG_DLATS_VITAL;
----- VITAL model for cell DLATSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.1 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.0 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.000 ns;
      tpw_S_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSH : entity is TRUE;
end DLATSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of DLATSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_0,
          PeriodData              => PInfo_LAT_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_0_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, '1',S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSH_VITAL of DLATSH is 
        for VITAL
        end for; 
end CFG_DLATSH_VITAL;
----- VITAL model for cell GND -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GND is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '0');
attribute VITAL_LEVEL0 of GND : entity is TRUE;
end GND;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of GND is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

	SIGNAL SUPPLY0    :   STD_ULOGIC := '0';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

Inst1 : VitalBUF (X,SUPPLY0);

end VITAL;

configuration CFG_GND_VITAL of GND is 
        for VITAL
        end for; 
end CFG_GND_VITAL;
----- VITAL model for cell GSRBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_SRI_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_SRI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      SRI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUF : entity is TRUE;
end GSRBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of GSRBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL SRI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (SRI_ipd, SRI, tipd_SRI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (SRI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(SRI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (SRI_ipd'last_event, tpd_SRI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_GSRBUF_VITAL of GSRBUF is 
        for VITAL
        end for; 
end CFG_GSRBUF_VITAL;

----- VITAL model for cell IBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity IBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      PULL           : string  := "Off";
      tpd_I0_O                       :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of IBUF : entity is TRUE;
end IBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of IBUF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_ULOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_ULOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
        if (PULL = "Off") then
           O_zd := TO_X01(I0_ipd);
        elsif (PULL = "Up") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '1';
              WHEN others => O_zd := 'X';
           END CASE;
        elsif (PULL = "Down") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '0';
              WHEN others => O_zd := 'X';
           END CASE;
        elsif (PULL = "Hold") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := O_zd;
              WHEN others => O_zd := 'X';
           END CASE;
        end if;
      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_IBUF_VITAL of IBUF is 
        for VITAL
        end for; 
end CFG_IBUF_VITAL;

----- VITAL model for cell INV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INV : entity is TRUE;
end INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of INV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_INV_VITAL of INV is 
        for VITAL
        end for; 
end CFG_INV_VITAL;

----- VITAL model for cell INVTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INVTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTH : entity is TRUE;
end INVTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of INVTH is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);
   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;
   VARIABLE I0_inv          : STD_ULOGIC := 'X';

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       I0_inv := not I0_ipd;

       if (OE = '0') then
          O_zd := 'Z';
       elsif (OE = '1') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_inv);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_inv = '0') then
              O_zd := '0';
           elsif (I0_inv = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;


      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_INVTH_VITAL of INVTH is 
        for VITAL
        end for; 
end CFG_INVTH_VITAL;

----- VITAL model for cell INVTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity INVTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTL : entity is TRUE;
end INVTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of INVTL is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;
   VARIABLE I0_inv          : STD_ULOGIC := 'X';

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       I0_inv := not I0_ipd;

       if (OE = '1') then
          O_zd := 'Z';
       elsif (OE = '0') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_inv);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_inv = '0') then
              O_zd := '0';
           elsif (I0_inv = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_INVTL_VITAL of INVTL is 
        for VITAL
        end for; 
end CFG_INVTL_VITAL;

----- VITAL model for cell NAN2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN2 : entity is TRUE;
end NAN2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NAN2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) OR ((NOT I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN2_VITAL of NAN2 is 
        for VITAL
        end for; 
end CFG_NAN2_VITAL;
----- VITAL model for cell NAN3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I2                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN3 : entity is TRUE;
end NAN3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NAN3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN3_VITAL of NAN3 is 
        for VITAL
        end for; 
end CFG_NAN3_VITAL;
----- VITAL model for cell NAN4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN4 : entity is TRUE;
end NAN4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NAN4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN4_VITAL of NAN4 is 
        for VITAL
        end for; 
end CFG_NAN4_VITAL;
----- VITAL model for cell NAN5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN5 : entity is TRUE;
end NAN5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NAN5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN5_VITAL of NAN5 is 
        for VITAL
        end for; 
end CFG_NAN5_VITAL;
----- VITAL model for cell NAN6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN6 : entity is TRUE;
end NAN6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NAN6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN6_VITAL of NAN6 is 
        for VITAL
        end for; 
end CFG_NAN6_VITAL;
----- VITAL model for cell NAN7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN7 : entity is TRUE;
end NAN7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NAN7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd)) OR ((NOT I6_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN7_VITAL of NAN7 is 
        for VITAL
        end for; 
end CFG_NAN7_VITAL;
----- VITAL model for cell NAN8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN8 : entity is TRUE;
end NAN8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NAN8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd)) OR ((NOT I6_ipd)) OR ((NOT
         I7_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN8_VITAL of NAN8 is 
        for VITAL
        end for; 
end CFG_NAN8_VITAL;

----- VITAL model for cell NOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR2 : entity is TRUE;
end NOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) AND ((NOT I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR2_VITAL of NOR2 is 
        for VITAL
        end for; 
end CFG_NOR2_VITAL;
----- VITAL model for cell NOR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR3 : entity is TRUE;
end NOR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NOR3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR3_VITAL of NOR3 is 
        for VITAL
        end for; 
end CFG_NOR3_VITAL;
----- VITAL model for cell NOR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR4 : entity is TRUE;
end NOR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of NOR4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR4_VITAL of NOR4 is 
        for VITAL
        end for; 
end CFG_NOR4_VITAL;
----- VITAL model for cell NOR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR5 : entity is TRUE;
end NOR5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NOR5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR5_VITAL of NOR5 is 
        for VITAL
        end for; 
end CFG_NOR5_VITAL;
----- VITAL model for cell NOR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR6 : entity is TRUE;
end NOR6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NOR6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR6_VITAL of NOR6 is 
        for VITAL
        end for; 
end CFG_NOR6_VITAL;
----- VITAL model for cell NOR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR7 : entity is TRUE;
end NOR7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NOR7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd)) AND ((NOT I6_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR7_VITAL of NOR7 is 
        for VITAL
        end for; 
end CFG_NOR7_VITAL;
----- VITAL model for cell NOR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR8 : entity is TRUE;
end NOR8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of NOR8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd)) AND ((NOT I6_ipd))
         AND ((NOT I7_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR8_VITAL of NOR8 is 
        for VITAL
        end for; 
end CFG_NOR8_VITAL;

----- VITAL model for cell OBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity OBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN          : string  := "Off";
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OBUF : entity is TRUE;
end OBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of OBUF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
       elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
       end if;
          

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OBUF_VITAL of OBUF is 
        for VITAL
        end for; 
end CFG_OBUF_VITAL;

----- VITAL model for cell OR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR2 : entity is TRUE;
end OR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of OR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR2_VITAL of OR2 is 
        for VITAL
        end for; 
end CFG_OR2_VITAL;
----- VITAL model for cell OR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR3 : entity is TRUE;
end OR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of OR3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR3_VITAL of OR3 is 
        for VITAL
        end for; 
end CFG_OR3_VITAL;
----- VITAL model for cell OR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR4 : entity is TRUE;
end OR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of OR4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR4_VITAL of OR4 is 
        for VITAL
        end for; 
end CFG_OR4_VITAL;
----- VITAL model for cell OR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR5 : entity is TRUE;
end OR5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of OR5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR5_VITAL of OR5 is 
        for VITAL
        end for; 
end CFG_OR5_VITAL;
----- VITAL model for cell OR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR6 : entity is TRUE;
end OR6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of OR6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR6_VITAL of OR6 is 
        for VITAL
        end for; 
end CFG_OR6_VITAL;
----- VITAL model for cell OR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR7 : entity is TRUE;
end OR7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of OR7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd)
         OR (I6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR7_VITAL of OR7 is 
        for VITAL
        end for; 
end CFG_OR7_VITAL;
----- VITAL model for cell OR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR8 : entity is TRUE;
end OR8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library LC5KMX;
architecture VITAL of OR8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd)
         OR (I6_ipd) OR (I7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR8_VITAL of OR8 is 
        for VITAL
        end for; 
end CFG_OR8_VITAL;

----- VITAL model for cell TFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge    :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge     :	VitalDelayType := 0.0 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.0 ns;
      tpw_CLK_posedge                :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFF : entity is TRUE;
end TFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => '0');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_posedge,
          TimingData              => Tmkr_T_CLK_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/TFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFF_VITAL of TFF is 
        for VITAL
        end for; 
end CFG_TFF_VITAL;
----- VITAL model for cell TFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFR : entity is TRUE;
end TFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1 or Tviol_R_CLK_posedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', R_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFR_VITAL of TFFR is 
        for VITAL
        end for; 
end CFG_TFFR_VITAL;
----- VITAL model for cell TFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tpw_R_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRH : entity is TRUE;
end TFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', R_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRH_VITAL of TFFRH is 
        for VITAL
        end for; 
end CFG_TFFRH_VITAL;
----- VITAL model for cell TFFRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity TFFRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q             :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q             :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q           :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.0 ns;
      tpw_R_negedge :	VitalDelayType := 1.0 ns;
      tpw_S_negedge :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRS : entity is TRUE;
end TFFRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFFRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE T_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_AN_S_EQ_1 or Pviol_R or Pviol_s;
      T_delayed := T_CLK_dly;
      CLK_delayed := CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly,S_CLK_dly, R_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRS_VITAL of TFFRS is 
        for VITAL
        end for; 
end CFG_TFFRS_VITAL;
----- VITAL model for cell TFFRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity TFFRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.0 ns;
      tpw_R_posedge :	VitalDelayType := 1.0 ns;
      tpw_S_posedge :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRSH : entity is TRUE;
end TFFRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFFRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE T_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) /=
                            '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_AN_S_EQ_0 or Tviol_R_CLK_S_EQ_0_posedge or Pviol_R or Pviol_S;
      T_delayed := T_CLK_dly;
      CLK_delayed := CLK_dly;
      S_inverted := NOT S_CLK_dly;
      R_inverted := NOT R_CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly,S_inverted, R_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRSH_VITAL of TFFRSH is 
        for VITAL
        end for; 
end CFG_TFFRSH_VITAL;
----- VITAL model for cell TFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFS : entity is TRUE;
end TFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_S_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, S_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFS_VITAL of TFFS is 
        for VITAL
        end for; 
end CFG_TFFS_VITAL;
----- VITAL model for cell TFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tpw_S_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFSH : entity is TRUE;
end TFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of TFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_S_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, S_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFSH_VITAL of TFFSH is 
        for VITAL
        end for; 
end CFG_TFFSH_VITAL;
----- VITAL model for cell VCC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity VCC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '1');
attribute VITAL_LEVEL0 of VCC : entity is TRUE;
end VCC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of VCC is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;
   
   SIGNAL SUPPLY1  : STD_ULOGIC := '1'; 

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

Inst1: VitalBUF (X,SUPPLY1);

end VITAL;

configuration CFG_VCC_VITAL of VCC is 
        for VITAL
        end for; 
end CFG_VCC_VITAL;

----- VITAL model for cell XOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity XOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of XOR2 : entity is TRUE;

   -- real names
   -- REAL_NAME of XOR2 is "XOR2"
end XOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of XOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (((NOT I0_ipd)) AND (I1_ipd)) OR (((NOT I1_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_XOR2_VITAL of XOR2 is 
        for VITAL
        end for; 
end CFG_XOR2_VITAL;

----- VITAL model for cell XORSOFT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity XORSOFT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of XORSOFT : entity is TRUE;
end XORSOFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of XORSOFT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (((NOT I0_ipd)) AND (I1_ipd)) OR (((NOT I1_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_XORSOFT_VITAL of XORSOFT is 
        for VITAL
        end for; 
end CFG_XORSOFT_VITAL;



library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SPLL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      IN_FREQ: STRING := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SPLL : entity is FALSE;
end SPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
architecture VITAL of SPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CLK_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => CLK_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "CLK_OUT",
       OutTemp => O_zd,
       Paths => (0 => (CLK_IN_ipd'last_event, tpd_CLK_IN_CLK_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_SPLL_VITAL of SPLL is 
        for VITAL
        end for; 
end CFG_SPLL_VITAL;

----- VITAL model for cell STDPLL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library LC5KMX;
use LC5KMX.components.all;

-- entity declaration --
entity STDPLL is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      SECDIV   : string  := "2";
      lock_cyc : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLL : entity is FALSE;
end STDPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
use LC5KMX.components.all;
architecture VITAL of STDPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
     clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	         
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	END LOOP;
      else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
      end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1) then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;


    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay;

    PLL_LOCK <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus;
               

end VITAL;

configuration CFG_STDPLL_VITAL of STDPLL is 
        for VITAL
        end for; 
end CFG_STDPLL_VITAL;


----- VITAL model for cell STDPLLX -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library LC5KMX;
use LC5KMX.components.all;

-- entity declaration --
entity STDPLLX is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      LOCK_CYC : integer := 2;
      SECDIV   : string   := "2";
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PLL_RST_PLL_LOCK :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_SEC_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_FBK   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_RST   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN            : in    STD_ULOGIC;
      PLL_FBK           : in    STD_ULOGIC;
      PLL_RST           : in    STD_ULOGIC;
      CLK_OUT           : out   STD_ULOGIC;
      SEC_OUT           : out   STD_ULOGIC;
      PLL_LOCK          : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLLX : entity is FALSE;
end STDPLLX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
use LC5KMX.components.all;


architecture VITAL of STDPLLX is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL PLL_RST_ipd	 : STD_ULOGIC := 'X';
  SIGNAL PLL_RST_sig_ipd : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL secd_delay_minus1 : TIME :=100 ns;
  SIGNAL secd_delay_minus0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';

  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';

  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  CONSTANT secdiv_p: integer := str2int(secdiv);
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   VitalWireDelay (PLL_RST_sig_ipd, PLL_RST, tipd_PLL_RST);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
      clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

   PLL_RST_ipd <= PLL_RST_sig_ipd after 1 ns;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
        secd_delay_minus0 <= clklock_half_period0 * secdiv_p + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
        secd_delay_minus1 <= clklock_half_period1 * secdiv_p + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 and PLL_RST_ipd ='0' THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0') then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

process
begin
   wait until SEC_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not;
     wait for clklock_half_period0 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if(clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0') then
        SEC_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  SEC_OUT_start = '1'; LOOP
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d;
     wait for clklock_half_period1 * secdiv_p;
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d ;
     wait for clklock_half_period0 * secdiv_p;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay and not PLL_RST_ipd;

    PLL_LOCK <= PLL_LOCK_plus and not PLL_RST_ipd when tpd >= 0 ns else
                PLL_LOCK_minus and  not PLL_RST_ipd;

    SEC_OUT_sig_d <=  SEC_OUT_sig_d_start and not SEC_OUT_sig_d_not; 

    SEC_OUT_plus_delay <= SEC_OUT_sig_d after tpd when tpd >= 0 ns else
                          SEC_OUT_sig_3d; 

    SEC_OUT <= SEC_OUT_plus_delay and not PLL_RST_ipd;

end VITAL;

configuration CFG_STDPLLX_VITAL of STDPLLX is 
        for VITAL
        end for; 
end CFG_STDPLLX_VITAL;


----- VITAL model for cell LVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIN : entity is FALSE;
end LVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
-- -- use LC5KMX.VTABLES.all;
architecture VITAL of LVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIN_VITAL of LVDSIN is 
        for VITAL
        end for; 
end CFG_LVDSIN_VITAL;

----- VITAL model for cell LVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity LVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSOUT : entity is FALSE;
end LVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
-- use LC5KMX.VTABLES.all;
architecture VITAL of LVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSOUT_VITAL of LVDSOUT is 
        for VITAL
        end for; 
end CFG_LVDSOUT_VITAL;

----- VITAL model for cell LVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSTRI : entity is FALSE;
end LVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
--use LC5KMX.VTABLES.all;
architecture VITAL of LVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_LVDSTRI_VITAL of LVDSTRI is 
        for VITAL
        end for; 
end CFG_LVDSTRI_VITAL;
----- VITAL model for cell LVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIO : entity is FALSE ;
end LVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
--use LC5KMX.VTABLES.all;
architecture VITAL of LVDSIO is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIO_VITAL of LVDSIO is 
        for VITAL
        end for; 
end CFG_LVDSIO_VITAL;


----- VITAL model for cell BLVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIN : entity is FALSE;
end BLVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
-- -- use LC5KMX.VTABLES.all;
architecture VITAL of BLVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSIN_VITAL of BLVDSIN is 
        for VITAL
        end for; 
end CFG_BLVDSIN_VITAL;

----- VITAL model for cell BLVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LC5KMX ;
use LC5KMX.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity BLVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                 :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSOUT : entity is FALSE;
end BLVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
-- use LC5KMX.VTABLES.all;
architecture VITAL of BLVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSOUT_VITAL of BLVDSOUT is 
        for VITAL
        end for; 
end CFG_BLVDSOUT_VITAL;

----- VITAL model for cell BLVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSTRI : entity is FALSE;
end BLVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
--use LC5KMX.VTABLES.all;
architecture VITAL of BLVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BLVDSTRI_VITAL of BLVDSTRI is 
        for VITAL
        end for; 
end CFG_BLVDSTRI_VITAL;

----- VITAL model for cell BLVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BLVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIO : entity is FALSE;
end BLVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LC5KMX;
--use LC5KMX.VTABLES.all;
architecture VITAL of BLVDSIO is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL NTRUE_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSIO_VITAL of BLVDSIO is 
        for VITAL
        end for; 
end CFG_BLVDSIO_VITAL;

----- CELL CCU_AGB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_AGB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_AGB : entity is TRUE;
end CCU_AGB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_AGB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS COUT_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      COUT_zd :=
       ((CIN_ipd) AND ((NOT ((B0_ipd) XOR (A0_ipd))))) OR (((NOT B0_ipd))
         AND (A0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_AGB_VITAL of CCU_AGB is
   for VITAL
   end for;
end CFG_CCU_AGB_VITAL;

----- CELL CCU_AS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_AS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_AS : entity is TRUE;
end CCU_AS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_AS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd, AS_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       ((((NOT AS_ipd)) AND ((NOT B0_ipd))) OR ((AS_ipd) AND (B0_ipd))) XOR
         (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       (((((NOT AS_ipd)) AND ((NOT B0_ipd))) OR ((AS_ipd) AND (B0_ipd))) AND
         ((CIN_ipd) OR (A0_ipd))) OR ((CIN_ipd) AND (A0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_AS_VITAL of CCU_AS is
   for VITAL
   end for;
end CFG_CCU_AS_VITAL;

----- CELL CCU_ADD -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_ADD is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_ADD : entity is TRUE;
end CCU_ADD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_ADD is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (B0_ipd) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((B0_ipd) AND (A0_ipd)) OR ((CIN_ipd) AND
         (B0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_ADD_VITAL of CCU_ADD is
   for VITAL
   end for;
end CFG_CCU_ADD_VITAL;

----- CELL CCU_SUB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_SUB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_SUB : entity is TRUE;
end CCU_SUB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_SUB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (NOT(B0_ipd)) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((NOT(B0_ipd)) AND (A0_ipd)) OR ((CIN_ipd) AND
         (NOT(B0_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_SUB_VITAL of CCU_SUB is
   for VITAL
   end for;
end CFG_CCU_SUB_VITAL;

----- CELL CCU_UDCP -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UDCP is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_S0                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_COUT                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOAD                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_UD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LOAD                           :	in    STD_ULOGIC;
      UD                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UDCP : entity is TRUE;
end CCU_UDCP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UDCP is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LOAD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL UD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LOAD_ipd, LOAD, tipd_LOAD);
   VitalWireDelay (UD_ipd, UD, tipd_UD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SD_ipd, LOAD_ipd, UD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (((CIN_ipd) XOR (NOT (UD_ipd)) XOR (D_ipd)) AND (NOT (LOAD_ipd))) OR
         ((SD_ipd) AND (LOAD_ipd));
      COUT_zd :=
       (((CIN_ipd) AND (D_ipd)) OR (((NOT UD_ipd)) AND (D_ipd)) OR (((NOT
         UD_ipd)) AND (CIN_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_S0, TRUE),
                 2 => (UD_ipd'last_event, tpd_UD_S0, TRUE),
                 3 => (SD_ipd'last_event, tpd_SD_S0, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_COUT, TRUE),
                 2 => (UD_ipd'last_event, tpd_UD_COUT, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UDCP_VITAL of CCU_UDCP is
   for VITAL
   end for;
end CFG_CCU_UDCP_VITAL;

----- CELL CCU_UDC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UDC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_UD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      UD                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UDC : entity is TRUE;
end CCU_UDC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UDC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL UD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (UD_ipd, UD, tipd_UD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, UD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := ((NOT UD_ipd)) XOR (D_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (D_ipd)) OR (((NOT UD_ipd)) AND (D_ipd)) OR ((CIN_ipd)
         AND ((NOT UD_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (UD_ipd'last_event, tpd_UD_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (UD_ipd'last_event, tpd_UD_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UDC_VITAL of CCU_UDC is
   for VITAL
   end for;
end CFG_CCU_UDC_VITAL;

----- CELL CCU_DC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_DC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_DC : entity is TRUE;
end CCU_DC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_DC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (NOT((CIN_ipd) XOR (D_ipd)));
      COUT_zd := (CIN_ipd) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_DC_VITAL of CCU_DC is
   for VITAL
   end for;
end CFG_CCU_DC_VITAL;

----- CELL CCU_UC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UC : entity is TRUE;
end CCU_UC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := ((CIN_ipd) XOR (D_ipd));
      COUT_zd := (CIN_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UC_VITAL of CCU_UC is
   for VITAL
   end for;
end CFG_CCU_UC_VITAL;

----- CELL DC_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DC_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                         :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DC_LSB : entity is TRUE;
end DC_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of DC_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (CIN_ipd) XOR (D_ipd);
      COUT_zd := (CIN_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_DC_LSB_VITAL of DC_LSB is
   for VITAL
   end for;
end CFG_DC_LSB_VITAL;

----- CELL UC_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity UC_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                         :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of UC_LSB : entity is TRUE;
end UC_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of UC_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (CIN_ipd) XOR (D_ipd);
      COUT_zd := (CIN_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_UC_LSB_VITAL of UC_LSB is
   for VITAL
   end for;
end CFG_UC_LSB_VITAL;

----- CELL CCU_UCP -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UCP is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_SD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_S0                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_COUT                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOAD                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LOAD                           :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UCP : entity is TRUE;
end CCU_UCP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UCP is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LOAD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LOAD_ipd, LOAD, tipd_LOAD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SD_ipd, LOAD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (CIN_ipd) XOR ((((NOT LOAD_ipd)) AND (D_ipd)) OR ((LOAD_ipd) AND
         (SD_ipd)));
      COUT_zd := ((((NOT LOAD_ipd)) AND (D_ipd)) OR ((LOAD_ipd) AND
         (SD_ipd))) AND (CIN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (SD_ipd'last_event, tpd_SD_S0, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_S0, TRUE),
                 2 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (LOAD_ipd'last_event, tpd_LOAD_COUT, TRUE),
                 1 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
       		 3 => (SD_ipd'last_event, tpd_SD_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UCP_VITAL of CCU_UCP is
   for VITAL
   end for;
end CFG_CCU_UCP_VITAL;

----- CELL CCU_DCP -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_DCP is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_SD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_S0                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_COUT                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOAD                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LOAD                           :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_DCP : entity is TRUE;
end CCU_DCP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_DCP is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LOAD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LOAD_ipd, LOAD, tipd_LOAD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SD_ipd, LOAD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (NOT((CIN_ipd) XOR  (((NOT LOAD_ipd) AND (D_ipd)) OR ((LOAD_ipd)
         AND (SD_ipd)))));
      COUT_zd :=((CIN_ipd) OR (((NOT LOAD_ipd) AND (D_ipd)) OR ((LOAD_ipd)
         AND (SD_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (SD_ipd'last_event, tpd_SD_S0, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_S0, TRUE),
                 2 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (LOAD_ipd'last_event, tpd_LOAD_COUT, TRUE),
                 1 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_DCP_VITAL of CCU_DCP is
   for VITAL
   end for;
end CFG_CCU_DCP_VITAL;

-- ************************************************************************
--
--  Block Memory: Behavioral Model
--  The kernel of other RAM applications  
--
-- ************************************************************************
--
--  Init: Sep. 10, 2001
--  Written by: Zhou Xiao-qiu
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 224/226
--
-- ************************************************************************
--
--  Filename:  SC_BLOCK_RAM.vhd
--  Description: 16K X 1  BRAM behavioral model. 
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************
library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_16K is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 262144;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 

end SC_BRAM_16K;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_16K is

procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;



--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => '0');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => '0');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => '0');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => '0');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');

-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------


  KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)


--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED
    variable v_MEM         : std_logic_vector(ARRAY_SIZE - 1 downto 0) := ( others => '0' ); 
    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer;
    variable v_RADDR_A     : integer;
    variable v_WADDR_B     : integer;
    variable v_RADDR_B     : integer;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
       (v_WADDR_A*WDATA_WIDTH_A = v_WADDR_B*WDATA_WIDTH_B
              or
           (WDATA_WIDTH_A > WDATA_WIDTH_B and 
           (v_WADDR_A+1)*WDATA_WIDTH_A > v_WADDR_B*WDATA_WIDTH_B and
           v_WADDR_A*WDATA_WIDTH_A <= v_WADDR_B*WDATA_WIDTH_B)
              or
           (WDATA_WIDTH_B > WDATA_WIDTH_A and 
           (v_WADDR_B+1)*WDATA_WIDTH_B > v_WADDR_B*WDATA_WIDTH_A and
           v_WADDR_B*WDATA_WIDTH_B <= v_WADDR_A*WDATA_WIDTH_A)
          )) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1') then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;


-- ************************************************************************
--
--  Block Memory: Behavioral Model
--  The kernel of other RAM applications  
--
-- ************************************************************************
--
--  Init: Sep. 10, 2001
--  Written by: Zhou Xiao-qiu
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 224/226
--
-- ************************************************************************
--
--  Filename:  SC_BLOCK_RAM.vhd
--  Description: 16K X 1  BRAM behavioral model. 
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************
library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_16K_SYNC is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 262144;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0);
         WCLK : in  STD_LOGIC;
         RCLK : in  STD_LOGIC
	); 

end SC_BRAM_16K_SYNC;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_16K_SYNC is


procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => '0');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => '0');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => '0');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => '0');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal WCLK_node   : std_logic := 'X';
signal RCLK_node   : std_logic := 'X';
-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

 WCLK_node <= WCLK;
 RCLK_node <= RCLK;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------


  --KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)
KERNEL_BEHAV : process( WCLK_node, RCLK_node)

--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED
    variable v_MEM         : std_logic_vector(ARRAY_SIZE - 1 downto 0) := ( others => '0' ); 
    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer;
    variable v_RADDR_A     : integer;
    variable v_WADDR_B     : integer;
    variable v_RADDR_B     : integer;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
         not( 
          (v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) < (v_WADDR_B*WDATA_WIDTH_B) 
                         or
          (v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) < (v_WADDR_A*WDATA_WIDTH_A)
         )
        ) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1' and WCLK_node'event and WCLK_node = '1' ) then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1' and WCLK_node'event and WCLK_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1' and RCLK_node'event and RCLK_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1' and RCLK_node'event and RCLK_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;


-- ************************************************************************
--
--  Block Memory: Behavioral Model
--  The kernel of other RAM applications  
--
-- ************************************************************************
--
--  Init: Sep. 10, 2001
--  Written by: Zhou Xiao-qiu
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 224/226
--
-- ************************************************************************
--
--  Filename:  SC_BLOCK_RAM_L.vhd
--  Description: BRAM behavioral model. 
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************
library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_16K_L_SYNC is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 262144;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0);
         WCLK : in  STD_LOGIC;
         RCLK : in  STD_LOGIC
	); 

end SC_BRAM_16K_L_SYNC;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_16K_L_SYNC is

procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => '0');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => '0');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => '0');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => '0');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal WCLK_node   : std_logic := 'X';
signal RCLK_node   : std_logic := 'X';
-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

 WCLK_node <= WCLK;
 RCLK_node <= RCLK;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------


  --KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)
KERNEL_BEHAV : process( WCLK_node, RCLK_node)

--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED
    variable v_MEM         : std_logic_vector(ARRAY_SIZE*WDATA_WIDTH_A - 1 downto 0) := ( others => '0' ); 
    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer;
    variable v_RADDR_A     : integer;
    variable v_WADDR_B     : integer;
    variable v_RADDR_B     : integer;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
         not( 
          (v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) < (v_WADDR_B*WDATA_WIDTH_B) 
                         or
          (v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) < (v_WADDR_A*WDATA_WIDTH_A)
         )
        ) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1' and WCLK_node'event and WCLK_node = '1' ) then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1' and WCLK_node'event and WCLK_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1' and RCLK_node'event and RCLK_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1' and RCLK_node'event and RCLK_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;


-- ************************************************************************
--
--  Block Memory: Behavioral Model
--  The kernel of other RAM applications  
--
-- ************************************************************************
--
--  Init: Sep. 10, 2001
--  Written by: Zhou Xiao-qiu
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 224/226
--
-- ************************************************************************
--
--  Filename:  SC_BLOCK_RAM.vhd
--  Description: 16K X 1  BRAM behavioral model. 
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************
library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_PDP_16K is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 262144;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 

end SC_BRAM_PDP_16K;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_PDP_16K is

procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => '0');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => '0');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => '0');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => '0');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');

-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------


  KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)


--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED
    variable v_MEM         : std_logic_vector(ARRAY_SIZE - 1 downto 0) := ( others => '0' ); 
    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer ;
    variable v_RADDR_A     : integer ;
    variable v_WADDR_B     : integer ;
    variable v_RADDR_B     : integer ;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
         not( 
          (v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) < (v_WADDR_B*WDATA_WIDTH_B) 
                         or
          (v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) < (v_WADDR_A*WDATA_WIDTH_A)
         )
        ) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1') then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;


-- ************************************************************************
--
--  Block Memory: Behavioral Model
--  The kernel of other RAM applications  
--
-- ************************************************************************
--
--  Init: Sep. 10, 2001
--  Written by: Zhou Xiao-qiu
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 224/226
--
-- ************************************************************************
--
--  Filename:  SC_BLOCK_RAM.vhd
--  Description: 16K X 1  BRAM behavioral model. 
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************
library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_16K_L is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 262144;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 

end SC_BRAM_16K_L;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_16K_L is

procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;
--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => '0');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => '0');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => '0');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => '0');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');

-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------

  KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)


--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED
--QQ 7_17 variable v_MEM         : std_logic_vector(ARRAY_SIZE - 1 downto 0) := ( others => '0' ); 

    variable v_MEM         : std_logic_vector(ARRAY_SIZE*WDATA_WIDTH_A + WDATA_WIDTH_A - 1 downto 0) := ( others => '0' ); 
    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer;
    variable v_RADDR_A     : integer;
    variable v_WADDR_B     : integer;
    variable v_RADDR_B     : integer;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
       (v_WADDR_A*WDATA_WIDTH_A = v_WADDR_B*WDATA_WIDTH_B
              or
           (WDATA_WIDTH_A > WDATA_WIDTH_B and 
           (v_WADDR_A+1)*WDATA_WIDTH_A > v_WADDR_B*WDATA_WIDTH_B and
           v_WADDR_A*WDATA_WIDTH_A <= v_WADDR_B*WDATA_WIDTH_B)
              or
           (WDATA_WIDTH_B > WDATA_WIDTH_A and 
           (v_WADDR_B+1)*WDATA_WIDTH_B > v_WADDR_B*WDATA_WIDTH_A and
           v_WADDR_B*WDATA_WIDTH_B <= v_WADDR_A*WDATA_WIDTH_A)
          )) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1') then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;




library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_PDP_16K_L is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 262144;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 

end SC_BRAM_PDP_16K_L;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_PDP_16K_L is

procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => '0');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => '0');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => '0');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => '0');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');

-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------

  KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)


--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED

          variable v_MEM         : std_logic_vector(ARRAY_SIZE - 1 downto 0) := ( others => '0' );  

    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer;
    variable v_RADDR_A     : integer;
    variable v_WADDR_B     : integer;
    variable v_RADDR_B     : integer;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
         not( 
          (v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) < (v_WADDR_B*WDATA_WIDTH_B) 
                         or
          (v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) < (v_WADDR_A*WDATA_WIDTH_A)
         )
        ) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1') then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;



---------------------------------------------------------
--
--  CAM (Content Addressable Memory)
--  Behavioral Model
--  VHDL
--
---------------------------------------------------------
--
-- Init: Nov. 2001
-- Written by: Zhou Xiao-qiu (Sean ZHOU)
-- Email: xqzhou@lscsh.latticesemi.com
-- Tel: 86-21-64852865 ext. 226
--
---------------------------------------------------------
-- 
-- Filename: SC_CAM.vhd
-- Description: CAM behavioral model.
--
---------------------------------------------------------
--
--
-- Main Body of CAM Description
-- 
--
--
---------------------------------------------------------
-- History
--1. 12.5 Support "Z" as never match;
--
---------------------------------------------------------
-- Library Declarations
---------------------------------------------------------

library ieee;
use  ieee.std_logic_1164.all;
use  ieee.std_logic_unsigned.all;
use  ieee.std_logic_arith.all;
use  std.textio.all;

---------------------------------------------------------
-- Main Entity SC_CAM_16K
-- Description: 
---------------------------------------------------------

entity SC_CAM_16K is

	generic (
		DEVICE_FAMILY : string  := "SuperCool";
		ADDR_WIDTH    : integer :=  7;
		DATA_WIDTH    : integer := 48;
                MEM_INIT_FLAG : integer :=  0;  
	        MEM_INIT_FILE : string  := ""
		);
	port (
		CE        :  in  STD_LOGIC ;
		WE        :  in  STD_LOGIC ;
		CLK       :  in  STD_LOGIC ;
		EN_MASK   :  in  STD_LOGIC ;
		WR_MASK   :  in  STD_LOGIC ;
		WR_DC     :  in  STD_LOGIC ;
		RST       :  in  STD_LOGIC ;
		CS        :  in  STD_LOGIC_VECTOR ( 1 downto 0) ;
		WAD       :  in  STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		WD        :  in  STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0);
		CO        :  out STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		MATCH     :  out STD_LOGIC;
		MUL_MATCH :  out STD_LOGIC
		);

end SC_CAM_16K ;

---------------------------------------------------------
-- Architecture LATTICE_BEHAV for Entity SC_CAM_16K
---------------------------------------------------------

architecture LATTICE_BEHAV of SC_CAM_16K is

---------------------------------------------------------
-- Procedure: READ_CAM_INIT_FILE
-- Return: 
---------------------------------------------------------
procedure READ_CAM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (DATA_WIDTH downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**ADDR_WIDTH)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to DATA_WIDTH - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

	elsif (v_CHAR = 'X') then
          v_MEM(v_OFFSET + k) := 'X';

--Support Never Match<
	elsif (v_CHAR = 'Z') then
          v_MEM(v_OFFSET + k) := 'Z';
	end if;
--Support Never Match>
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + DATA_WIDTH;

    end loop;

  end READ_CAM_INIT_FILE;


---------------------------------------------------------
-- Function: TO_STRING
-- Return: STD_LOGIC_VECTOR TO STRING
---------------------------------------------------------
 function TO_STRING ( INPUT_VECTOR : std_logic_vector; INPUT_LENGTH: integer)
 return string is

   variable vDATA_STRI: string(INPUT_LENGTH downto 1);
   variable vTRANS: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
 
 begin 
    vTRANS := INPUT_VECTOR;

    for i in INPUT_LENGTH downto 1 loop
      if (vTRANS(i-1) = '1') then
        vDATA_STRI(i) := '1';
      elsif ( vTRANS(i-1) ='0') then
        vDATA_STRI(i) := '0';
      end if;  
    end loop;

  return vDATA_STRI; 	  
 end TO_STRING; 

---------------------------------------------------------
-- Function: WRITE_DATA_ENCODER
-- Return: DATA to write to MEM Array
---------------------------------------------------------
 function WRITE_DATA_ENCODER ( WR_DONT_CARE: std_logic; 
                               UPDATA_DATA : std_logic_vector;
			       MASK_DATA   : std_logic_vector;
			       EN_MASK_REG : std_logic
			      )
 return std_logic_vector is
   variable vWRITE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vWRITE_DATA := UPDATA_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vWRITE_DATA(i) := UPDATA_DATA(i);
	    elsif ( MASK_DATA(i) = '1' and WR_DONT_CARE = '1') then
	    	vWRITE_DATA(i) := 'X';
	    end if;
	  end loop;
        end if;

	return vWRITE_DATA;
 end WRITE_DATA_ENCODER;

---------------------------------------------------------
-- Function: COMPARE_DATA_ENCODER
-- Return: DATA to Compare with MEM contain
---------------------------------------------------------
 function COMPARE_DATA_ENCODER ( COMPARE_DATA : std_logic_vector;
 			         MASK_DATA    : std_logic_vector;
			       	 EN_MASK_REG  : std_logic
				 )
 return std_logic_vector is
   variable vCOMPARE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vCOMPARE_DATA := COMPARE_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vCOMPARE_DATA(i) := COMPARE_DATA(i);
	    elsif ( MASK_DATA(i) = '1' ) then
	    	vCOMPARE_DATA(i) := 'X';
	    end if;
	  end loop;
	end if;

	return vCOMPARE_DATA;
	
 end COMPARE_DATA_ENCODER;
						       
---------------------------------------------------------
-- Function: OUTPUT_ENCODER
-- Return: Binary encoded address
---------------------------------------------------------
 function OUTPUT_ENCODER (UNEN_CAM_OUT: std_logic_vector)
 return std_logic_vector is
   variable vPOINTER : integer := 0;
   variable default_value : std_logic_vector(ADDR_WIDTH-1 downto 0);
 begin
        default_value(ADDR_WIDTH-1) := '1';
        default_value(ADDR_WIDTH-2 downto 0) := (others => '0');

        if (UNEN_CAM_OUT = 0) then
            vPOINTER := CONV_INTEGER(default_value);
        end if;

 	for i in UNEN_CAM_OUT'high downto UNEN_CAM_OUT'low loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vPOINTER := i;
	  end if;
	end loop;
	
	return CONV_STD_LOGIC_VECTOR(vPOINTER, ADDR_WIDTH);
 end OUTPUT_ENCODER;

---------------------------------------------------------
-- Function: MATCH_FLAG
-- Return: MATCH_OUT Flag 
---------------------------------------------------------
 function MATCH_FLAG (UNEN_CAM_OUT: std_logic_vector)
 return std_logic is
   variable vMATCH_FLAG: std_logic := '0';
 begin
        vMATCH_FLAG := '0';
	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vMATCH_FLAG := '1';
	    return vMATCH_FLAG;
	  end if;
	end loop;
	return vMATCH_FLAG;

 end MATCH_FLAG;

---------------------------------------------------------
-- Function: MUL_MATCH_FLAG
-- Return: MUL_MATCH_OUT Flag 
---------------------------------------------------------
 function MUL_MATCH_FLAG (UNEN_CAM_OUT: std_logic_vector)
 return std_logic is

   variable vMUL_MATCH_FLAG: std_logic := '0';
   variable vMATCH_COUNTE: integer := 0;
 begin
 	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vMATCH_COUNTE := vMATCH_COUNTE + 1;
	  end if;
	end loop;

	
	if (vMATCH_COUNTE > 1) then
	  vMUL_MATCH_FLAG := '1';
        else
	  vMUL_MATCH_FLAG := '0';
	end if;
	
	return vMUL_MATCH_FLAG;

 end MUL_MATCH_FLAG;
---------------------------------------------------------
-- Function: WORD_COMPARE
-- Return: Compare Result
---------------------------------------------------------
 function WORD_COMPARE (BRAM_DATA : std_logic_vector;
 			COMP_DATA : std_logic_vector
			)
 return std_logic is
   variable vWORD_FLAG: std_logic := '1';
   variable vCOMP_SECT: std_logic_vector(DATA_WIDTH -1 downto 0) := (others => '0');
 begin
 	vCOMP_SECT := BRAM_DATA;
	
 	for i in vCOMP_SECT'low to vCOMP_SECT'high  loop
	  if ( COMP_DATA(i) /= 'X' and vCOMP_SECT(i) /= 'X') then
	    
	    if ( vCOMP_SECT(i) /= COMP_DATA(i) or vCOMP_SECT(i)= 'Z')  then
	      vWORD_FLAG := '0';
	      return vWORD_FLAG;
	    end if;
	  end if;
	end loop;
	
	return vWORD_FLAG;
 end WORD_COMPARE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

---------------------------------------------------------
-- Signal Declaration 
---------------------------------------------------------

-- Input Nodes
 signal  CE_node        : STD_LOGIC := 'X' ;
 signal  WE_node        : STD_LOGIC := 'X' ;
 signal  CLK_node       : STD_LOGIC := 'X' ;
 signal  EN_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_DC_node     : STD_LOGIC := 'X' ;
 signal  RST_node       : STD_LOGIC := 'X' ;
 signal  CS_node        : STD_LOGIC_VECTOR ( 1 downto 0) := (others => 'X') ;
 signal  WAD_node       : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WD_node        : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- Register Nodes  
 signal  EN_MASK_reg    : STD_LOGIC := 'X' ;
 signal  MASK_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  COMP_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WAD_reg        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WEN_reg        : STD_LOGIC := 'X' ;
 signal  WR_DC_reg      : STD_LOGIC := 'X' ;
 
-- From WRITE_DATA_ENCODER to CAM Array
 signal  WRITE_DATA_node   : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;

-- From COMPARE_DATA_ENCODER to CAM Array
 signal  COMPARE_DATA_node : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 signal  UNEN_CAM_OUT_node : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0) := (others => 'X') ;

-- Output Nodes 
 signal  CO_node        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  MATCH_node     : STD_LOGIC := 'X' ;
 signal  MUL_MATCH_node : STD_LOGIC := 'X' ;

--------------------------------------------------------- 
-- Architecture 
---------------------------------------------------------
 begin


	CE_node      <= CE ;
	WE_node      <= WE ;
	CLK_node     <= CLK ;
	EN_MASK_node <= EN_MASK ;
	WR_MASK_node <= WR_MASK ;
	WR_DC_node   <= WR_DC ;
	RST_node     <= RST ;
	CS_node      <= CS ;
	WAD_node     <= WAD ;
	WD_node      <= WD ;
	
	CO           <= CO_node ;
	MATCH        <= MATCH_node ;
	MUL_MATCH    <= MUL_MATCH_node ;

Mul_Match_pro: process(UNEN_CAM_OUT_node)
     begin
	MUL_MATCH_node <= MUL_MATCH_FLAG(UNEN_CAM_OUT_node);
	MATCH_node     <= MATCH_FLAG(UNEN_CAM_OUT_node);
        CO_node      <= OUTPUT_ENCODER(UNEN_CAM_OUT_node);
     end process;

Write_Data_node_pro: process(WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg)
     begin
	WRITE_DATA_node <= WRITE_DATA_ENCODER(WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
     end process;

Compare_Data_pro: process(COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg)
     begin
	COMPARE_DATA_node <= COMPARE_DATA_ENCODER(COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
     end process;

   
---------------------------------------------------------
-- Process
-- Register EN_MASK/ COMP_DATA/ WAD/ WEN/ WR_DC inputs 
---------------------------------------------------------

  register_inputs: process (RST_node, CLK_node)
  begin
  	if (RST_node = '1') then
		EN_MASK_reg   <= '0';
		COMP_DATA_reg <= (others => '0');
		WAD_reg       <= (others => '0');
		WEN_reg        <= '0';
		WR_DC_reg     <= '0';
	elsif (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1') then
			EN_MASK_reg   <= EN_MASK_node;
			COMP_DATA_reg <= WD_node;
			WAD_reg       <= WAD_node;
			WEN_reg       <= WE_node and CS_node(0) and CS_node(1);
			WR_DC_reg     <= WR_DC_node;
		end if;
	end if;
  end process register_inputs;

---------------------------------------------------------
-- Process
-- Register WD input to MASK_DATA_reg  
-- Note:
-- TSPEC Rev D Page 64 of 96 Note 3 
-- "The reset on mask data register is not provided"
---------------------------------------------------------

  register_WD_2_MASK_DATA: process (CLK_node)
  begin
   	if (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1' and WR_MASK_node = '1') then
			MASK_DATA_reg <= WD_node;
		end if;
	end if;
  end process register_WD_2_MASK_DATA;

---------------------------------------------------------
-- Process
-- CAM_KERNEL
---------------------------------------------------------

  CAM_KERNEL : process (WEN_reg, WAD_reg, COMPARE_DATA_node, WRITE_DATA_node)
  	
    variable vADDR : integer := 0;
    variable vUNEN_CAM_OUT : std_logic_vector (2**ADDR_WIDTH -1 downto 0) := (others => '0');
    variable vMEM          : std_logic_vector (2**ADDR_WIDTH*DATA_WIDTH -1 downto 0) := ( others => 'Z');
    variable v_WAD_Valid_Flag : boolean := TRUE;
    variable v_INI_DONE    : boolean := FALSE;

    begin
    
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_CAM_INIT_FILE(MEM_INIT_FILE, vMEM);
	v_INI_DONE := TRUE;
    end if;

    v_WAD_Valid_Flag := Valid_Address(WAD_reg);	

    if (v_WAD_Valid_Flag = TRUE) then
 	vADDR := CONV_INTEGER(WAD_reg);

    --else
    --  assert false
    --    report "Write Address of Port contains invalid bit!"
    --    severity warning;

    end if;	

    if (WEN_reg = '1') then
    	vMEM((vADDR*DATA_WIDTH + DATA_WIDTH -1) downto (vADDR*DATA_WIDTH)) := WRITE_DATA_node;
        for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';
          else 
	    vUNEN_CAM_OUT(i) := '0';
	  end if;
	UNEN_CAM_OUT_node(i) <= vUNEN_CAM_OUT(i);
	end loop;
--	UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;
    
    elsif (WEN_reg = '0') then
    	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';
          else 
	    vUNEN_CAM_OUT(i) := '0';
	  end if;
	end loop;
	UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;	
	    
    end if;


end process CAM_KERNEL;

end LATTICE_BEHAV;



---------------------------------------------------------
--
--  CAM (Content Addressable Memory)
--  Behavioral Model
--  VHDL
--
---------------------------------------------------------
--
-- Init: Apr. 2002
-- Written by: Zhou Xiao-qiu (Sean ZHOU)
-- Email: xqzhou@lscsh.latticesemi.com
-- Tel: 86-21-64852865 ext. 226
--
---------------------------------------------------------
-- 
-- Filename: SC_CAM_CL.vhd
-- Description: CAM behavioral model.
-- Used for width cascading left
--
---------------------------------------------------------
--
--
-- Main Body of CAM Description
-- 
--
--
---------------------------------------------------------
-- History
--1. 12.5 Support "Z" as never match;
--
---------------------------------------------------------
-- Library Declarations
---------------------------------------------------------

library ieee;
use  ieee.std_logic_1164.all;
use  ieee.std_logic_unsigned.all;
use  ieee.std_logic_arith.all;
use  std.textio.all;

---------------------------------------------------------
-- Main Entity SC_CAMCL_16K
-- Description: 
---------------------------------------------------------

entity SC_CAMCL_16K is

	generic (
		DEVICE_FAMILY : string := "SuperCool";
		ADDR_WIDTH    : integer :=  7;
		DATA_WIDTH    : integer := 48;
                MEM_INIT_FLAG : integer :=  0;  
	        MEM_INIT_FILE : string  := ""

		);
	port (
		CE        :  in  STD_LOGIC ;
		WE        :  in  STD_LOGIC ;
		CLK       :  in  STD_LOGIC ;
		EN_MASK   :  in  STD_LOGIC ;
		WR_MASK   :  in  STD_LOGIC ;
		WR_DC     :  in  STD_LOGIC ;
		RST       :  in  STD_LOGIC ;
		CS        :  in  STD_LOGIC_VECTOR ( 1 downto 0) ;
		WAD       :  in  STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		WD        :  in  STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0);
		--CO        :  out STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		--MATCH     :  out STD_LOGIC;
		--MUL_MATCH :  out STD_LOGIC
                CMO       : out  STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0)
		);

end SC_CAMCL_16K ;




---------------------------------------------------------
-- Architecture LATTICE_BEHAV for Entity SC_CAMCL_16K
---------------------------------------------------------

architecture LATTICE_BEHAV of SC_CAMCL_16K is
---------------------------------------------------------
-- Procedure: READ_CAM_INIT_FILE
-- Return: 
---------------------------------------------------------
procedure READ_CAM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (DATA_WIDTH downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**ADDR_WIDTH)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to DATA_WIDTH - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

	elsif (v_CHAR = 'X') then
          v_MEM(v_OFFSET + k) := 'X';

--Support Never Match<
	elsif (v_CHAR = 'Z') then
          v_MEM(v_OFFSET + k) := 'Z';
	end if;
--Support Never Match>

      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + DATA_WIDTH;

    end loop;

  end READ_CAM_INIT_FILE;


---------------------------------------------------------
-- Function: TO_STRING
-- Return: STD_LOGIC_VECTOR TO STRING
---------------------------------------------------------
 function TO_STRING ( INPUT_VECTOR : std_logic_vector; INPUT_LENGTH: integer)
 return string is

   variable vDATA_STRI: string(INPUT_LENGTH downto 1);
   variable vTRANS: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
 
 begin 
    vTRANS := INPUT_VECTOR;

    for i in INPUT_LENGTH downto 1 loop
      if (vTRANS(i-1) = '1') then
        vDATA_STRI(i) := '1';
      elsif ( vTRANS(i-1) ='0') then
        vDATA_STRI(i) := '0';
      end if;  
    end loop;

  return vDATA_STRI; 	  
 end TO_STRING; 

---------------------------------------------------------
-- Function: WRITE_DATA_ENCODER
-- Return: DATA to write to MEM Array
---------------------------------------------------------
 function WRITE_DATA_ENCODER ( WR_DONT_CARE: std_logic; 
                               UPDATA_DATA : std_logic_vector;
			       MASK_DATA   : std_logic_vector;
			       EN_MASK_REG : std_logic
			      )
 return std_logic_vector is
   variable vWRITE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vWRITE_DATA := UPDATA_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vWRITE_DATA(i) := UPDATA_DATA(i);
	    elsif ( MASK_DATA(i) = '1' and WR_DONT_CARE = '1') then
	    	vWRITE_DATA(i) := 'X';
	    end if;
	  end loop;
        end if;

	return vWRITE_DATA;
 end WRITE_DATA_ENCODER;

---------------------------------------------------------
-- Function: COMPARE_DATA_ENCODER
-- Return: DATA to Compare with MEM contain
---------------------------------------------------------
 function COMPARE_DATA_ENCODER ( COMPARE_DATA : std_logic_vector;
 			         MASK_DATA    : std_logic_vector;
			       	 EN_MASK_REG  : std_logic
				 )
 return std_logic_vector is
   variable vCOMPARE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vCOMPARE_DATA := COMPARE_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vCOMPARE_DATA(i) := COMPARE_DATA(i);
	    elsif ( MASK_DATA(i) = '1' ) then
	    	vCOMPARE_DATA(i) := 'X';
	    end if;
	  end loop;
	end if;

	return vCOMPARE_DATA;
	
 end COMPARE_DATA_ENCODER;
						       
---------------------------------------------------------
-- Function: OUTPUT_ENCODER
-- Return: Binary encoded address
---------------------------------------------------------
 function OUTPUT_ENCODER (UNEN_CAM_OUT: std_logic_vector)
 return std_logic_vector is
   variable vPOINTER : integer := 0;
   variable default_value : std_logic_vector(ADDR_WIDTH-1 downto 0);
 begin
        default_value(ADDR_WIDTH-1) := '1';
        default_value(ADDR_WIDTH-2 downto 0) := (others => '0');

        if (UNEN_CAM_OUT = 0) then
            vPOINTER := CONV_INTEGER(default_value);
        end if;

 	for i in UNEN_CAM_OUT'high downto UNEN_CAM_OUT'low loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vPOINTER := i;
	  end if;
	end loop;
	
	return CONV_STD_LOGIC_VECTOR(vPOINTER, ADDR_WIDTH);
 end OUTPUT_ENCODER;

---------------------------------------------------------
-- Function: WORD_COMPARE
-- Return: Compare Result
---------------------------------------------------------
 function WORD_COMPARE (BRAM_DATA : std_logic_vector;
 			COMP_DATA : std_logic_vector
			)
 return std_logic is
   variable vWORD_FLAG: std_logic := '1';
   variable vCOMP_SECT: std_logic_vector(DATA_WIDTH -1 downto 0) := (others => '0');
 begin
 	vCOMP_SECT := BRAM_DATA;
	
 	for i in vCOMP_SECT'low to vCOMP_SECT'high  loop
	  if ( COMP_DATA(i) /= 'X' and vCOMP_SECT(i) /= 'X') then
	    
	    if ( vCOMP_SECT(i) /= COMP_DATA(i) or vCOMP_SECT(i) = 'Z')  then
	      vWORD_FLAG := '0';
	      return vWORD_FLAG;
	    end if;
	  end if;
	end loop;
	
	return vWORD_FLAG;
 end WORD_COMPARE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

---------------------------------------------------------
-- Signal Declaration 
---------------------------------------------------------

-- Input Nodes
 signal  CE_node        : STD_LOGIC := 'X' ;
 signal  WE_node        : STD_LOGIC := 'X' ;
 signal  CLK_node       : STD_LOGIC := 'X' ;
 signal  EN_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_DC_node     : STD_LOGIC := 'X' ;
 signal  RST_node       : STD_LOGIC := 'X' ;
 signal  CS_node        : STD_LOGIC_VECTOR ( 1 downto 0) := (others => 'X') ;
 signal  WAD_node       : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WD_node        : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- Register Nodes  
 signal  EN_MASK_reg    : STD_LOGIC := 'X' ;
 signal  MASK_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  COMP_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WAD_reg        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WEN_reg        : STD_LOGIC := 'X' ;
 signal  WR_DC_reg      : STD_LOGIC := 'X' ;
 
-- From WRITE_DATA_ENCODER to CAM Array
 signal  WRITE_DATA_node   : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;

-- From COMPARE_DATA_ENCODER to CAM Array
 signal  COMPARE_DATA_node : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 --signal  UNEN_CAM_OUT_node : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0) := (others => 'X') ;

-- Output Nodes 
 --signal  CO_node        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 --signal  MATCH_node     : STD_LOGIC := 'X' ;
 --signal  MUL_MATCH_node : STD_LOGIC := 'X' ;
 signal  CMO_node         : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0);
--------------------------------------------------------- 
-- Architecture 
---------------------------------------------------------
 begin


	CE_node      <= CE ;
	WE_node      <= WE ;
	CLK_node     <= CLK ;
	EN_MASK_node <= EN_MASK ;
	WR_MASK_node <= WR_MASK ;
	WR_DC_node   <= WR_DC ;
	RST_node     <= RST ;
	CS_node      <= CS ;
	WAD_node     <= WAD ;
	WD_node      <= WD ;
	
--	CO           <= CO_node ;
--	MATCH        <= MATCH_node ;
--	MUL_MATCH    <= MUL_MATCH_node ;
--
--	MUL_MATCH_node <= MUL_MATCH_FLAG(UNEN_CAM_OUT_node);
--	MATCH_node     <= MATCH_FLAG(UNEN_CAM_OUT_node);
        CMO          <= CMO_node;

	WRITE_DATA_node <= WRITE_DATA_ENCODER(WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	COMPARE_DATA_node <= COMPARE_DATA_ENCODER(COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
        
--        CO_node      <= OUTPUT_ENCODER(UNEN_CAM_OUT_node);
   
---------------------------------------------------------
-- Process
-- Register EN_MASK/ COMP_DATA/ WAD/ WEN/ WR_DC inputs 
---------------------------------------------------------

  register_inputs: process (RST_node, CLK_node)
  begin
  	if (RST_node = '1') then
		EN_MASK_reg   <= '0';
		COMP_DATA_reg <= (others => '0');
		WAD_reg       <= (others => '0');
		WEN_reg        <= '0';
		WR_DC_reg     <= '0';
	elsif (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1') then
			EN_MASK_reg   <= EN_MASK_node;
			COMP_DATA_reg <= WD_node;
			WAD_reg       <= WAD_node;
			WEN_reg       <= WE_node and CS_node(0) and CS_node(1);
			WR_DC_reg     <= WR_DC_node;
		end if;
	end if;
  end process register_inputs;

---------------------------------------------------------
-- Process
-- Register WD input to MASK_DATA_reg  
-- Note:
-- TSPEC Rev D Page 64 of 96 Note 3 
-- "The reset on mask data register is not provided"
---------------------------------------------------------

  register_WD_2_MASK_DATA: process (CLK_node)
  begin
   	if (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1' and WR_MASK_node = '1') then
			MASK_DATA_reg <= WD_node;
		end if;
	end if;
  end process register_WD_2_MASK_DATA;

---------------------------------------------------------
-- Process
-- CAM_KERNEL
---------------------------------------------------------

  CAM_KERNEL : process (WEN_reg, WAD_reg, COMPARE_DATA_node, WRITE_DATA_node)
  	
    variable vADDR : integer := 0;
    variable vUNEN_CAM_OUT : std_logic_vector (2**ADDR_WIDTH -1 downto 0) := (others => '0');
    variable vMEM          : std_logic_vector (2**ADDR_WIDTH*DATA_WIDTH -1 downto 0) := ( others => 'Z');
    variable v_WAD_Valid_Flag : boolean := TRUE;
    variable v_INI_DONE    : boolean := FALSE;

    begin
    
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_CAM_INIT_FILE(MEM_INIT_FILE, vMEM);
	v_INI_DONE := TRUE;
    end if;

    v_WAD_Valid_Flag := Valid_Address(WAD_reg);	

    if (v_WAD_Valid_Flag = TRUE) then
 	vADDR := CONV_INTEGER(WAD_reg);

    --else
    --  assert false
    --    report "Write Address of Port contains invalid bit!"
    --    severity warning;

    end if;	

    if (WEN_reg = '1') then
    	vMEM((vADDR*DATA_WIDTH + DATA_WIDTH -1) downto (vADDR*DATA_WIDTH)) := WRITE_DATA_node;
      for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';

          else 
	    vUNEN_CAM_OUT(i) := '0';

    	  end if;
      end loop;

	--UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;	
        CMO_node <= vUNEN_CAM_OUT;	
    
    elsif (WEN_reg = '0') then
    	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';

          else 
	    vUNEN_CAM_OUT(i) := '0';

    	  end if;
	end loop;

	--UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;	
        CMO_node <= vUNEN_CAM_OUT;	

    end if;

		
end process CAM_KERNEL;

end LATTICE_BEHAV;



---------------------------------------------------------
--
--  CAM (Content Addressable Memory)
--  Behavioral Model
--  VHDL
--
---------------------------------------------------------
--
-- Init: Apr. 2002
-- Written by: Zhou Xiao-qiu (Sean ZHOU)
-- Email: xqzhou@lscsh.latticesemi.com
-- Tel: 86-21-64852865 ext. 226
--
---------------------------------------------------------
-- 
-- Filename: SC_CAM_CL.vhd
-- Description: CAM behavioral model.
-- Used for width cascading middle
--
---------------------------------------------------------
--
--
-- Main Body of CAM Description
-- 
--
--
---------------------------------------------------------
-- History
--1. 12.5 Support "Z" as never match;
--
---------------------------------------------------------
-- Library Declarations
---------------------------------------------------------

library ieee;
use  ieee.std_logic_1164.all;
use  ieee.std_logic_unsigned.all;
use  ieee.std_logic_arith.all;
use  std.textio.all;

---------------------------------------------------------
-- Main Entity SC_CAMCM_16K
-- Description: 
---------------------------------------------------------

entity SC_CAMCM_16K is

	generic (
		DEVICE_FAMILY : string := "SuperCool";
		ADDR_WIDTH    : integer :=  7;
		DATA_WIDTH    : integer := 48;
                MEM_INIT_FLAG : integer :=  0;  
	        MEM_INIT_FILE : string  := ""

		);
	port (
		CE        :  in  STD_LOGIC ;
		WE        :  in  STD_LOGIC ;
		CLK       :  in  STD_LOGIC ;
		EN_MASK   :  in  STD_LOGIC ;
		WR_MASK   :  in  STD_LOGIC ;
		WR_DC     :  in  STD_LOGIC ;
		RST       :  in  STD_LOGIC ;
		CS        :  in  STD_LOGIC_VECTOR ( 1 downto 0) ;
		WAD       :  in  STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		WD        :  in  STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0);
                CMI       :  in  STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0);
		--CO        :  out STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		--MATCH     :  out STD_LOGIC;
		--MUL_MATCH :  out STD_LOGIC
                CMO       : out  STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0)
		);

end SC_CAMCM_16K ;




---------------------------------------------------------
-- Architecture LATTICE_BEHAV for Entity SC_CAMCM_16K
---------------------------------------------------------

architecture LATTICE_BEHAV of SC_CAMCM_16K is
---------------------------------------------------------
-- Procedure: READ_CAM_INIT_FILE
-- Return: 
---------------------------------------------------------
procedure READ_CAM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (DATA_WIDTH downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**ADDR_WIDTH)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to DATA_WIDTH - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

	elsif (v_CHAR = 'X') then
          v_MEM(v_OFFSET + k) := 'X';

--Support Never Match<
	elsif (v_CHAR = 'Z') then
          v_MEM(v_OFFSET + k) := 'Z';
	end if;
--Support Never Match>

      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + DATA_WIDTH;

    end loop;

  end READ_CAM_INIT_FILE;


---------------------------------------------------------
-- Function: TO_STRING
-- Return: STD_LOGIC_VECTOR TO STRING
---------------------------------------------------------
 function TO_STRING ( INPUT_VECTOR : std_logic_vector; INPUT_LENGTH: integer)
 return string is

   variable vDATA_STRI: string(INPUT_LENGTH downto 1);
   variable vTRANS: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
 
 begin 
    vTRANS := INPUT_VECTOR;

    for i in INPUT_LENGTH downto 1 loop
      if (vTRANS(i-1) = '1') then
        vDATA_STRI(i) := '1';
      elsif ( vTRANS(i-1) ='0') then
        vDATA_STRI(i) := '0';
      end if;  
    end loop;

  return vDATA_STRI; 	  
 end TO_STRING; 

---------------------------------------------------------
-- Function: WRITE_DATA_ENCODER
-- Return: DATA to write to MEM Array
---------------------------------------------------------
 function WRITE_DATA_ENCODER ( WR_DONT_CARE: std_logic; 
                               UPDATA_DATA : std_logic_vector;
			       MASK_DATA   : std_logic_vector;
			       EN_MASK_REG : std_logic
			      )
 return std_logic_vector is
   variable vWRITE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vWRITE_DATA := UPDATA_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vWRITE_DATA(i) := UPDATA_DATA(i);
	    elsif ( MASK_DATA(i) = '1' and WR_DONT_CARE = '1') then
	    	vWRITE_DATA(i) := 'X';
	    end if;
	  end loop;
        end if;

	return vWRITE_DATA;
 end WRITE_DATA_ENCODER;

---------------------------------------------------------
-- Function: COMPARE_DATA_ENCODER
-- Return: DATA to Compare with MEM contain
---------------------------------------------------------
 function COMPARE_DATA_ENCODER ( COMPARE_DATA : std_logic_vector;
 			         MASK_DATA    : std_logic_vector;
			       	 EN_MASK_REG  : std_logic
				 )
 return std_logic_vector is
   variable vCOMPARE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vCOMPARE_DATA := COMPARE_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vCOMPARE_DATA(i) := COMPARE_DATA(i);
	    elsif ( MASK_DATA(i) = '1' ) then
	    	vCOMPARE_DATA(i) := 'X';
	    end if;
	  end loop;
	end if;

	return vCOMPARE_DATA;
	
 end COMPARE_DATA_ENCODER;
						       
---------------------------------------------------------
-- Function: OUTPUT_ENCODER
-- Return: Binary encoded address
---------------------------------------------------------
 function OUTPUT_ENCODER (UNEN_CAM_OUT: std_logic_vector)
 return std_logic_vector is
   variable vPOINTER : integer := 0;
   variable default_value : std_logic_vector(ADDR_WIDTH-1 downto 0);
 begin
        default_value(ADDR_WIDTH-1) := '1';
        default_value(ADDR_WIDTH-2 downto 0) := (others => '0');

        if (UNEN_CAM_OUT = 0) then
            vPOINTER := CONV_INTEGER(default_value);
        end if;

 	for i in UNEN_CAM_OUT'high downto UNEN_CAM_OUT'low loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vPOINTER := i;
	  end if;
	end loop;
	
	return CONV_STD_LOGIC_VECTOR(vPOINTER, ADDR_WIDTH);
 end OUTPUT_ENCODER;

---------------------------------------------------------
-- Function: WORD_COMPARE
-- Return: Compare Result
---------------------------------------------------------
 function WORD_COMPARE (BRAM_DATA : std_logic_vector;
 			COMP_DATA : std_logic_vector
			)
 return std_logic is
   variable vWORD_FLAG: std_logic := '1';
   variable vCOMP_SECT: std_logic_vector(DATA_WIDTH -1 downto 0) := (others => '0');
 begin
 	vCOMP_SECT := BRAM_DATA;
	
 	for i in vCOMP_SECT'low to vCOMP_SECT'high  loop
	  if ( COMP_DATA(i) /= 'X' and vCOMP_SECT(i) /= 'X') then
	    
	    if ( vCOMP_SECT(i) /= COMP_DATA(i) or vCOMP_SECT(i) = 'Z')  then
	      vWORD_FLAG := '0';
	      return vWORD_FLAG;
	    end if;
	  end if;
	end loop;
	
	return vWORD_FLAG;
 end WORD_COMPARE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

---------------------------------------------------------
-- Signal Declaration 
---------------------------------------------------------

-- Input Nodes
 signal  CE_node        : STD_LOGIC := 'X' ;
 signal  WE_node        : STD_LOGIC := 'X' ;
 signal  CLK_node       : STD_LOGIC := 'X' ;
 signal  EN_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_DC_node     : STD_LOGIC := 'X' ;
 signal  RST_node       : STD_LOGIC := 'X' ;
 signal  CS_node        : STD_LOGIC_VECTOR ( 1 downto 0) := (others => 'X') ;
 signal  WAD_node       : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WD_node        : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- Register Nodes  
 signal  EN_MASK_reg    : STD_LOGIC := 'X' ;
 signal  MASK_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  COMP_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WAD_reg        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WEN_reg        : STD_LOGIC := 'X' ;
 signal  WR_DC_reg      : STD_LOGIC := 'X' ;
 
-- From WRITE_DATA_ENCODER to CAM Array
 signal  WRITE_DATA_node   : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;

-- From COMPARE_DATA_ENCODER to CAM Array
 signal  COMPARE_DATA_node : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 --signal  UNEN_CAM_OUT_node : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0) := (others => 'X') ;

-- Output Nodes 
 --signal  CO_node        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 --signal  MATCH_node     : STD_LOGIC := 'X' ;
 --signal  MUL_MATCH_node : STD_LOGIC := 'X' ;
 signal  CMI_node         : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0);
 signal  CMO_node         : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0);
--------------------------------------------------------- 
-- Architecture 
---------------------------------------------------------
 begin


	CE_node      <= CE ;
	WE_node      <= WE ;
	CLK_node     <= CLK ;
	EN_MASK_node <= EN_MASK ;
	WR_MASK_node <= WR_MASK ;
	WR_DC_node   <= WR_DC ;
	RST_node     <= RST ;
	CS_node      <= CS ;
	WAD_node     <= WAD ;
	WD_node      <= WD ;
        CMI_node     <= CMI ;	
--	CO           <= CO_node ;
--	MATCH        <= MATCH_node ;
--	MUL_MATCH    <= MUL_MATCH_node ;
--
--	MUL_MATCH_node <= MUL_MATCH_FLAG(UNEN_CAM_OUT_node);
--	MATCH_node     <= MATCH_FLAG(UNEN_CAM_OUT_node);
        CMO          <= CMO_node;

	WRITE_DATA_node <= WRITE_DATA_ENCODER(WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	COMPARE_DATA_node <= COMPARE_DATA_ENCODER(COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
        
--        CO_node      <= OUTPUT_ENCODER(UNEN_CAM_OUT_node);
   
---------------------------------------------------------
-- Process
-- Register EN_MASK/ COMP_DATA/ WAD/ WEN/ WR_DC inputs 
---------------------------------------------------------

  register_inputs: process (RST_node, CLK_node)
  begin
  	if (RST_node = '1') then
		EN_MASK_reg   <= '0';
		COMP_DATA_reg <= (others => '0');
		WAD_reg       <= (others => '0');
		WEN_reg        <= '0';
		WR_DC_reg     <= '0';
	elsif (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1') then
			EN_MASK_reg   <= EN_MASK_node;
			COMP_DATA_reg <= WD_node;
			WAD_reg       <= WAD_node;
			WEN_reg       <= WE_node and CS_node(0) and CS_node(1);
			WR_DC_reg     <= WR_DC_node;
		end if;
	end if;
  end process register_inputs;

---------------------------------------------------------
-- Process
-- Register WD input to MASK_DATA_reg  
-- Note:
-- TSPEC Rev D Page 64 of 96 Note 3 
-- "The reset on mask data register is not provided"
---------------------------------------------------------

  register_WD_2_MASK_DATA: process (CLK_node)
  begin
   	if (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1' and WR_MASK_node = '1') then
			MASK_DATA_reg <= WD_node;
		end if;
	end if;
  end process register_WD_2_MASK_DATA;

---------------------------------------------------------
-- Process
-- CAM_KERNEL
---------------------------------------------------------

  CAM_KERNEL : process (WEN_reg, WAD_reg, COMPARE_DATA_node, WRITE_DATA_node, CMI_node)
  	
    variable vADDR : integer := 0;
    variable vUNEN_CAM_OUT : std_logic_vector (2**ADDR_WIDTH -1 downto 0) := (others => '0');
    variable vMEM          : std_logic_vector (2**ADDR_WIDTH*DATA_WIDTH -1 downto 0) := ( others => 'Z');
    variable v_WAD_Valid_Flag : boolean := TRUE;
    variable v_INI_DONE    : boolean := FALSE;

    begin
    
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_CAM_INIT_FILE(MEM_INIT_FILE, vMEM);
	v_INI_DONE := TRUE;
    end if;

    v_WAD_Valid_Flag := Valid_Address(WAD_reg);	

    if (v_WAD_Valid_Flag = TRUE) then
 	vADDR := CONV_INTEGER(WAD_reg);

    --else
    --  assert false
    --    report "Write Address of Port contains invalid bit!"
    --    severity warning;

    end if;	

    if (WEN_reg = '1') then
    	vMEM((vADDR*DATA_WIDTH + DATA_WIDTH -1) downto (vADDR*DATA_WIDTH)) := WRITE_DATA_node;
	    	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';

          else 
	    vUNEN_CAM_OUT(i) := '0';

    	  end if;
	end loop;

	--UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;	
        CMO_node <= vUNEN_CAM_OUT and CMI_node;	
    
    elsif (WEN_reg = '0') then
    	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';

          else 
	    vUNEN_CAM_OUT(i) := '0';

    	  end if;
	end loop;

	--UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;	
        CMO_node <= vUNEN_CAM_OUT and CMI_node;	

    end if;

		
end process CAM_KERNEL;

end LATTICE_BEHAV;



---------------------------------------------------------
--
--  CAM (Content Addressable Memory)
--  Behavioral Model
--  VHDL
--
---------------------------------------------------------
--
-- Init: Apr. 2002
-- Written by: Zhou Xiao-qiu (Sean ZHOU)
-- Email: xqzhou@lscsh.latticesemi.com
-- Tel: 86-21-64852865 ext. 226
--
---------------------------------------------------------
-- 
-- Filename: SC_CAM_CL.vhd
-- Description: CAM behavioral model.
-- Used for width cascading right
--
---------------------------------------------------------
--
--
-- Main Body of CAM Description
-- 
--
--
---------------------------------------------------------
-- History
--1. 12.5 Support "Z" as never match;
--
---------------------------------------------------------
-- Library Declarations
---------------------------------------------------------

library ieee;
use  ieee.std_logic_1164.all;
use  ieee.std_logic_unsigned.all;
use  ieee.std_logic_arith.all;
use  std.textio.all;

---------------------------------------------------------
-- Main Entity SC_CAMCR_16K
-- Description: 
---------------------------------------------------------

entity SC_CAMCR_16K is

	generic (
		DEVICE_FAMILY : string := "SuperCool";
		ADDR_WIDTH    : integer :=  7;
		DATA_WIDTH    : integer := 48;
                MEM_INIT_FLAG : integer :=  0;  
	        MEM_INIT_FILE : string  := ""

		);
	port (
		CE        :  in  STD_LOGIC ;
		WE        :  in  STD_LOGIC ;
		CLK       :  in  STD_LOGIC ;
		EN_MASK   :  in  STD_LOGIC ;
		WR_MASK   :  in  STD_LOGIC ;
		WR_DC     :  in  STD_LOGIC ;
		RST       :  in  STD_LOGIC ;
		CS        :  in  STD_LOGIC_VECTOR ( 1 downto 0) ;
		WAD       :  in  STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		WD        :  in  STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0);
                CMI       :  in  STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0);
		CO        :  out STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0);
		MATCH     :  out STD_LOGIC;
		MUL_MATCH :  out STD_LOGIC
                );

end SC_CAMCR_16K ;




---------------------------------------------------------
-- Architecture LATTICE_BEHAV for Entity SC_CAMCR_16K
---------------------------------------------------------

architecture LATTICE_BEHAV of SC_CAMCR_16K is
---------------------------------------------------------
-- Procedure: READ_CAM_INIT_FILE
-- Return: 
---------------------------------------------------------
procedure READ_CAM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (DATA_WIDTH downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**ADDR_WIDTH)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to DATA_WIDTH - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

	elsif (v_CHAR = 'X') then
          v_MEM(v_OFFSET + k) := 'X';

--Support Never Match<
	elsif (v_CHAR = 'Z') then
          v_MEM(v_OFFSET + k) := 'Z';
	end if;
--Support Never Match>
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + DATA_WIDTH;

    end loop;

  end READ_CAM_INIT_FILE;


---------------------------------------------------------
-- Function: TO_STRING
-- Return: STD_LOGIC_VECTOR TO STRING
---------------------------------------------------------
 function TO_STRING ( INPUT_VECTOR : std_logic_vector; INPUT_LENGTH: integer)
 return string is

   variable vDATA_STRI: string(INPUT_LENGTH downto 1);
   variable vTRANS: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
 
 begin 
    vTRANS := INPUT_VECTOR;

    for i in INPUT_LENGTH downto 1 loop
      if (vTRANS(i-1) = '1') then
        vDATA_STRI(i) := '1';
      elsif ( vTRANS(i-1) ='0') then
        vDATA_STRI(i) := '0';
      end if;  
    end loop;

  return vDATA_STRI; 	  
 end TO_STRING; 

---------------------------------------------------------
-- Function: WRITE_DATA_ENCODER
-- Return: DATA to write to MEM Array
---------------------------------------------------------
 function WRITE_DATA_ENCODER ( WR_DONT_CARE: std_logic; 
                               UPDATA_DATA : std_logic_vector;
			       MASK_DATA   : std_logic_vector;
			       EN_MASK_REG : std_logic
			      )
 return std_logic_vector is
   variable vWRITE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vWRITE_DATA := UPDATA_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vWRITE_DATA(i) := UPDATA_DATA(i);
	    elsif ( MASK_DATA(i) = '1' and WR_DONT_CARE = '1') then
	    	vWRITE_DATA(i) := 'X';
	    end if;
	  end loop;
        end if;

	return vWRITE_DATA;
 end WRITE_DATA_ENCODER;

---------------------------------------------------------
-- Function: COMPARE_DATA_ENCODER
-- Return: DATA to Compare with MEM contain
---------------------------------------------------------
 function COMPARE_DATA_ENCODER ( COMPARE_DATA : std_logic_vector;
 			         MASK_DATA    : std_logic_vector;
			       	 EN_MASK_REG  : std_logic
				 )
 return std_logic_vector is
   variable vCOMPARE_DATA : std_logic_vector(DATA_WIDTH -1 downto 0) := (others => 'U');
 begin 
	if (EN_MASK_REG = '0') then 
	  vCOMPARE_DATA := COMPARE_DATA;
	elsif (EN_MASK_REG = '1') then
	  for i in MASK_DATA'low to MASK_DATA'high loop
	    if (MASK_DATA(i) = '0') then
	    	vCOMPARE_DATA(i) := COMPARE_DATA(i);
	    elsif ( MASK_DATA(i) = '1' ) then
	    	vCOMPARE_DATA(i) := 'X';
	    end if;
	  end loop;
	end if;

	return vCOMPARE_DATA;
	
 end COMPARE_DATA_ENCODER;
						       
---------------------------------------------------------
-- Function: OUTPUT_ENCODER
-- Return: Binary encoded address
---------------------------------------------------------
 function OUTPUT_ENCODER (UNEN_CAM_OUT: std_logic_vector)
 return std_logic_vector is
   variable vPOINTER : integer := 0;
   variable default_value : std_logic_vector(ADDR_WIDTH-1 downto 0);
 begin
        default_value(ADDR_WIDTH-1) := '1';
        default_value(ADDR_WIDTH-2 downto 0) := (others => '0');

        if (UNEN_CAM_OUT = 0) then
            vPOINTER := CONV_INTEGER(default_value);
        end if;

 	for i in UNEN_CAM_OUT'high downto UNEN_CAM_OUT'low loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vPOINTER := i;
	  end if;
	end loop;
	
	return CONV_STD_LOGIC_VECTOR(vPOINTER, ADDR_WIDTH);
 end OUTPUT_ENCODER;

---------------------------------------------------------
-- Function: MATCH_FLAG
-- Return: MATCH_OUT Flag 
---------------------------------------------------------
 function MATCH_FLAG (UNEN_CAM_OUT: std_logic_vector)
 return std_logic is
   variable vMATCH_FLAG: std_logic := '0';
 begin
         vMATCH_FLAG := '0';
 	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vMATCH_FLAG := '1';
	    return vMATCH_FLAG;
	  end if;
	end loop;

	return vMATCH_FLAG;

 end MATCH_FLAG;

---------------------------------------------------------
-- Function: MUL_MATCH_FLAG
-- Return: MUL_MATCH_OUT Flag 
---------------------------------------------------------
 function MUL_MATCH_FLAG (UNEN_CAM_OUT: std_logic_vector)
 return std_logic is

   variable vMUL_MATCH_FLAG: std_logic := '0';
   variable vMATCH_COUNTE: integer := 0;
 begin
 	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (UNEN_CAM_OUT(i) = '1') then
	    vMATCH_COUNTE := vMATCH_COUNTE + 1;
	  end if;
	end loop;

	if (vMATCH_COUNTE > 1) then
	  vMUL_MATCH_FLAG := '1';
        else 
	  vMUL_MATCH_FLAG := '0';
	end if;
	
	return vMUL_MATCH_FLAG;

 end MUL_MATCH_FLAG;
---------------------------------------------------------
-- Function: WORD_COMPARE
-- Return: Compare Result
---------------------------------------------------------
 function WORD_COMPARE (BRAM_DATA : std_logic_vector;
 			COMP_DATA : std_logic_vector
			)
 return std_logic is
   variable vWORD_FLAG: std_logic := '1';
   variable vCOMP_SECT: std_logic_vector(DATA_WIDTH -1 downto 0) := (others => '0');
 begin
 	vCOMP_SECT := BRAM_DATA;
	
 	for i in vCOMP_SECT'low to vCOMP_SECT'high  loop
	  if ( COMP_DATA(i) /= 'X' and vCOMP_SECT(i) /= 'X') then
	    
	    if ( vCOMP_SECT(i) /= COMP_DATA(i) or vCOMP_SECT(i)= 'Z')  then
	      vWORD_FLAG := '0';
	      return vWORD_FLAG;
	    end if;
	  end if;
	end loop;
	
	return vWORD_FLAG;
 end WORD_COMPARE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

---------------------------------------------------------
-- Signal Declaration 
---------------------------------------------------------

-- Input Nodes
 signal  CE_node        : STD_LOGIC := 'X' ;
 signal  WE_node        : STD_LOGIC := 'X' ;
 signal  CLK_node       : STD_LOGIC := 'X' ;
 signal  EN_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_MASK_node   : STD_LOGIC := 'X' ;
 signal  WR_DC_node     : STD_LOGIC := 'X' ;
 signal  RST_node       : STD_LOGIC := 'X' ;
 signal  CS_node        : STD_LOGIC_VECTOR ( 1 downto 0) := (others => 'X') ;
 signal  WAD_node       : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WD_node        : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- Register Nodes  
 signal  EN_MASK_reg    : STD_LOGIC := 'X' ;
 signal  MASK_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  COMP_DATA_reg  : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WAD_reg        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  WEN_reg        : STD_LOGIC := 'X' ;
 signal  WR_DC_reg      : STD_LOGIC := 'X' ;
 
-- From WRITE_DATA_ENCODER to CAM Array
 signal  WRITE_DATA_node   : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;

-- From COMPARE_DATA_ENCODER to CAM Array
 signal  COMPARE_DATA_node : STD_LOGIC_VECTOR ( DATA_WIDTH -1 downto 0) := (others => 'X') ;
 
-- From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 signal  UNEN_CAM_OUT_node : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0) := (others => 'X') ;

-- Output Nodes 
 signal  CO_node        : STD_LOGIC_VECTOR ( ADDR_WIDTH -1 downto 0) := (others => 'X') ;
 signal  MATCH_node     : STD_LOGIC := 'X' ;
 signal  MUL_MATCH_node : STD_LOGIC := 'X' ;
 signal  CMI_node         : STD_LOGIC_VECTOR ( 2**ADDR_WIDTH -1 downto 0);
 
--------------------------------------------------------- 
-- Architecture 
---------------------------------------------------------
 begin


	CE_node      <= CE ;
	WE_node      <= WE ;
	CLK_node     <= CLK ;
	EN_MASK_node <= EN_MASK ;
	WR_MASK_node <= WR_MASK ;
	WR_DC_node   <= WR_DC ;
	RST_node     <= RST ;
	CS_node      <= CS ;
	WAD_node     <= WAD ;
	WD_node      <= WD ;
        CMI_node     <= CMI ;	
	CO           <= CO_node ;
	MATCH        <= MATCH_node ;
	MUL_MATCH    <= MUL_MATCH_node ;

	MUL_MATCH_node <= MUL_MATCH_FLAG(UNEN_CAM_OUT_node and CMI_node);
	MATCH_node     <= MATCH_FLAG(UNEN_CAM_OUT_node and CMI_node);


	WRITE_DATA_node <= WRITE_DATA_ENCODER(WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	COMPARE_DATA_node <= COMPARE_DATA_ENCODER(COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
        
        CO_node      <= OUTPUT_ENCODER(UNEN_CAM_OUT_node and CMI_node);
   
---------------------------------------------------------
-- Process
-- Register EN_MASK/ COMP_DATA/ WAD/ WEN/ WR_DC inputs 
---------------------------------------------------------

  register_inputs: process (RST_node, CLK_node)
  begin
  	if (RST_node = '1') then
		EN_MASK_reg   <= '0';
		COMP_DATA_reg <= (others => '0');
		WAD_reg       <= (others => '0');
		WEN_reg        <= '0';
		WR_DC_reg     <= '0';
	elsif (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1') then
			EN_MASK_reg   <= EN_MASK_node;
			COMP_DATA_reg <= WD_node;
			WAD_reg       <= WAD_node;
			WEN_reg       <= WE_node and CS_node(0) and CS_node(1);
			WR_DC_reg     <= WR_DC_node;
		end if;
	end if;
  end process register_inputs;

---------------------------------------------------------
-- Process
-- Register WD input to MASK_DATA_reg  
-- Note:
-- TSPEC Rev D Page 64 of 96 Note 3 
-- "The reset on mask data register is not provided"
---------------------------------------------------------

  register_WD_2_MASK_DATA: process (CLK_node)
  begin
   	if (CLK_node'event and CLK_node = '1') then
		if ( CE_node = '1' and WR_MASK_node = '1') then
			MASK_DATA_reg <= WD_node;
		end if;
	end if;
  end process register_WD_2_MASK_DATA;

---------------------------------------------------------
-- Process
-- CAM_KERNEL
---------------------------------------------------------

  CAM_KERNEL : process (WEN_reg, WAD_reg, COMPARE_DATA_node, WRITE_DATA_node)
  	
    variable vADDR : integer := 0;
    variable vUNEN_CAM_OUT : std_logic_vector (2**ADDR_WIDTH -1 downto 0) := (others => '0');
    variable vMEM          : std_logic_vector (2**ADDR_WIDTH*DATA_WIDTH -1 downto 0) := ( others => 'Z');
    variable v_WAD_Valid_Flag : boolean := TRUE;
    variable v_INI_DONE    : boolean := FALSE;

    begin
    
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_CAM_INIT_FILE(MEM_INIT_FILE, vMEM);
	v_INI_DONE := TRUE;
    end if;

    v_WAD_Valid_Flag := Valid_Address(WAD_reg);	

    if (v_WAD_Valid_Flag = TRUE) then
 	vADDR := CONV_INTEGER(WAD_reg);

    --else
    --  assert false
    --    report "Write Address of Port contains invalid bit!"
    --    severity warning;

    end if;	

    if (WEN_reg = '1') then
    	vMEM((vADDR*DATA_WIDTH + DATA_WIDTH -1) downto (vADDR*DATA_WIDTH)) := WRITE_DATA_node;
      for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';

          else 
	    vUNEN_CAM_OUT(i) := '0';

    	  end if;
	end loop;

	UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;
    
    elsif (WEN_reg = '0') then
    	for i in 0 to 2**ADDR_WIDTH -1 loop
	  if (WORD_COMPARE(vMEM((i*DATA_WIDTH + DATA_WIDTH -1) downto (i*DATA_WIDTH)), COMPARE_DATA_node) = '1') then
            vUNEN_CAM_OUT(i) := '1';

          else 
	    vUNEN_CAM_OUT(i) := '0';

    	  end if;
	end loop;

	UNEN_CAM_OUT_node <= vUNEN_CAM_OUT;	

    end if;

		
end process CAM_KERNEL;

end LATTICE_BEHAV;



-- ************************************************************************
--
--  DPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Sep. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_DP_RAM.vhd
--  Description: Single Port BRAM behavioral model. 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_DPRAM_16K is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        ADDR_WIDTH_A     : integer := 13;
        DATA_WIDTH_A     : integer := 2;
        ADDR_WIDTH_B     : integer := 14;
        DATA_WIDTH_B     : integer := 1;
        MEM_INIT_FLAG  : integer := 0;  
	MEM_INIT_FILE  : string  := "mem_init_file"

         );

  port (
        CENA : in  STD_LOGIC ;
        CLKA : in  STD_LOGIC ;
        WRA  : in  STD_LOGIC ;
        CSA  : in  STD_LOGIC_VECTOR (1 downto 0);
        RSTA : in  STD_LOGIC ;
        DIA  : in  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0);
        ADA  : in  STD_LOGIC_VECTOR (ADDR_WIDTH_A -1 downto 0);
        DOA  : out STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0);

        CENB : in  STD_LOGIC ;
        CLKB : in  STD_LOGIC ;
        WRB  : in  STD_LOGIC ;
        CSB  : in  STD_LOGIC_VECTOR (1 downto 0);
        RSTB : in  STD_LOGIC ;
        DIB  : in  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0);
        ADB  : in  STD_LOGIC_VECTOR (ADDR_WIDTH_B -1 downto 0);
        DOB  : out STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0)

        ); 

end SC_DPRAM_16K ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_DPRAM_16K is

 component SC_BRAM_16K

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
    	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal CENA_node :  STD_LOGIC := 'X';
 signal CLKA_node :  STD_LOGIC := 'X';
 signal WRA_node  :  STD_LOGIC := 'X';
 signal CSA_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RSTA_node :  STD_LOGIC := 'X';
 signal DIA_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0) := (others => 'X');
 signal ADA_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH_A -1 downto 0) := (others => 'X');
 signal DOA_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0) := (others => 'X');

 signal DIA_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0) := (others => 'X');
 signal ADA_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH_A -1 downto 0) := (others => 'X');
 signal ENA_reg   :  STD_LOGIC := 'X';
 signal RENA_reg  :  STD_LOGIC := 'X';

 signal CENB_node :  STD_LOGIC := 'X';
 signal CLKB_node :  STD_LOGIC := 'X';
 signal WRB_node  :  STD_LOGIC := 'X';
 signal CSB_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RSTB_node :  STD_LOGIC := 'X';
 signal DIB_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0) := (others => 'X');
 signal ADB_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH_B -1 downto 0) := (others => 'X');
 signal DOB_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0) := (others => 'X');

 signal DIB_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0) := (others => 'X');
 signal ADB_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH_B -1 downto 0) := (others => 'X');
 signal ENB_reg   :  STD_LOGIC := 'X';
 signal RENB_reg  :  STD_LOGIC := 'X';
-- architecture

 begin

  CENA_node <= CENA;
  CLKA_node <= CLKA;
  WRA_node  <= WRA;
  CSA_node  <= CSA;
  RSTA_node <= RSTA;
  DIA_node  <= DIA;
  ADA_node  <= ADA;
  DOA       <= DOA_node; 

  CENB_node <= CENB;
  CLKB_node <= CLKB;
  WRB_node  <= WRB;
  CSB_node  <= CSB;
  RSTB_node <= RSTB;
  DIB_node  <= DIB;
  ADB_node  <= ADB;
  DOB       <= DOB_node;
               
  -- Register Port A DI/ AD / Enable inputs
  register_A_inputs: process (CLKA_node, RSTA_node)
  begin
    if (RSTA_node = '1') then
      DIA_reg <= (others =>'0');
      ADA_reg <= (others =>'0');
      ENA_reg <= '0';
      RENA_reg <= '1';
    elsif (CLKA_node'event and CLKA_node = '1') then
      if (CENA_node = '1') then
        DIA_reg <= DIA_node;
        ADA_reg <= ADA_node;
        ENA_reg <= WRA_node  and CSA_node(0) and CSA_node(1);
        RENA_reg <= '1'; 
      end if;
    end if;
  end process register_A_inputs;   

-- Register Port B DI/ AD / Enable inputs
  register_B_inputs: process (CLKB_node, RSTB_node)
  begin
    if (RSTB_node = '1') then
      DIB_reg <= (others =>'0');
      ADB_reg <= (others =>'0');
      ENB_reg <= '0';
      RENB_reg <= '1';
    elsif (CLKB_node'event and CLKB_node = '1') then
      if (CENB_node = '1') then
        DIB_reg <= DIB_node;
        ADB_reg <= ADB_node;
        ENB_reg <= WRB_node  and CSB_node(0) and CSB_node(1);
        RENB_reg <= '1'; 
      end if;
    end if;
  end process register_B_inputs; 
  
  -- BRAM instance for SPRAM 
  DPRAM_INST: SC_BRAM_16K

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => ADDR_WIDTH_A,
         RADDR_WIDTH_A  => ADDR_WIDTH_A,
         WADDR_WIDTH_B  => ADDR_WIDTH_B,
         RADDR_WIDTH_B  => ADDR_WIDTH_B,
         WDATA_WIDTH_A  => DATA_WIDTH_A,
         RDATA_WIDTH_A  => DATA_WIDTH_A,
         WDATA_WIDTH_B  => DATA_WIDTH_B,
         RDATA_WIDTH_B  => DATA_WIDTH_B,
         ARRAY_SIZE     => 8192,
  	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         WADA => ADA_reg,
         WEA  => ENA_reg,
         WDA  => DIA_reg,
         RADA => ADA_reg,
         REA  => RENA_reg,
         RDA  => DOA_node,
         
         WADB => ADB_reg,
         WEB  => ENB_reg,
         WDB  => DIB_reg,
         RADB => ADB_reg,
         REB  => RENB_reg,
         RDB  => DOB_node
      );

end LATTICE_BEHAV;



-- ************************************************************************
--
--  DPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Sep. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_DP_RAM.vhd
--  Description: Single Port BRAM behavioral model. 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_DPRAM_16K_L is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        ADDR_WIDTH_A     : integer := 13;
        DATA_WIDTH_A     : integer := 2;
        ADDR_WIDTH_B     : integer := 14;
        DATA_WIDTH_B     : integer := 1;
        MEM_INIT_FLAG  : integer := 1;  
        ARRAY_SIZE       : integer := 16384;
	MEM_INIT_FILE  : string  := "mem_init_file"

         );

  port (
        CENA : in  STD_LOGIC ;
        CLKA : in  STD_LOGIC ;
        WRA  : in  STD_LOGIC ;
        CSA  : in  STD_LOGIC_VECTOR (1 downto 0);
        RSTA : in  STD_LOGIC ;
        DIA  : in  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0);
        ADA  : in  STD_LOGIC_VECTOR (ADDR_WIDTH_A -1 downto 0);
        DOA  : out STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0);

        CENB : in  STD_LOGIC ;
        CLKB : in  STD_LOGIC ;
        WRB  : in  STD_LOGIC ;
        CSB  : in  STD_LOGIC_VECTOR (1 downto 0);
        RSTB : in  STD_LOGIC ;
        DIB  : in  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0);
        ADB  : in  STD_LOGIC_VECTOR (ADDR_WIDTH_B -1 downto 0);
        DOB  : out STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0)

        ); 

end SC_DPRAM_16K_L ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_DPRAM_16K_L is

 component SC_BRAM_16K_L

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
    	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal CENA_node :  STD_LOGIC := 'X';
 signal CLKA_node :  STD_LOGIC := 'X';
 signal WRA_node  :  STD_LOGIC := 'X';
 signal CSA_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RSTA_node :  STD_LOGIC := 'X';
 signal DIA_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0) := (others => 'X');
 signal ADA_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH_A -1 downto 0) := (others => 'X');
 signal DOA_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0) := (others => 'X');

 signal DIA_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH_A -1 downto 0) := (others => 'X');
 signal ADA_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH_A -1 downto 0) := (others => 'X');
 signal ENA_reg   :  STD_LOGIC := 'X';
 signal RENA_reg  :  STD_LOGIC := 'X';

 signal CENB_node :  STD_LOGIC := 'X';
 signal CLKB_node :  STD_LOGIC := 'X';
 signal WRB_node  :  STD_LOGIC := 'X';
 signal CSB_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RSTB_node :  STD_LOGIC := 'X';
 signal DIB_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0) := (others => 'X');
 signal ADB_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH_B -1 downto 0) := (others => 'X');
 signal DOB_node  :  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0) := (others => 'X');

 signal DIB_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH_B -1 downto 0) := (others => 'X');
 signal ADB_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH_B -1 downto 0) := (others => 'X');
 signal ENB_reg   :  STD_LOGIC := 'X';
 signal RENB_reg  :  STD_LOGIC := 'X';
-- architecture

 begin

  CENA_node <= CENA;
  CLKA_node <= CLKA;
  WRA_node  <= WRA;
  CSA_node  <= CSA;
  RSTA_node <= RSTA;
  DIA_node  <= DIA;
  ADA_node  <= ADA;
  DOA       <= DOA_node; 

  CENB_node <= CENB;
  CLKB_node <= CLKB;
  WRB_node  <= WRB;
  CSB_node  <= CSB;
  RSTB_node <= RSTB;
  DIB_node  <= DIB;
  ADB_node  <= ADB;
  DOB       <= DOB_node;
               
  -- Register Port A DI/ AD / Enable inputs
  register_A_inputs: process (CLKA_node, RSTA_node)
  begin
    if (RSTA_node = '1') then
      DIA_reg <= (others =>'0');
      ADA_reg <= (others =>'0');
      ENA_reg <= '0';
      RENA_reg <= '1';
    elsif (CLKA_node'event and CLKA_node = '1') then
      if (CENA_node = '1') then
        DIA_reg <= DIA_node;
        ADA_reg <= ADA_node;
        ENA_reg <= WRA_node  and CSA_node(0) and CSA_node(1);
        RENA_reg <= '1'; 
      end if;
    end if;
  end process register_A_inputs;   

-- Register Port B DI/ AD / Enable inputs
  register_B_inputs: process (CLKB_node, RSTB_node)
  begin
    if (RSTB_node = '1') then
      DIB_reg <= (others =>'0');
      ADB_reg <= (others =>'0');
      ENB_reg <= '0';
      RENB_reg <= '1';
    elsif (CLKB_node'event and CLKB_node = '1') then
      if (CENB_node = '1') then
        DIB_reg <= DIB_node;
        ADB_reg <= ADB_node;
        ENB_reg <= WRB_node  and CSB_node(0) and CSB_node(1);
        RENB_reg <= '1'; 
      end if;
    end if;
  end process register_B_inputs; 
  
  -- BRAM instance for SPRAM 
  DPRAM_INST: SC_BRAM_16K_L

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => ADDR_WIDTH_A,
         RADDR_WIDTH_A  => ADDR_WIDTH_A,
         WADDR_WIDTH_B  => ADDR_WIDTH_B,
         RADDR_WIDTH_B  => ADDR_WIDTH_B,
         WDATA_WIDTH_A  => DATA_WIDTH_A,
         RDATA_WIDTH_A  => DATA_WIDTH_A,
         WDATA_WIDTH_B  => DATA_WIDTH_B,
         RDATA_WIDTH_B  => DATA_WIDTH_B,
         ARRAY_SIZE     => ARRAY_SIZE,
  	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         WADA => ADA_reg,
         WEA  => ENA_reg,
         WDA  => DIA_reg,
         RADA => ADA_reg,
         REA  => RENA_reg,
         RDA  => DOA_node,
         
         WADB => ADB_reg,
         WEB  => ENB_reg,
         WDB  => DIB_reg,
         RADB => ADB_reg,
         REB  => RENB_reg,
         RDB  => DOB_node
      );

end LATTICE_BEHAV;




-- ************************************************************************
--
--  FIFO: Behavioral Model
--  VHDL
--  
-- ************************************************************************
--
--  Init: Oct. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_FIFO.vhd
--  Description: FIFO behavioral model. 
--     
-- ************************************************************************

-- ************************************************************************
-- History: 
-- 1. Reset EMPTY & AMEMPTY to '0', '0' means 'Ture';   
-- 2. May. 30, 2002 Read memory initialization file feature
-- 3. Add control signal RE WE to BlockRAM 
-- 4. Add programable TERMINAL_COUNT
-- 5. Fix the Write 1-5, Read 2-6 issue
-- ************************************************************************

-- ************************************************************************
-- FIFO COMPONENTS READ_POINTER_CTRL
-- ************************************************************************
library ieee;
use ieee.std_logic_1164.all;
--use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity READ_POINTER_CTRL is
	generic (
              RPOINTER_WIDTH : integer := 9
		);
	port (
                TERMINAL_COUNT : in STD_LOGIC_VECTOR(RPOINTER_WIDTH -1 downto 0);--QQ
		GLOBAL_RST   : in STD_LOGIC ;
                RESET_RP     : in STD_LOGIC ;
                READ_EN      : in STD_LOGIC ;
                READ_CLK     : in STD_LOGIC ;
	        EMPTY_FLAG   : in STD_LOGIC ;
		READ_POINTER : out STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0)
	     );
end READ_POINTER_CTRL;

architecture LATTICE_BEHAV of READ_POINTER_CTRL is

  signal s_READ_POINTER : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0) := (others => '0');

begin

  READ_POINTER <= s_READ_POINTER; 

process  (GLOBAL_RST, RESET_RP, READ_EN, READ_CLK)

	variable v_READ_POINTER: STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0');

begin

	if GLOBAL_RST = '1'  or RESET_RP = '1' then 

          s_READ_POINTER <= (others => '0');

	elsif (READ_CLK'EVENT and READ_CLK = '1') then
		if (READ_EN = '1' and EMPTY_FLAG = '1') then
                  v_READ_POINTER := s_READ_POINTER + '1';
                else  
                  v_READ_POINTER := s_READ_POINTER;
		end if;

		if (v_READ_POINTER = TERMINAL_COUNT + 1) then
		   s_READ_POINTER <= (others => '0');
		else
		   s_READ_POINTER <= v_READ_POINTER;
		end if;
	end if;

end process;
end LATTICE_BEHAV;

-- ************************************************************************
-- FIFO COMPONENTS WRITE_POINTER_CTRL
-- ************************************************************************
library ieee;
use ieee.std_logic_1164.all;
--use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity WRITE_POINTER_CTRL is
        generic (
                WPOINTER_WIDTH : integer := 9;
                WDATA_WIDTH : integer := 32
		);
        port (
		TERMINAL_COUNT : in STD_LOGIC_VECTOR(WPOINTER_WIDTH -1 downto 0);--QQ
		GLOBAL_RST    : in STD_LOGIC ;
                WRITE_EN      : in STD_LOGIC ;
                WRITE_CLK     : in STD_LOGIC ;
                FULL_FLAG     : in STD_LOGIC ;
                WRITE_POINTER : out STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0)
            
	     );
end WRITE_POINTER_CTRL;

architecture LATTICE_BEHAV of WRITE_POINTER_CTRL is

 signal s_WRITE_POINTER : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0):= (others => '0');

begin 

  WRITE_POINTER <= s_WRITE_POINTER;

  process  (GLOBAL_RST, WRITE_EN, WRITE_CLK)

    variable v_WRITE_POINTER: STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0):= (others => '0');

begin
	if GLOBAL_RST = '1'  then 
		s_WRITE_POINTER <= (others => '0'); 

	elsif (WRITE_CLK'EVENT and WRITE_CLK = '1') then
		if (WRITE_EN = '1' and FULL_FLAG /= '1') then
		   v_WRITE_POINTER := s_WRITE_POINTER + '1';
                else
		   v_WRITE_POINTER := s_WRITE_POINTER ;
                end if; 

		if (v_WRITE_POINTER = TERMINAL_COUNT + 1) then
		   s_WRITE_POINTER <= (others => '0');
		else
		   s_WRITE_POINTER <= v_WRITE_POINTER;
		end if;
	end if;
end process;
end LATTICE_BEHAV;

-- ************************************************************************
-- FIFO COMPONENTS FLAG LOGIC
-- ************************************************************************
library ieee;
use ieee.std_logic_1164.all;
--use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity FLAG_LOGIC is
 	generic (
                WPOINTER_WIDTH : integer := 9;
                RPOINTER_WIDTH : integer := 9;
                WDATA_WIDTH    : integer := 32; 
                RDATA_WIDTH    : integer := 32; 
                AMFULL_X      : integer := 1;
                AMEMPTY_Y     : integer := 1
		);
	port (
		TERMINAL_COUNT : in STD_LOGIC_VECTOR(WPOINTER_WIDTH -1 downto 0) := (others => '0');--QQ
		R_POINTER  : in STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0) := (others => '0');
                W_POINTER  : in STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0');
                GLOBAL_RST : in STD_LOGIC ;
                READ_EN    : in STD_LOGIC ;
                READ_CLK   : in STD_LOGIC ;
                WRITE_EN   : in STD_LOGIC ;
                WRITE_CLK  : in STD_LOGIC ; 
                FULL_D     : out STD_LOGIC ;
                EMPTY_D    : out STD_LOGIC ;
                AMFULL_D   : out STD_LOGIC ;
                AMEMPTY_D  : out STD_LOGIC 
	);
end FLAG_LOGIC;

architecture LATTICE_BEHAV of FLAG_LOGIC is
--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Pointer (
    IN_ADDR : in STD_LOGIC_VECTOR
 ) return BOOLEAN is

    variable v_Valid_Flag : BOOLEAN := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Pointer;

--------------------------------------------------------------------------
-- Function: Calculate_Offset 
-- Description: 
--------------------------------------------------------------------------
function Calculate_Offset (
    IN_TC : in  STD_LOGIC_VECTOR;
    TC_LENGTH: in INTEGER
 ) return STD_LOGIC_VECTOR is

    variable vTC_FULL: STD_LOGIC_VECTOR (TC_LENGTH -1 downto 0) := (others => '1');
    variable vTC_TEMP: STD_LOGIC_VECTOR (TC_LENGTH -1 downto 0) := (others => '0');
    variable vOFFSET : STD_LOGIC_VECTOR (TC_LENGTH -1 downto 0) := (others => '0');
begin
    vTC_TEMP := IN_TC;
    vOFFSET := vTC_FULL-vTC_TEMP;
    return vOFFSET;
end Calculate_Offset;
   
begin 

--------------------------------------------------------------------------
-- Function: Main Process 
-- Description: 
--------------------------------------------------------------------------
FULL_AMFULL: process  (GLOBAL_RST, WRITE_EN, WRITE_CLK, W_POINTER, R_POINTER)
    variable v_WP_Valid_Flag : boolean := TRUE;
    variable v_RP_Valid_Flag : boolean := TRUE;
    --variable v_WP_Check_FULL_TMP : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_WP_Check_AMFL_TMP : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ
    variable v_WP_Check_AMFL_TMP1 : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ
    variable v_WP_Check_FULL : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ
    variable v_WP_Check_AMFL : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ

begin
        v_WP_Valid_Flag := Valid_Pointer(W_POINTER);	
        v_RP_Valid_Flag := Valid_Pointer(R_POINTER);
	if( v_WP_Valid_Flag = TRUE) then
             v_WP_Check_AMFL_TMP := W_POINTER + AMFULL_X + 1;
        end if;

        v_WP_Check_AMFL_TMP1 := v_WP_Check_AMFL_TMP + Calculate_Offset(TERMINAL_COUNT, WPOINTER_WIDTH);

	if ( v_WP_Valid_Flag = TRUE and W_POINTER = TERMINAL_COUNT ) then 
	    v_WP_Check_FULL := (others => '0');
	elsif( v_WP_Valid_Flag = TRUE ) then 
	    v_WP_Check_FULL := W_POINTER + 1; 
	end if;

	if GLOBAL_RST = '1'  then 
	    FULL_D <= '0';
	    AMFULL_D <= '0';

	elsif( v_WP_Valid_Flag = TRUE and v_RP_Valid_Flag = TRUE) then

	    if R_POINTER = v_WP_Check_FULL then
	     FULL_D <= '1';
            else
	     FULL_D <= '0';	
            end if;

            if (W_POINTER > R_POINTER) then
	      if (v_WP_Check_AMFL_TMP1 < W_POINTER) then
                if v_WP_Check_AMFL_TMP1 >= R_POINTER then
	         AMFULL_D <= '1';
	        else
	         AMFULL_D <= '0'; 	
	        end if; 
              else 
	         AMFULL_D <= '0'; 	
              end if;    
            elsif (W_POINTER < R_POINTER) then
	      if (v_WP_Check_AMFL_TMP1 < W_POINTER) then
	         AMFULL_D <= '1';
	      elsif (v_WP_Check_AMFL_TMP >= R_POINTER) then
	         AMFULL_D <= '1';
	      else 
	         AMFULL_D <= '0'; 	
	      end if; 
            end if;    

        end if;

end process FULL_AMFULL;

EMPTY_AMEMPTY: process  (GLOBAL_RST, READ_EN, READ_CLK, W_POINTER, R_POINTER)
    variable v_WP_Valid_Flag : boolean := TRUE;
    variable v_RP_Valid_Flag : boolean := TRUE;
    variable v_RP_Check_EMPT_TMP : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_RP_Check_AMET_TMP : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_RP_Check_AMET_TMP1 : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    --variable v_RP_Check_EMPT : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_RP_Check_AMET : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ

begin
        v_WP_Valid_Flag := Valid_Pointer(W_POINTER);	
        v_RP_Valid_Flag := Valid_Pointer(R_POINTER);
	if( v_RP_Valid_Flag = TRUE and v_WP_Valid_Flag = TRUE) then
	    v_RP_Check_AMET_TMP := R_POINTER + AMEMPTY_Y ; -- Different from TSPEC QQ 07 17,2002
        end if;
        v_RP_Check_AMET_TMP1 := v_RP_Check_AMET_TMP + Calculate_Offset(TERMINAL_COUNT, RPOINTER_WIDTH);

	if GLOBAL_RST = '1'  then 
	  EMPTY_D <= '0';
	  AMEMPTY_D <= '0';
	elsif( v_WP_Valid_Flag = TRUE and v_RP_Valid_Flag = TRUE) then
            if R_POINTER  = W_POINTER then   -- Different from TSPEC QQ 07 17,2002
                    EMPTY_D <= '0';
            else
                    EMPTY_D <= '1';
            end if;

	    
	    if (W_POINTER < R_POINTER) then
	      if (v_RP_Check_AMET_TMP1 < R_POINTER) then
	          v_RP_Check_AMET := v_RP_Check_AMET_TMP + Calculate_Offset(TERMINAL_COUNT, RPOINTER_WIDTH);
                if v_RP_Check_AMET >= W_POINTER then
	         AMEMPTY_D <= '0';
	        else
	         AMEMPTY_D <= '1'; 	
	        end if; 
              else 
	         AMEMPTY_D <= '1'; 	
              end if;    
            elsif (W_POINTER > R_POINTER) then
	      if (v_RP_Check_AMET_TMP1 < R_POINTER) then
	         AMEMPTY_D <= '0';
	      elsif (v_RP_Check_AMET_TMP >= W_POINTER) then
	         AMEMPTY_D <= '0';
	      else 
	         AMEMPTY_D <= '1'; 	
	      end if; 
            elsif (W_POINTER = R_POINTER) then
              AMEMPTY_D <= '0';
            end if;    
       end if;
end process EMPTY_AMEMPTY;

end LATTICE_BEHAV;

-- **********************************************************************
-- SC_FIFO_16K
-- **********************************************************************
-- **********************************************************************
-- Top Design Entity definition  
-- **********************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
--USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_unsigned.ALL;

--LIBRARY SC_LIB;
--USE SC_LIB.SC_FIFO_COMPS.ALL;
-- ctse 0622

 entity SC_FIFO_16K is 
  generic (
	DEVICE_FAMILY  : string  := "SuperCool";
  	TERMINAL_COUNT : integer := 511; --QQ: Word number < 2**WADDR_WIDTH
	WADDR_WIDTH    : integer :=   9;
        WDATA_WIDTH    : integer :=  32;
        RADDR_WIDTH    : integer :=   9;
        RDATA_WIDTH    : integer :=  32;
        ALMOST_FULL_X  : integer :=   1;
        ALMOST_EMPTY_Y : integer :=   1;
        MEM_INIT_FLAG  : integer :=   0;  
        MEM_INIT_FILE  : string  := "mem_init_file"

         );

  port (
        WE      : in STD_LOGIC ;
        WCLK    : in STD_LOGIC ;
        RST     : in STD_LOGIC ;
        RPRST   : in STD_LOGIC ;
        RE      : in STD_LOGIC ;
        RCLK    : in STD_LOGIC ;
        FULLIN  : in STD_LOGIC ;
        EMPTYIN : in STD_LOGIC ;
        DI      : in STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);

        FULL    : out STD_LOGIC ;
        EMPTY   : out STD_LOGIC ;
        AMFULL  : out STD_LOGIC ;
        AMEMPTY : out STD_LOGIC ;
        DO      : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)

        ); 

end SC_FIFO_16K; 

-- ************************************************************************
-- ARCHITECTURE
-- ************************************************************************
architecture LATTICE_BEHAV of SC_FIFO_16K is 

-- ************************************************************************
-- COMPONENT DECLARATIONS
-- ************************************************************************
component SC_BRAM_16K_SYNC 

  generic (
 	     
         DEVICE_FAMILY : string  := "SuperCool";
         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
         MEM_INIT_FLAG : integer := 0;  
         MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0);
	 WCLK : in  STD_LOGIC;
	 RCLK : in  STD_LOGIC
        ); 
 end component;

-- ************************************************************************
-- SIGNAL DECLARATIONS
-- ************************************************************************
signal we_ram : STD_LOGIC := '0';
signal re_ram : STD_LOGIC := '0';
signal full_bit : STD_LOGIC := '0';
signal empty_bit : STD_LOGIC := '0';
signal wptr_wrap_bit : STD_LOGIC := '0';
signal rptr_wrap_bit : STD_LOGIC := '0';
signal wptr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal rptr : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');
signal wptr_wrap_appended : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal rptr_wrap_appended : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');
signal next_wptr_wrap_appended : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');

signal next_rptr_wrap_appended : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');

--ct092804
--signal num_unread_loc : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
--				:= (others => '0');
--signal num_empty_loc : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
--				:= (others => '0');

signal num_unread_loc_wdomain : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal num_unread_loc_rdomain : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');
				
signal TERM_CNT_VEC : STD_LOGIC_VECTOR (WADDR_WIDTH  downto 0);
signal DEPTH : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0);   

signal wptr_rdomain : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal rptr_wdomain : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');

signal wptr_wrap_bit_rdomain : STD_LOGIC := '0';
signal rptr_wrap_bit_wdomain : STD_LOGIC := '0';

signal wptr_wrap_appended_rdomain : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				  := (others => '0');
signal rptr_wrap_appended_wdomain : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) --ct092704
				  := (others => '0');


signal rden_p1, empty_p1: std_logic; --ct092804
signal do_ram: STD_LOGIC_VECTOR (RDATA_WIDTH - 1 downto 0); --ct092804
-- ************************************************************************
-- FUNCTIONS
-- ************************************************************************
function next_ptr (
   ptr_wrap_bit :  STD_LOGIC;
   ptr :  STD_LOGIC_VECTOR;
   TERMINAL_COUNT :  integer )

  return STD_LOGIC_VECTOR is

  variable result_ptr : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0); 
  variable tmp_ptr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0);
  
begin
   if (ptr = TERMINAL_COUNT) then
      tmp_ptr := (others => '1');
   else
      tmp_ptr :=  ptr;
   end if;
   result_ptr := (ptr_wrap_bit & tmp_ptr) + 1;
  
   return result_ptr;

end next_ptr;

function INT_TO_VEC ( INPUT_INT : integer; INPUT_LENGTH: integer)
 return std_logic_vector is

   variable vDATA_STD_VEC: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
   variable vTRANS: integer := 0;
   variable vQUOTIENT: integer := 0;
 
 begin 
    vQUOTIENT := INPUT_INT;

    for i in 0 to INPUT_LENGTH -1 loop
	vTRANS := 0;
	while vQUOTIENT >1 loop
	    vQUOTIENT := vQUOTIENT - 2;
            vTRANS := vTRANS + 1;
	end loop;
        case vQUOTIENT is
              when 1 =>
                 vDATA_STD_VEC(i) := '1';
              when 0 =>
                 vDATA_STD_VEC(i) := '0';
              when others =>
                 null;
        end case;
        vQUOTIENT := vTRANS; 
    end loop;
  return vDATA_STD_VEC; 	  
 end INT_TO_VEC; 

-- ************************************************************************
-- BODY
-- ************************************************************************

begin 

-- ************************************************************************
-- INSTANTIATIONS
-- ************************************************************************

FIFO_BRAM_INST: SC_BRAM_16K_SYNC

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH, 
         RADDR_WIDTH_A  => RADDR_WIDTH, 
         WADDR_WIDTH_B  => WADDR_WIDTH, 
         RADDR_WIDTH_B  => RADDR_WIDTH, 
         WDATA_WIDTH_A  => WDATA_WIDTH, 
         RDATA_WIDTH_A  => RDATA_WIDTH, 
         WDATA_WIDTH_B  => WDATA_WIDTH, 
         RDATA_WIDTH_B  => RDATA_WIDTH, 
         ARRAY_SIZE     => open,
    	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         WADA => wptr,
         WEA  => we_ram,
         WDA  => DI, 
         RADA => rptr,
         REA  => re_ram,
         --ct092804 RDA  => DO, 
         RDA  => do_ram, --ct092804
         
         WADB => wptr, 
         WEB  => '0', 
         WDB  => DI, 
         RADB => rptr, 
         REB  => '0', 
         RDB  => open,
	 WCLK => WCLK,
	 RCLK => RCLK
      );


-- ************************************************************************
-- CONCURRENT ASSIGNMENTS
-- ************************************************************************
TERM_CNT_VEC (WADDR_WIDTH downto 0) <= INT_TO_VEC(TERMINAL_COUNT, WADDR_WIDTH + 1);

DEPTH (WADDR_WIDTH downto 0)  <= TERM_CNT_VEC  + 1;


we_ram  <= WE and not(full_bit);
re_ram <= RE and not(empty_bit);

wptr <= wptr_wrap_appended(WADDR_WIDTH - 1 downto 0);
rptr <= rptr_wrap_appended(RADDR_WIDTH - 1 downto 0);
wptr_rdomain <= wptr_wrap_appended_rdomain(WADDR_WIDTH - 1 downto 0);
rptr_wdomain <= rptr_wrap_appended_wdomain(RADDR_WIDTH - 1 downto 0);

wptr_wrap_bit <= wptr_wrap_appended(WADDR_WIDTH);
rptr_wrap_bit <= rptr_wrap_appended(RADDR_WIDTH);
wptr_wrap_bit_rdomain  <= wptr_wrap_appended_rdomain (WADDR_WIDTH);
rptr_wrap_bit_wdomain  <= rptr_wrap_appended_wdomain (RADDR_WIDTH);

next_rptr_wrap_appended <= next_ptr(rptr_wrap_bit, rptr, TERMINAL_COUNT);
next_wptr_wrap_appended <= next_ptr(wptr_wrap_bit, wptr, TERMINAL_COUNT);

--ct092704
--num_empty_loc <= -- used for full, computed in wdomain
--   ( DEPTH + rptr_wdomain) - wptr when (rptr_wrap_bit_wdomain = wptr_wrap_bit)
--else
--   "0" & (rptr_wdomain -  wptr);

--num_unread_loc <= --used for empty, computed in rdomain
--   ( DEPTH + wptr_rdomain) - rptr when (wptr_wrap_bit_rdomain /= rptr_wrap_bit)
--else
--   "0" & (wptr_rdomain -  rptr);

process (rptr_wdomain, rptr_wrap_bit_wdomain, wptr, wptr_wrap_bit)
begin
   if (rptr_wrap_bit_wdomain /= wptr_wrap_bit) then
      -- An improper use of RPRST could cause num_unread_loc >= DEPTH,
      -- when the wrap bits are different but wptr > rptr
      num_unread_loc_wdomain <=  ( DEPTH + wptr) - rptr_wdomain;
   else 
      num_unread_loc_wdomain <= "0" & (wptr -  rptr_wdomain);
   end if;
end process;

process (wptr_rdomain, wptr_wrap_bit_rdomain, rptr, rptr_wrap_bit)
begin
   if (wptr_wrap_bit_rdomain /= rptr_wrap_bit) then
      -- An improper use of RPRST could cause num_unread_loc >= DEPTH,
      -- when the wrap bits are different but wptr > rptr
      num_unread_loc_rdomain <=  ( DEPTH + wptr_rdomain) - rptr;
   else 
      num_unread_loc_rdomain <= "0" & (wptr_rdomain - rptr  );
   end if;
end process;
--full_bit <= '1' when (num_empty_loc = 0) else '0';
--empty_bit <= '1' when (num_unread_loc = 0) else '0';

full_bit <= '1' when (num_unread_loc_wdomain >= DEPTH) else '0';
FULL <= full_bit;
AMFULL <= '1' when (num_unread_loc_wdomain >= DEPTH - ALMOST_FULL_X) else '0';

-- AMEMPTY/EMPTY  are ACTIVE LOW !!!!!!!!!!!!!!!!!!!!!!!!!!!!
empty_bit <= '1' when (num_unread_loc_rdomain = 0 ) else '0';
EMPTY <= not(empty_bit); 
AMEMPTY <= '0' when (num_unread_loc_rdomain <= ALMOST_EMPTY_Y) else '1';

-- **********************************************************************
-- DO LATCH
-- **********************************************************************
process (RCLK)
begin
   if (rising_edge (RCLK)) then 
      rden_p1 <= RE;
      empty_p1 <= empty_bit;
   end if;
end process;

process (do_ram, RST, rden_p1, empty_p1)
begin
   if (RST = '1') then
      DO <= (others => '0');
   elsif (rden_p1 = '1' and empty_p1 = '0') then
      DO <= do_ram;
   end if;
end process;
-- **********************************************************************
-- WRITE READ POINTERS
-- **********************************************************************
process (RST, WCLK)
begin

   if (RST = '1')  then
      wptr_wrap_appended <= (others => '0');
   elsif ( WCLK'event and WCLK = '1') then
      if (WE = '1' and full_bit = '0') then
         wptr_wrap_appended <= next_wptr_wrap_appended after 1 ns;
      end if;
   end if;
end process;

--ct092804
process (RST, RPRST, RCLK)
begin

   if (RST = '1'or RPRST = '1')  then
      rptr_wrap_appended <= (others => '0') ;
   elsif ( RCLK'event and RCLK = '1') then
      if ( (RE and not(empty_bit)) = '1') then
         rptr_wrap_appended <= next_rptr_wrap_appended after 1 ns;
      end if;
   end if ;   
end process;



-- ************************************************************************
-- POINTER SYNCHRONIZATIONS (SIMPLY DONE TO MATCH THE GATE-LEVEL MODEL)
-- ************************************************************************

process (RST, WCLK)
begin
   if (RST = '1')  then
      rptr_wrap_appended_wdomain <= (others => '0');
   elsif ( WCLK'event and WCLK = '1') then
      rptr_wrap_appended_wdomain <= rptr_wrap_appended after 1 ns;
   end if;
end process;


process (RST, RCLK)
begin
   if (RST = '1')  then
      wptr_wrap_appended_rdomain <= (others => '0');
   elsif ( RCLK'event and RCLK = '1') then
      wptr_wrap_appended_rdomain <= wptr_wrap_appended after 1 ns;
   end if;
end process;

-- ************************************************************************
-- END ARCHITECTURE: SC_FIFO_16K
-- ************************************************************************
end LATTICE_BEHAV; 


--**********************************************************************
--**  SC_FIFO_16K_L 
--**********************************************************************
--**********************************************************************
-- Top Design Entity definition  
--**********************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
--USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_unsigned.ALL;

--LIBRARY SC_LIB;
--USE SC_LIB.SC_FIFO_COMPS.ALL;
-- ctse 0622

 entity SC_FIFO_16K_L is 
  generic (
	DEVICE_FAMILY  : string  := "SuperCool";
  	TERMINAL_COUNT : integer := 511; --QQ: Word number < 2**WADDR_WIDTH
	WADDR_WIDTH    : integer :=   9;
        WDATA_WIDTH    : integer :=  32;
        RADDR_WIDTH    : integer :=   9;
        RDATA_WIDTH    : integer :=  32;
        ALMOST_FULL_X  : integer :=   1;
        ALMOST_EMPTY_Y : integer :=   1;
        MEM_INIT_FLAG  : integer :=   0;  
        MEM_INIT_FILE  : string  := "mem_init_file"

         );

  port (
        WE      : in STD_LOGIC ;
        WCLK    : in STD_LOGIC ;
        RST     : in STD_LOGIC ;
        RPRST   : in STD_LOGIC ;
        RE      : in STD_LOGIC ;
        RCLK    : in STD_LOGIC ;
        FULLIN  : in STD_LOGIC ;
        EMPTYIN : in STD_LOGIC ;
        DI      : in STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);

        FULL    : out STD_LOGIC ;
        EMPTY   : out STD_LOGIC ;
        AMFULL  : out STD_LOGIC ;
        AMEMPTY : out STD_LOGIC ;
        DO      : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)

        ); 

end SC_FIFO_16K_L; 

-- ************************************************************************
-- ARCHITECTURE
-- ************************************************************************
architecture LATTICE_BEHAV of SC_FIFO_16K_L is 

-- ************************************************************************
-- COMPONENT DECLARATIONS
-- ************************************************************************
component SC_BRAM_16K_L_SYNC 

  generic (
 	     
         DEVICE_FAMILY : string  := "SuperCool";
         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
         MEM_INIT_FLAG : integer := 0;  
         MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0);
	 WCLK : in  STD_LOGIC;
	 RCLK : in  STD_LOGIC
        ); 
 end component;

-- ************************************************************************
-- SIGNAL DECLARATIONS
-- ************************************************************************
signal we_ram : STD_LOGIC := '0';
signal re_ram : STD_LOGIC := '0';
signal full_bit : STD_LOGIC := '0';
signal empty_bit : STD_LOGIC := '0';
signal wptr_wrap_bit : STD_LOGIC := '0';
signal rptr_wrap_bit : STD_LOGIC := '0';
signal wptr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal rptr : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');
signal wptr_wrap_appended : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal rptr_wrap_appended : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');
signal next_wptr_wrap_appended : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');

signal next_rptr_wrap_appended : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');

--ct092804
--signal num_unread_loc : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
--				:= (others => '0');
--signal num_empty_loc : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
--				:= (others => '0');

signal num_unread_loc_wdomain : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal num_unread_loc_rdomain : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');
				
signal TERM_CNT_VEC : STD_LOGIC_VECTOR (WADDR_WIDTH  downto 0);
signal DEPTH : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0);   

signal wptr_rdomain : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal rptr_wdomain : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');

signal wptr_wrap_bit_rdomain : STD_LOGIC := '0';
signal rptr_wrap_bit_wdomain : STD_LOGIC := '0';

signal wptr_wrap_appended_rdomain : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				  := (others => '0');
signal rptr_wrap_appended_wdomain : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) --ct092704
				  := (others => '0');


signal rden_p1, empty_p1: std_logic; --ct092804
signal do_ram: STD_LOGIC_VECTOR (RDATA_WIDTH - 1 downto 0); --ct092804
-- ************************************************************************
-- FUNCTIONS
-- ************************************************************************
function next_ptr (
   ptr_wrap_bit :  STD_LOGIC;
   ptr :  STD_LOGIC_VECTOR;
   TERMINAL_COUNT :  integer )

  return STD_LOGIC_VECTOR is

  variable result_ptr : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0); 
  variable tmp_ptr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0);
  
begin
   if (ptr = TERMINAL_COUNT) then
      tmp_ptr := (others => '1');
   else
      tmp_ptr :=  ptr;
   end if;
   result_ptr := (ptr_wrap_bit & tmp_ptr) + 1;
  
   return result_ptr;

end next_ptr;

function INT_TO_VEC ( INPUT_INT : integer; INPUT_LENGTH: integer)
 return std_logic_vector is

   variable vDATA_STD_VEC: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
   variable vTRANS: integer := 0;
   variable vQUOTIENT: integer := 0;
 
 begin 
    vQUOTIENT := INPUT_INT;

    for i in 0 to INPUT_LENGTH -1 loop
	vTRANS := 0;
	while vQUOTIENT >1 loop
	    vQUOTIENT := vQUOTIENT - 2;
            vTRANS := vTRANS + 1;
	end loop;
        case vQUOTIENT is
              when 1 =>
                 vDATA_STD_VEC(i) := '1';
              when 0 =>
                 vDATA_STD_VEC(i) := '0';
              when others =>
                 null;
        end case;
        vQUOTIENT := vTRANS; 
    end loop;
  return vDATA_STD_VEC; 	  
 end INT_TO_VEC; 

-- ************************************************************************
-- BODY
-- ************************************************************************

begin 

-- ************************************************************************
-- INSTANTIATIONS
-- ************************************************************************

FIFO_BRAM_INST: SC_BRAM_16K_L_SYNC

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH, 
         RADDR_WIDTH_A  => RADDR_WIDTH, 
         WADDR_WIDTH_B  => WADDR_WIDTH, 
         RADDR_WIDTH_B  => RADDR_WIDTH, 
         WDATA_WIDTH_A  => WDATA_WIDTH, 
         RDATA_WIDTH_A  => RDATA_WIDTH, 
         WDATA_WIDTH_B  => WDATA_WIDTH, 
         RDATA_WIDTH_B  => RDATA_WIDTH, 
         ARRAY_SIZE     => open,
    	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         WADA => wptr,
         WEA  => we_ram,
         WDA  => DI, 
         RADA => rptr,
         REA  => re_ram,
         --ct092804 RDA  => DO, 
         RDA  => do_ram, --ct092804
         
         WADB => wptr, 
         WEB  => '0', 
         WDB  => DI, 
         RADB => rptr, 
         REB  => '0', 
         RDB  => open,
	 WCLK => WCLK,
	 RCLK => RCLK
      );


-- ************************************************************************
-- CONCURRENT ASSIGNMENTS
-- ************************************************************************
TERM_CNT_VEC (WADDR_WIDTH downto 0) <= INT_TO_VEC(TERMINAL_COUNT, WADDR_WIDTH + 1);

DEPTH (WADDR_WIDTH downto 0)  <= TERM_CNT_VEC  + 1;


we_ram  <= WE and not(full_bit);
re_ram <= RE and not(empty_bit);

wptr <= wptr_wrap_appended(WADDR_WIDTH - 1 downto 0);
rptr <= rptr_wrap_appended(RADDR_WIDTH - 1 downto 0);
wptr_rdomain <= wptr_wrap_appended_rdomain(WADDR_WIDTH - 1 downto 0);
rptr_wdomain <= rptr_wrap_appended_wdomain(RADDR_WIDTH - 1 downto 0);

wptr_wrap_bit <= wptr_wrap_appended(WADDR_WIDTH);
rptr_wrap_bit <= rptr_wrap_appended(RADDR_WIDTH);
wptr_wrap_bit_rdomain  <= wptr_wrap_appended_rdomain (WADDR_WIDTH);
rptr_wrap_bit_wdomain  <= rptr_wrap_appended_wdomain (RADDR_WIDTH);

next_rptr_wrap_appended <= next_ptr(rptr_wrap_bit, rptr, TERMINAL_COUNT);
next_wptr_wrap_appended <= next_ptr(wptr_wrap_bit, wptr, TERMINAL_COUNT);

--ct092704
--num_empty_loc <= -- used for full, computed in wdomain
--   ( DEPTH + rptr_wdomain) - wptr when (rptr_wrap_bit_wdomain = wptr_wrap_bit)
--else
--   "0" & (rptr_wdomain -  wptr);

--num_unread_loc <= --used for empty, computed in rdomain
--   ( DEPTH + wptr_rdomain) - rptr when (wptr_wrap_bit_rdomain /= rptr_wrap_bit)
--else
--   "0" & (wptr_rdomain -  rptr);

process (rptr_wdomain, rptr_wrap_bit_wdomain, wptr, wptr_wrap_bit)
begin
   if (rptr_wrap_bit_wdomain /= wptr_wrap_bit) then
      -- An improper use of RPRST could cause num_unread_loc >= DEPTH,
      -- when the wrap bits are different but wptr > rptr
      num_unread_loc_wdomain <=  ( DEPTH + wptr) - rptr_wdomain;
   else 
      num_unread_loc_wdomain <= "0" & (wptr -  rptr_wdomain);
   end if;
end process;

process (wptr_rdomain, wptr_wrap_bit_rdomain, rptr, rptr_wrap_bit)
begin
   if (wptr_wrap_bit_rdomain /= rptr_wrap_bit) then
      -- An improper use of RPRST could cause num_unread_loc >= DEPTH,
      -- when the wrap bits are different but wptr > rptr
      num_unread_loc_rdomain <=  ( DEPTH + wptr_rdomain) - rptr;
   else 
      num_unread_loc_rdomain <= "0" & (wptr_rdomain - rptr  );
   end if;
end process;
--full_bit <= '1' when (num_empty_loc = 0) else '0';
--empty_bit <= '1' when (num_unread_loc = 0) else '0';

full_bit <= '1' when (num_unread_loc_wdomain >= DEPTH) else '0';
FULL <= full_bit;
AMFULL <= '1' when (num_unread_loc_wdomain >= DEPTH - ALMOST_FULL_X) else '0';

-- AMEMPTY/EMPTY  are ACTIVE LOW !!!!!!!!!!!!!!!!!!!!!!!!!!!!
empty_bit <= '1' when (num_unread_loc_rdomain = 0 ) else '0';
EMPTY <= not(empty_bit); 
AMEMPTY <= '0' when (num_unread_loc_rdomain <= ALMOST_EMPTY_Y) else '1';

-- ************************************************************************
-- DO LATCH
-- ************************************************************************
process (RCLK)
begin
   if (rising_edge (RCLK)) then 
      rden_p1 <= RE;
      empty_p1 <= empty_bit;
   end if;
end process;

process (do_ram, RST, rden_p1, empty_p1)
begin
   if (RST = '1') then
      DO <= (others => '0');
   elsif (rden_p1 = '1' and empty_p1 = '0') then
      DO <= do_ram;
   end if;
end process;
-- ************************************************************************
-- WRITE READ POINTERS
-- ************************************************************************
process (RST, WCLK)
begin

   if (RST = '1')  then
      wptr_wrap_appended <= (others => '0');
   elsif ( WCLK'event and WCLK = '1') then
      if (WE = '1' and full_bit = '0') then
         wptr_wrap_appended <= next_wptr_wrap_appended after 1 ns;
      end if;
   end if;
end process;

--ct092804
process (RST, RPRST, RCLK)
begin

   if (RST = '1'or RPRST = '1')  then
      rptr_wrap_appended <= (others => '0') ;
   elsif ( RCLK'event and RCLK = '1') then
      if ( (RE and not(empty_bit)) = '1') then
         rptr_wrap_appended <= next_rptr_wrap_appended after 1 ns;
      end if;
   end if ;   
end process;



-- ************************************************************************
-- POINTER SYNCHRONIZATIONS (SIMPLY DONE TO MATCH THE GATE-LEVEL MODEL)
-- ************************************************************************

process (RST, WCLK)
begin
   if (RST = '1')  then
      rptr_wrap_appended_wdomain <= (others => '0');
   elsif ( WCLK'event and WCLK = '1') then
      rptr_wrap_appended_wdomain <= rptr_wrap_appended after 1 ns;
   end if;
end process;


process (RST, RCLK)
begin
   if (RST = '1')  then
      wptr_wrap_appended_rdomain <= (others => '0');
   elsif ( RCLK'event and RCLK = '1') then
      wptr_wrap_appended_rdomain <= wptr_wrap_appended after 1 ns;
   end if;
end process;

-- ************************************************************************
-- END ARCHITECTURE: SC_FIFO_16K_L
-- ************************************************************************
end LATTICE_BEHAV; 





-- **********************************************************************
--
--  PseudoDPRAM: Behavioral Model
--  
-- **********************************************************************
--
--  Init: Sep. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_PDP_RAM.vhd
--  Description: Pseudo Dual Port BRAM behavioral model. 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_PDPRAM_16K is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        WADDR_WIDTH    : integer := 13;
        WDATA_WIDTH    : integer := 2;
        RADDR_WIDTH    : integer := 13;
        RDATA_WIDTH    : integer := 2;
        MEM_INIT_FLAG  : integer := 0;  
	MEM_INIT_FILE  : string  := ""

        );

  port (
        WCEN : in  STD_LOGIC ;
        WCLK : in  STD_LOGIC ;
        WE   : in  STD_LOGIC ;
        WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
        RCLK : in  STD_LOGIC;
        RCEN : in  STD_LOGIC;
        RST  : in  STD_LOGIC ;

        WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
        WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
        RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);  
        RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
       ); 

end SC_PDPRAM_16K ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_PDPRAM_16K is

 component SC_BRAM_PDP_16K

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
   	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal WCEN_node :  STD_LOGIC := 'X';
 signal WCLK_node :  STD_LOGIC := 'X';
 signal WE_node   :  STD_LOGIC := 'X';
 signal WCS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RCEN_node :  STD_LOGIC := 'X';
 signal RCLK_node :  STD_LOGIC := 'X';
 signal RST_node  :  STD_LOGIC := 'X';
 signal WD_node   :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_node  :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RD_node   :  STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0) := (others => 'X');
 signal RAD_node  :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0'); 
 

 signal WD_reg    :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_reg   :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RAD_reg   :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0');
 signal EN_reg    :  STD_LOGIC := 'X';
 signal REN_reg    :  STD_LOGIC := '1';
 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';
  WCEN_node <= WCEN;
  WCLK_node <= WCLK;
  WE_node   <= WE;
  WCS_node  <= WCS;
  RCEN_node <= RCEN;
  RCLK_node <= RCLK;
  RST_node  <= RST;
  WD_node   <= WD;
  WAD_node  <= WAD;
  RAD_node  <= RAD;
  RD        <= RD_node;

  -- Register WD/WAD/ Enable inputs
  register_write_inputs: process (WCLK_node, RST_node)
  begin
    if (RST_node = '1') then
      WD_reg <= (others =>'0');
      WAD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (WCLK_node'event and WCLK_node = '1') then
      if (WCEN_node = '1') then
        WD_reg  <= WD_node;
        WAD_reg <= WAD_node;
        EN_reg  <= WE_node  and WCS_node(0) and WCS_node(1);
       -- REN_reg  <= '1'; 
      end if;
    end if;
  end process register_write_inputs;   

-- Register RAD inputs
  register_read_inputs: process (RCLK_node, RST_node)
  begin
    if (RST_node = '1') then
      RAD_reg <= (others =>'0');
    elsif (RCLK_node'event and RCLK_node = '1') then
      if (RCEN_node = '1') then
        RAD_reg <= RAD_node;
        REN_reg  <= WCS_node(0) and WCS_node(1);
      end if;
    end if;
  end process register_read_inputs;   

-- BRAM instance for SPRAM 
  PDPRAM_INST: SC_BRAM_PDP_16K

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH,
         RADDR_WIDTH_A  => RADDR_WIDTH,
         WADDR_WIDTH_B  => WADDR_WIDTH,
         RADDR_WIDTH_B  => RADDR_WIDTH,
         WDATA_WIDTH_A  => WDATA_WIDTH,
         RDATA_WIDTH_A  => RDATA_WIDTH,
         WDATA_WIDTH_B  => WDATA_WIDTH,
         RDATA_WIDTH_B  => RDATA_WIDTH,
         ARRAY_SIZE     => open,
 	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE
       )
    port map (
         WADA => WAD_reg,
         WEA  => EN_reg,
         WDA  => WD_reg,
         RADA => RAD_reg,
         REA  => REN_reg,
         RDA  => RD_node,
         
         WADB => WAD_reg,
         WEB  => GND_sig,
         WDB  => WD_reg,
         RADB => RAD_reg,
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 

-- ************************************************************************
--
--  PseudoDPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Sep. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_PDP_RAM.vhd
--  Description: Pseudo Dual Port BRAM behavioral model. 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_PDPRAM_16K_L is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        WADDR_WIDTH    : integer := 13;
        WDATA_WIDTH    : integer := 2;
        RADDR_WIDTH    : integer := 13;
        RDATA_WIDTH    : integer := 2;
        MEM_INIT_FLAG  : integer := 1;  
        ARRAY_SIZE     : integer := 16384;
	MEM_INIT_FILE  : string  := "mem_init_file"

        );

  port (
        WCEN : in  STD_LOGIC ;
        WCLK : in  STD_LOGIC ;
        WE   : in  STD_LOGIC ;
        WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
        RCLK : in  STD_LOGIC;
        RCEN : in  STD_LOGIC;
        RST  : in  STD_LOGIC ;

        WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
        WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
        RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);  
        RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
       ); 

end SC_PDPRAM_16K_L ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_PDPRAM_16K_L is

 component SC_BRAM_PDP_16K_L

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
   	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal WCEN_node :  STD_LOGIC := 'X';
 signal WCLK_node :  STD_LOGIC := 'X';
 signal WE_node   :  STD_LOGIC := 'X';
 signal WCS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RCEN_node :  STD_LOGIC := 'X';
 signal RCLK_node :  STD_LOGIC := 'X';
 signal RST_node  :  STD_LOGIC := 'X';
 signal WD_node   :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_node  :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RD_node   :  STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0) := (others => 'X');
 signal RAD_node  :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0'); 
 

 signal WD_reg    :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_reg   :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RAD_reg   :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0');
 signal EN_reg    :  STD_LOGIC := 'X';
 signal REN_reg    :  STD_LOGIC := '1';
 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';
  WCEN_node <= WCEN;
  WCLK_node <= WCLK;
  WE_node   <= WE;
  WCS_node  <= WCS;
  RCEN_node <= RCEN;
  RCLK_node <= RCLK;
  RST_node  <= RST;
  WD_node   <= WD;
  WAD_node  <= WAD;
  RAD_node  <= RAD;
  RD        <= RD_node;

  -- Register WD/WAD/ Enable inputs
  register_write_inputs: process (WCLK_node, RST_node)
  begin
    if (RST_node = '1') then
      WD_reg <= (others =>'0');
      WAD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (WCLK_node'event and WCLK_node = '1') then
      if (WCEN_node = '1') then
        WD_reg  <= WD_node;
        WAD_reg <= WAD_node;
        EN_reg  <= WE_node  and WCS_node(0) and WCS_node(1);
      --  REN_reg  <= '1'; 
      end if;
    end if;
  end process register_write_inputs;   

-- Register RAD inputs
  register_read_inputs: process (RCLK_node, RST_node)
  begin
    if (RST_node = '1') then
      RAD_reg <= (others =>'0');
    elsif (RCLK_node'event and RCLK_node = '1') then
      if (RCEN_node = '1') then
        RAD_reg <= RAD_node;
        REN_reg  <= WCS_node(0) and WCS_node(1);
      end if;
    end if;
  end process register_read_inputs;   

-- BRAM instance for SPRAM 
  PDPRAM_INST: SC_BRAM_PDP_16K_L

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH,
         RADDR_WIDTH_A  => RADDR_WIDTH,
         WADDR_WIDTH_B  => WADDR_WIDTH,
         RADDR_WIDTH_B  => RADDR_WIDTH,
         WDATA_WIDTH_A  => WDATA_WIDTH,
         RDATA_WIDTH_A  => RDATA_WIDTH,
         WDATA_WIDTH_B  => WDATA_WIDTH,
         RDATA_WIDTH_B  => RDATA_WIDTH,
         ARRAY_SIZE     => ARRAY_SIZE,
 	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE
       )
    port map (
         WADA => WAD_reg,
         WEA  => EN_reg,
         WDA  => WD_reg,
         RADA => RAD_reg,
         REA  => REN_reg,
         RDA  => RD_node,
         
         WADB => WAD_reg,
         WEB  => GND_sig,
         WDB  => WD_reg,
         RADB => RAD_reg,
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 


-- ************************************************************************
--
--  PseudoDPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Apr. 2002
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_PDP_RAMA.vhd
--  Description: Asynchronous Read Pseudo Dual Port BRAM behavioral model. 
--
--  Compared with synchronous model 
--  Remove RCLK and RCEN ports   
--  
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_PDPRAMA_16K is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        WADDR_WIDTH    : integer := 13;
        WDATA_WIDTH    : integer := 2;
        RADDR_WIDTH    : integer := 13;
        RDATA_WIDTH    : integer := 2;
        MEM_INIT_FLAG  : integer := 0;  
	MEM_INIT_FILE  : string  := "mem_init_file"

        );

  port (
        WCEN : in  STD_LOGIC ;
        WCLK : in  STD_LOGIC ;
        WE   : in  STD_LOGIC ;
        WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
        RST  : in  STD_LOGIC ;

        WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
        WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
        RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);  
        RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
       ); 

end SC_PDPRAMA_16K ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_PDPRAMA_16K is

 component SC_BRAM_PDP_16K

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
    	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal WCEN_node :  STD_LOGIC := 'X';
 signal WCLK_node :  STD_LOGIC := 'X';
 signal WE_node   :  STD_LOGIC := 'X';
 signal WCS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RST_node  :  STD_LOGIC := 'X';
 signal WD_node   :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_node  :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RD_node   :  STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0) := (others => 'X');
 signal RAD_node  :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0'); 
 

 signal WD_reg    :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_reg   :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RAD_reg   :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0');
 signal EN_reg    :  STD_LOGIC := 'X';
 signal REN_reg   :  STD_LOGIC := '1';
 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';
  WCEN_node <= WCEN;
  WCLK_node <= WCLK;
  WE_node   <= WE;
  WCS_node  <= WCS;
  RST_node  <= RST;
  WD_node   <= WD;
  WAD_node  <= WAD;
  RAD_node  <= RAD;
  RD        <= RD_node;

  -- Register WD/WAD/ Enable inputs
  register_write_inputs: process (WCLK_node, RST_node)
  begin
    if (RST_node = '1') then
      WD_reg <= (others =>'0');
      WAD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (WCLK_node'event and WCLK_node = '1') then
        if  (WCEN_node = '1') then
        WD_reg  <= WD_node;
        WAD_reg <= WAD_node;
        EN_reg  <= WE_node  and WCS_node(0) and WCS_node(1);
        end if;
    end if;
  end process register_write_inputs;   

-- BRAM instance for SPRAM 
  PDPRAM_INST: SC_BRAM_PDP_16K

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH,
         RADDR_WIDTH_A  => RADDR_WIDTH,
         WADDR_WIDTH_B  => WADDR_WIDTH,
         RADDR_WIDTH_B  => RADDR_WIDTH,
         WDATA_WIDTH_A  => WDATA_WIDTH,
         RDATA_WIDTH_A  => RDATA_WIDTH,
         WDATA_WIDTH_B  => WDATA_WIDTH,
         RDATA_WIDTH_B  => RDATA_WIDTH,
         ARRAY_SIZE     => open,
  	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         WADA => WAD_reg,
         WEA  => EN_reg,
         WDA  => WD_reg,
         RADA => RAD_node,   
         REA  => REN_reg,
         RDA  => RD_node,
         
         WADB => WAD_reg,
         WEB  => GND_sig,
         WDB  => WD_reg,
         RADB => RAD_node,   
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 


-- ************************************************************************
--
--  PseudoDPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Apr. 2002
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_PDP_RAMA.vhd
--  Description: Asynchronous Read Pseudo Dual Port BRAM behavioral model. 
--
--  Compared with synchronous model 
--  Remove RCLK and RCEN ports   
--  
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_PDPRAMA_16K_L is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        WADDR_WIDTH    : integer := 13;
        WDATA_WIDTH    : integer := 2;
        RADDR_WIDTH    : integer := 13;
        RDATA_WIDTH    : integer := 2;
        ARRAY_SIZE     : integer := 16384;
        MEM_INIT_FLAG  : integer := 1;  
	MEM_INIT_FILE  : string  := "mem_init_file"

        );

  port (
        WCEN : in  STD_LOGIC ;
        WCLK : in  STD_LOGIC ;
        WE   : in  STD_LOGIC ;
        WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
        RST  : in  STD_LOGIC ;

        WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
        WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
        RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);  
        RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
       ); 

end SC_PDPRAMA_16K_L ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_PDPRAMA_16K_L is

 component SC_BRAM_PDP_16K_L

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
    	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal WCEN_node :  STD_LOGIC := 'X';
 signal WCLK_node :  STD_LOGIC := 'X';
 signal WE_node   :  STD_LOGIC := 'X';
 signal WCS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RST_node  :  STD_LOGIC := 'X';
 signal WD_node   :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_node  :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RD_node   :  STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0) := (others => 'X');
 signal RAD_node  :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0'); 
 

 signal WD_reg    :  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0) := (others => 'X');
 signal WAD_reg   :  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0) := (others => '0');
 signal RAD_reg   :  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0) := (others => '0');
 signal EN_reg    :  STD_LOGIC := 'X';
 signal REN_reg   :  STD_LOGIC := '1';
 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';
  WCEN_node <= WCEN;
  WCLK_node <= WCLK;
  WE_node   <= WE;
  WCS_node  <= WCS;
  RST_node  <= RST;
  WD_node   <= WD;
  WAD_node  <= WAD;
  RAD_node  <= RAD;
  RD        <= RD_node;

  -- Register WD/WAD/ Enable inputs
  register_write_inputs: process (WCLK_node, RST_node)
  begin
    if (RST_node = '1') then
      WD_reg <= (others =>'0');
      WAD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (WCLK_node'event and WCLK_node = '1') then
       if (WCEN_node = '1') then
        WD_reg  <= WD_node;
        WAD_reg <= WAD_node;
        EN_reg  <= WE_node  and WCS_node(0) and WCS_node(1);
       end if;
    end if;
  end process register_write_inputs;   

-- BRAM instance for SPRAM 
  PDPRAM_INST: SC_BRAM_PDP_16K_L

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH,
         RADDR_WIDTH_A  => RADDR_WIDTH,
         WADDR_WIDTH_B  => WADDR_WIDTH,
         RADDR_WIDTH_B  => RADDR_WIDTH,
         WDATA_WIDTH_A  => WDATA_WIDTH,
         RDATA_WIDTH_A  => RDATA_WIDTH,
         WDATA_WIDTH_B  => WDATA_WIDTH,
         RDATA_WIDTH_B  => RDATA_WIDTH,
         ARRAY_SIZE     => ARRAY_SIZE,
  	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         WADA => WAD_reg,
         WEA  => EN_reg,
         WDA  => WD_reg,
         RADA => RAD_node,   
         REA  => REN_reg,
         RDA  => RD_node,
         
         WADB => WAD_reg,
         WEB  => GND_sig,
         WDB  => WD_reg,
         RADB => RAD_node,   
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 


-- ************************************************************************
--
--  SPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Sep. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_SP_RAM.vhd
--  Description: Single Port BRAM behavioral model. 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_SPRAM_16K is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        ADDR_WIDTH     : integer := 13;
        DATA_WIDTH     : integer := 2;
        MEM_INIT_FLAG  : integer := 1;  
	MEM_INIT_FILE  : string  := "qq.dat"

	);

  port (
        CEN : in  STD_LOGIC ;
        CLK : in  STD_LOGIC ;
         WR : in  STD_LOGIC ;
         CS : in  STD_LOGIC_VECTOR (1 downto 0);
        RST : in  STD_LOGIC ;
         DI : in  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0);
         AD : in  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0);
         DO : out STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0)
       ); 

end SC_SPRAM_16K ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_SPRAM_16K is

 component SC_BRAM_16K

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
 	 MEM_INIT_FLAG : integer := 1;  
	 MEM_INIT_FILE : string  := "mem_init_file"

	  );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal CEN_node :  STD_LOGIC := 'X';
 signal CLK_node :  STD_LOGIC := 'X';
 signal WR_node  :  STD_LOGIC := 'X';
 signal CS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RST_node :  STD_LOGIC := 'X';
 signal DI_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal DO_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');

 signal DI_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal EN_reg   :  STD_LOGIC := 'X';
 signal REN_reg   :  STD_LOGIC := 'X';

 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';

  CEN_node <= CEN;
  CLK_node <= CLK;
  WR_node  <= WR;
  CS_node  <= CS;
  RST_node <= RST;
  DI_node  <= DI;
  AD_node  <= AD;
  DO       <= DO_node;

  -- Register DI/ AD / Enable inputs
  register_inputs: process (CLK_node, RST_node)
  begin
    if (RST_node = '1') then
      DI_reg <= (others =>'0');
      AD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (CLK_node'event and CLK_node = '1') then
      if (CEN_node = '1') then
        DI_reg <= DI_node;
        AD_reg <= AD_node;
        EN_reg <= WR_node  and CS_node(0) and CS_node(1);
      --  REN_reg <= '1'; 
        REN_reg <=CS_node(0) and CS_node(1);
      end if;
    end if;
  end process register_inputs;   

  -- BRAM instance for SPRAM 
  SPRAM_INST: SC_BRAM_16K

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => ADDR_WIDTH,
         RADDR_WIDTH_A  => ADDR_WIDTH,
         WADDR_WIDTH_B  => ADDR_WIDTH,
         RADDR_WIDTH_B  => ADDR_WIDTH,
         WDATA_WIDTH_A  => DATA_WIDTH,
         RDATA_WIDTH_A  => DATA_WIDTH,
         WDATA_WIDTH_B  => DATA_WIDTH,
         RDATA_WIDTH_B  => DATA_WIDTH,
         ARRAY_SIZE     => open,
	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE
       )
    port map (
         WADA => AD_reg,
         WEA  => EN_reg,
         WDA  => DI_reg,
         RADA => AD_reg,
         REA  => REN_reg,
         RDA  => DO_node,

         WADB => AD_reg,
         WEB  => GND_sig,
         WDB  => DI_reg,
         RADB => AD_reg,
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 


-- ************************************************************************
--
--  SPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Sep. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_SP_RAM.vhd
--  Description: Single Port BRAM behavioral model. 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_SPRAM_16K_L is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        ADDR_WIDTH     : integer := 13;
        DATA_WIDTH     : integer := 2;
        MEM_INIT_FLAG  : integer := 1;  
        ARRAY_SIZE     : integer := 16384;
	MEM_INIT_FILE  : string  := "qq.dat"

	);

  port (
        CEN : in  STD_LOGIC ;
        CLK : in  STD_LOGIC ;
         WR : in  STD_LOGIC ;
         CS : in  STD_LOGIC_VECTOR (1 downto 0);
        RST : in  STD_LOGIC ;
         DI : in  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0);
         AD : in  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0);
         DO : out STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0)
       ); 

end SC_SPRAM_16K_L ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_SPRAM_16K_L is

 component SC_BRAM_16K_L

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
 	 MEM_INIT_FLAG : integer := 1;  
	 MEM_INIT_FILE : string  := "mem_init_file"

	  );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal CEN_node :  STD_LOGIC := 'X';
 signal CLK_node :  STD_LOGIC := 'X';
 signal WR_node  :  STD_LOGIC := 'X';
 signal CS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RST_node :  STD_LOGIC := 'X';
 signal DI_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal DO_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');

 signal DI_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal EN_reg   :  STD_LOGIC := 'X';
 signal REN_reg   :  STD_LOGIC := 'X';

 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';

  CEN_node <= CEN;
  CLK_node <= CLK;
  WR_node  <= WR;
  CS_node  <= CS;
  RST_node <= RST;
  DI_node  <= DI;
  AD_node  <= AD;
  DO       <= DO_node;

  -- Register DI/ AD / Enable inputs
  register_inputs: process (CLK_node, RST_node)
  begin
    if (RST_node = '1') then
      DI_reg <= (others =>'0');
      AD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (CLK_node'event and CLK_node = '1') then
      if (CEN_node = '1') then
        DI_reg <= DI_node;
        AD_reg <= AD_node;
        EN_reg <= WR_node  and CS_node(0) and CS_node(1);
        --REN_reg <= '1'; 
        REN_reg <= CS_node(0) and CS_node(1); 
      end if;
    end if;
  end process register_inputs;   

  -- BRAM instance for SPRAM 
  SPRAM_INST: SC_BRAM_16K_L

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => ADDR_WIDTH,
         RADDR_WIDTH_A  => ADDR_WIDTH,
         WADDR_WIDTH_B  => ADDR_WIDTH,
         RADDR_WIDTH_B  => ADDR_WIDTH,
         WDATA_WIDTH_A  => DATA_WIDTH,
         RDATA_WIDTH_A  => DATA_WIDTH,
         WDATA_WIDTH_B  => DATA_WIDTH,
         RDATA_WIDTH_B  => DATA_WIDTH,
         ARRAY_SIZE     => open,
	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE
       )
    port map (
         WADA => AD_reg,
         WEA  => EN_reg,
         WDA  => DI_reg,
         RADA => AD_reg,
         REA  => REN_reg,
         RDA  => DO_node,

         WADB => AD_reg,
         WEB  => GND_sig,
         WDB  => DI_reg,
         RADB => AD_reg,
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 


-- ************************************************************************
--
--  SPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Apr. 2002
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_SP_RAMA.vhd
--  Description: Asynchronous Read Single Port BRAM behavioral model. 
--  Compared with synchronous model, 
--  no ports modification, just logic change 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_SPRAMA_16K is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        ADDR_WIDTH     : integer := 13;
        DATA_WIDTH     : integer := 2;
        MEM_INIT_FLAG  : integer := 0;  
	MEM_INIT_FILE  : string  := "mem_init_file"

	);

  port (
        CEN : in  STD_LOGIC ;
        CLK : in  STD_LOGIC ;
         WR : in  STD_LOGIC ;
         CS : in  STD_LOGIC_VECTOR (1 downto 0);
        RST : in  STD_LOGIC ;
         DI : in  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0);
         AD : in  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0);
         DO : out STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0)
       ); 

end SC_SPRAMA_16K ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_SPRAMA_16K is

 component SC_BRAM_16K

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
  	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal CEN_node :  STD_LOGIC := 'X';
 signal CLK_node :  STD_LOGIC := 'X';
 signal WR_node  :  STD_LOGIC := 'X';
 signal CS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RST_node :  STD_LOGIC := 'X';
 signal DI_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal DO_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');

 signal DI_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal EN_reg   :  STD_LOGIC := 'X';
 signal REN_reg   :  STD_LOGIC := '1';
 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';

  CEN_node <= CEN;
  CLK_node <= CLK;
  WR_node  <= WR;
  CS_node  <= CS;
  RST_node <= RST;
  DI_node  <= DI;
  AD_node  <= AD;

  DO       <= DO_node;


  -- Register DI/ AD / Enable inputs
  register_inputs: process (CLK_node, RST_node)
  begin
    if (RST_node = '1') then
      DI_reg <= (others =>'0');
      AD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (CLK_node'event and CLK_node = '1') then
      if (CEN_node = '1') then
        DI_reg <= DI_node;
        AD_reg <= AD_node;
        EN_reg <= WR_node  and CS_node(0) and CS_node(1);
        --REN_reg <= '1'; 
      end if;
    end if;
  end process register_inputs;   

  -- BRAM instance for SPRAM 
  SPRAM_INST: SC_BRAM_16K

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => ADDR_WIDTH,
         RADDR_WIDTH_A  => ADDR_WIDTH,
         WADDR_WIDTH_B  => ADDR_WIDTH,
         RADDR_WIDTH_B  => ADDR_WIDTH,
         WDATA_WIDTH_A  => DATA_WIDTH,
         RDATA_WIDTH_A  => DATA_WIDTH,
         WDATA_WIDTH_B  => DATA_WIDTH,
         RDATA_WIDTH_B  => DATA_WIDTH,
         ARRAY_SIZE     => open,
 	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
--       WADA => AD_reg,
         WADA => AD_reg,
         WEA  => EN_reg,
         WDA  => DI_reg,
--       RADA => AD_reg,  -- Synchronous
         RADA => AD_node, -- Asynchronous
	 REA  => REN_reg,
         RDA  => DO_node,
         
--       WADB => AD_reg,
         WADB => AD_reg,
         WEB  => GND_sig,
         WDB  => DI_reg,
         RADB => AD_reg,
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 

-- ************************************************************************
--
--  SPRAM: Behavioral Model
--  
-- ************************************************************************
--
--  Init: Apr. 2002
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_SP_RAMA.vhd
--  Description: Asynchronous Read Single Port BRAM behavioral model. 
--  Compared with synchronous model, 
--  no ports modification, just logic change 
--  History:
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

-- ************************************************************************
--  Entity definition  
--  Draft "generic" members 
-- ************************************************************************

entity SC_SPRAMA_16K_L is

  generic (

        DEVICE_FAMILY  : string  := "SuperCool";
        ADDR_WIDTH     : integer := 13;
        DATA_WIDTH     : integer := 2;
        ARRAY_SIZE     : integer := 16384;
        MEM_INIT_FLAG  : integer := 1;  
	MEM_INIT_FILE  : string  := "mem_init_file"

	);

  port (
        CEN : in  STD_LOGIC ;
        CLK : in  STD_LOGIC ;
         WR : in  STD_LOGIC ;
         CS : in  STD_LOGIC_VECTOR (1 downto 0);
        RST : in  STD_LOGIC ;
         DI : in  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0);
         AD : in  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0);
         DO : out STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0)
       ); 

end SC_SPRAMA_16K_L ;

-- ************************************************************************
-- architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_SPRAMA_16K_L is

 component SC_BRAM_16K_L

  generic (
 	     DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
  	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

 -- Signal Declaration
 
 signal CEN_node :  STD_LOGIC := 'X';
 signal CLK_node :  STD_LOGIC := 'X';
 signal WR_node  :  STD_LOGIC := 'X';
 signal CS_node  :  STD_LOGIC_VECTOR (1 downto 0) := (others => 'X');
 signal RST_node :  STD_LOGIC := 'X';
 signal DI_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_node  :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal DO_node  :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');

 signal DI_reg   :  STD_LOGIC_VECTOR (DATA_WIDTH-1 downto 0) := (others => 'X');
 signal AD_reg   :  STD_LOGIC_VECTOR (ADDR_WIDTH-1 downto 0) := (others => 'X');
 signal EN_reg   :  STD_LOGIC := 'X';
 signal REN_reg   :  STD_LOGIC := '1';
 signal GND_sig   :  STD_LOGIC;
 signal VCC_sig   :  STD_LOGIC;

 -- architecture

 begin
  GND_sig <= '0';
  VCC_sig <= '1';

  CEN_node <= CEN;
  CLK_node <= CLK;
  WR_node  <= WR;
  CS_node  <= CS;
  RST_node <= RST;
  DI_node  <= DI;
  AD_node  <= AD;

  DO       <= DO_node;


  -- Register DI/ AD / Enable inputs
  register_inputs: process (CLK_node, RST_node)
  begin
    if (RST_node = '1') then
      DI_reg <= (others =>'0');
      AD_reg <= (others =>'0');
      EN_reg <= '0';
      REN_reg <= '1';
    elsif (CLK_node'event and CLK_node = '1') then
      if (CEN_node = '1') then
        DI_reg <= DI_node;
        AD_reg <= AD_node;
        EN_reg <= WR_node  and CS_node(0) and CS_node(1);
       -- REN_reg <= '1'; 
      end if;
    end if;
  end process register_inputs;   

  -- BRAM instance for SPRAM 
  SPRAM_INST: SC_BRAM_16K_L

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => ADDR_WIDTH,
         RADDR_WIDTH_A  => ADDR_WIDTH,
         WADDR_WIDTH_B  => ADDR_WIDTH,
         RADDR_WIDTH_B  => ADDR_WIDTH,
         WDATA_WIDTH_A  => DATA_WIDTH,
         RDATA_WIDTH_A  => DATA_WIDTH,
         WDATA_WIDTH_B  => DATA_WIDTH,
         RDATA_WIDTH_B  => DATA_WIDTH,
         ARRAY_SIZE     => ARRAY_SIZE,
 	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
--       WADA => AD_reg,
         WADA => AD_reg,
         WEA  => EN_reg,
         WDA  => DI_reg,
--       RADA => AD_reg,  -- Synchronous
         RADA => AD_node, -- Asynchronous
	 REA  => REN_reg,
         RDA  => DO_node,
         
--       WADB => AD_reg,
         WADB => AD_reg,
         WEB  => GND_sig,
         WDB  => DI_reg,
         RADB => AD_reg,
         REB  => GND_sig,
         RDB  => open
      );

end LATTICE_BEHAV;
 

----- CELL RAMB16K_WX1_RX1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lc5kmx;
use lc5kmx.components.all;

-- entity declaration --
entity RAMB16K_WX1_RX1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      RAM_INIT_FILE   : string  := "";
      tpd_RCLK_RD0                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WCEN_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCEN_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;

      tsetup_RCEN_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RCEN_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WAD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD0_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD1_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD2_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD3_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD4_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD5_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD5_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD6_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD6_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD7_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD7_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD8_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD8_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD9_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD9_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD10_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD10_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD11_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD11_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD12_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD12_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD13_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD13_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_RAD0_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD0_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD1_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD1_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD2_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD2_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD3_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD3_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD4_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD4_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD5_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD5_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD6_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD6_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD7_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD7_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD8_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD8_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD9_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD9_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD10_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD10_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_RAD11_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD11_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_RAD12_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD12_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_RAD13_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD13_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      trecovery_RST_RCLK_posedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_RST_RCLK_posedge_posedge     :	VitalDelayType   := 0.0 ns;

      tpw_WCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RST_posedge                    :	VitalDelayType   := 2.0 ns;
      tipd_WCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RST                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      WCEN                            :	in    STD_ULOGIC;
      WCLK                            :	in    STD_ULOGIC;
      WCS0                            :	in    STD_ULOGIC;
      WCS1                            :	in    STD_ULOGIC;
      WE                              :	in    STD_ULOGIC;
      RCEN                            :	in    STD_ULOGIC;
      RCLK                            :	in    STD_ULOGIC;
      RST                             :	in    STD_ULOGIC;
      WD0                             :	in    STD_ULOGIC;
      WAD0                            :	in    STD_ULOGIC;
      WAD1                            :	in    STD_ULOGIC;
      WAD2                            :	in    STD_ULOGIC;
      WAD3                            :	in    STD_ULOGIC;
      WAD4                            :	in    STD_ULOGIC;
      WAD5                            :	in    STD_ULOGIC;
      WAD6                            :	in    STD_ULOGIC;
      WAD7                            :	in    STD_ULOGIC;
      WAD8                            :	in    STD_ULOGIC;
      WAD9                            :	in    STD_ULOGIC;
      WAD10                           :	in    STD_ULOGIC;
      WAD11                           :	in    STD_ULOGIC;
      WAD12                           :	in    STD_ULOGIC;
      WAD13                           :	in    STD_ULOGIC;
      RAD0                            :	in    STD_ULOGIC;
      RAD1                            :	in    STD_ULOGIC;
      RAD2                            :	in    STD_ULOGIC;
      RAD3                            :	in    STD_ULOGIC;
      RAD4                            :	in    STD_ULOGIC;
      RAD5                            :	in    STD_ULOGIC;
      RAD6                            :	in    STD_ULOGIC;
      RAD7                            :	in    STD_ULOGIC;
      RAD8                            :	in    STD_ULOGIC;
      RAD9                            :	in    STD_ULOGIC;
      RAD10                           :	in    STD_ULOGIC;
      RAD11                           :	in    STD_ULOGIC;
      RAD12                           :	in    STD_ULOGIC;
      RAD13                           :	in    STD_ULOGIC;
      RD0                             :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAMB16K_WX1_RX1 : entity is FALSE;
end RAMB16K_WX1_RX1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAMB16K_WX1_RX1 is
  attribute VITAL_LEVEL0 of VITAL : architecture is FALSE;

	component SC_PDPRAM_16K
	   generic (
		WADDR_WIDTH    : integer := 14;
		WDATA_WIDTH    : integer := 1;
		RADDR_WIDTH    : integer := 14;
		RDATA_WIDTH    : integer := 1;
		MEM_INIT_FLAG   : integer := 0;
		MEM_INIT_FILE   : string  := "dummy");
	   port (
		WCEN : in  STD_LOGIC ;
		WCLK : in  STD_LOGIC ;
		WE   : in  STD_LOGIC ;
		WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
		RCLK : in  STD_LOGIC;
		RCEN : in  STD_LOGIC;
		RST  : in  STD_LOGIC ;
		WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
		WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
		RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);
		RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
		);
	end component ;

      signal WCEN_ipd      : std_ulogic := 'X';
      signal WCLK_ipd      : std_ulogic := 'X';
      signal WCS0_ipd      : std_ulogic := 'X';
      signal WCS1_ipd      : std_ulogic := 'X';
      signal WE_ipd        : std_ulogic := 'X';

      signal RCEN_ipd      : std_ulogic := 'X';
      signal RCLK_ipd      : std_ulogic := 'X';
      signal RST_ipd       : std_ulogic := 'X';

      signal WD0_ipd      : std_logic_vector (0 downto 0) ;

      signal WAD0_ipd      : std_ulogic := 'X';
      signal WAD1_ipd      : std_ulogic := 'X';
      signal WAD2_ipd      : std_ulogic := 'X';
      signal WAD3_ipd      : std_ulogic := 'X';
      signal WAD4_ipd      : std_ulogic := 'X';
      signal WAD5_ipd      : std_ulogic := 'X';
      signal WAD6_ipd      : std_ulogic := 'X';
      signal WAD7_ipd      : std_ulogic := 'X';
      signal WAD8_ipd      : std_ulogic := 'X';
      signal WAD9_ipd      : std_ulogic := 'X';
      signal WAD10_ipd     : std_ulogic := 'X';
      signal WAD11_ipd     : std_ulogic := 'X';
      signal WAD12_ipd     : std_ulogic := 'X';
      signal WAD13_ipd     : std_ulogic := 'X';

      signal RAD0_ipd      : std_ulogic := 'X';
      signal RAD1_ipd      : std_ulogic := 'X';
      signal RAD2_ipd      : std_ulogic := 'X';
      signal RAD3_ipd      : std_ulogic := 'X';
      signal RAD4_ipd      : std_ulogic := 'X';
      signal RAD5_ipd      : std_ulogic := 'X';
      signal RAD6_ipd      : std_ulogic := 'X';
      signal RAD7_ipd      : std_ulogic := 'X';
      signal RAD8_ipd      : std_ulogic := 'X';
      signal RAD9_ipd      : std_ulogic := 'X';
      signal RAD10_ipd     : std_ulogic := 'X';
      signal RAD11_ipd     : std_ulogic := 'X';
      signal RAD12_ipd     : std_ulogic := 'X';
      signal RAD13_ipd     : std_ulogic := 'X';

	signal WCS : std_logic_vector (1 downto 0);
	signal WD  : std_logic_vector (0 downto 0);
 	signal WAD : std_logic_vector (13 downto 0);
	signal RAD : std_logic_vector (13 downto 0);
	signal RD  : std_logic_vector (0 downto 0);

      CONSTANT  RAM_INIT_FLAG       :  integer := init_flag(RAM_INIT_FILE);

begin 

	WCS <= WCS1_ipd & WCS0_ipd;
	WD <= WD0_ipd;
	WAD <= WAD13_ipd & WAD12_ipd & WAD11_ipd & WAD10_ipd & WAD9_ipd & WAD8_ipd & WAD7_ipd & WAD6_ipd & WAD5_ipd & WAD4_ipd & WAD3_ipd & WAD2_ipd & WAD1_ipd & WAD0_ipd;
	RAD <= RAD13_ipd & RAD12_ipd & RAD11_ipd & RAD10_ipd & RAD9_ipd & RAD8_ipd & RAD7_ipd & RAD6_ipd & RAD5_ipd & RAD4_ipd & RAD3_ipd & RAD2_ipd & RAD1_ipd & RAD0_ipd;

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin

        VitalWireDelay (WCEN_ipd, WCEN, tipd_WCEN);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
        VitalWireDelay (WCS0_ipd, WCS0, tipd_WCS0);
        VitalWireDelay (WCS1_ipd, WCS1, tipd_WCS1);
        VitalWireDelay (WE_ipd, WE, tipd_WE);

        VitalWireDelay (RCEN_ipd, RCEN, tipd_RCEN);
        VitalWireDelay (RCLK_ipd, RCLK, tipd_RCLK);

        VitalWireDelay (RST_ipd, RST, tipd_RST);

        VitalWireDelay (WD0_ipd(0), WD0, tipd_WD0);

        VitalWireDelay (WAD0_ipd, WAD0, tipd_WAD0);
        VitalWireDelay (WAD1_ipd, WAD1, tipd_WAD1);
        VitalWireDelay (WAD2_ipd, WAD2, tipd_WAD2);
        VitalWireDelay (WAD3_ipd, WAD3, tipd_WAD3);
        VitalWireDelay (WAD4_ipd, WAD4, tipd_WAD4);
        VitalWireDelay (WAD5_ipd, WAD5, tipd_WAD5);
        VitalWireDelay (WAD6_ipd, WAD6, tipd_WAD6);
        VitalWireDelay (WAD7_ipd, WAD7, tipd_WAD7);
        VitalWireDelay (WAD8_ipd, WAD8, tipd_WAD8);
        VitalWireDelay (WAD9_ipd, WAD9, tipd_WAD9);
        VitalWireDelay (WAD10_ipd, WAD10, tipd_WAD10);
        VitalWireDelay (WAD11_ipd, WAD11, tipd_WAD11);
        VitalWireDelay (WAD12_ipd, WAD12, tipd_WAD12);
        VitalWireDelay (WAD13_ipd, WAD13, tipd_WAD13);

        VitalWireDelay (RAD0_ipd, RAD0, tipd_RAD0);
        VitalWireDelay (RAD1_ipd, RAD1, tipd_RAD1);
        VitalWireDelay (RAD2_ipd, RAD2, tipd_RAD2);
        VitalWireDelay (RAD3_ipd, RAD3, tipd_RAD3);
        VitalWireDelay (RAD4_ipd, RAD4, tipd_RAD4);
        VitalWireDelay (RAD5_ipd, RAD5, tipd_RAD5);
        VitalWireDelay (RAD6_ipd, RAD6, tipd_RAD6);
        VitalWireDelay (RAD7_ipd, RAD7, tipd_RAD7);
        VitalWireDelay (RAD8_ipd, RAD8, tipd_RAD8);
        VitalWireDelay (RAD9_ipd, RAD9, tipd_RAD9);
        VitalWireDelay (RAD10_ipd, RAD10, tipd_RAD10);
        VitalWireDelay (RAD11_ipd, RAD11, tipd_RAD11);
        VitalWireDelay (RAD12_ipd, RAD12, tipd_RAD12);
        VitalWireDelay (RAD13_ipd, RAD13, tipd_RAD13);

      end block;

      --------------------
      --  Write Behavior
      --------------------
      VITALBehavior : process
        -- Local variables used for timing checks

        variable Tviol_WCEN_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS1_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WE_WCLK_posedge      : std_ulogic  := '0';

        variable Tviol_RCEN_RCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WD0_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WAD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD5_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD6_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD7_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD8_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD9_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD10_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD11_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD12_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD13_WCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RAD0_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD1_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD2_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD3_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD4_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD5_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD6_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD7_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD8_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD9_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD10_RCLK_posedge   : std_ulogic  := '0';
        variable Tviol_RAD11_RCLK_posedge   : std_ulogic  := '0';
        variable Tviol_RAD12_RCLK_posedge   : std_ulogic  := '0';
        variable Tviol_RAD13_RCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RST_RCLK_posedge_posedge   : std_ulogic  := '0';

        variable Tmkr_WCEN_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RCEN_RCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WAD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD6_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD7_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD8_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD9_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD10_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD11_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD12_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD13_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RAD0_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD1_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD2_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD3_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD4_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD5_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD6_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD7_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD8_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD9_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD10_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD11_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD12_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD13_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RST_RCLK_posedge_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RCLK       : std_ulogic := '0';
        variable PInfo_RCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RST       : std_ulogic := '0';
        variable PInfo_RST       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality
        variable Violation       : std_ulogic := '0';
        variable RD0_zd          : std_ulogic := 'X';
        variable O_GlitchData    : VitalGlitchDataType;

    begin

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WCEN_WCLK_posedge,
          TimingData              => Tmkr_WCEN_WCLK_posedge,
          TestSignal              => WCEN_ipd,
          TestSignalName          => "WCEN",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCEN_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCEN_WCLK_noedge_posedge,
          HoldLow                 => thold_WCEN_WCLK_noedge_posedge,
          HoldHigh                => thold_WCEN_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS0_WCLK_posedge,
          TimingData              => Tmkr_WCS0_WCLK_posedge,
          TestSignal              => WCS0_ipd,
          TestSignalName          => "WCS0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS0_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS0_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS1_WCLK_posedge,
          TimingData              => Tmkr_WCS1_WCLK_posedge,
          TestSignal              => WCS1_ipd,
          TestSignalName          => "WCS1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS1_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS1_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RCEN_RCLK_posedge,
          TimingData              => Tmkr_RCEN_RCLK_posedge,
          TestSignal              => RCEN_ipd,
          TestSignalName          => "RCEN",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RCEN_RCLK_noedge_posedge,
          SetupLow                => tsetup_RCEN_RCLK_noedge_posedge,
          HoldLow                 => thold_RCEN_RCLK_noedge_posedge,
          HoldHigh                => thold_RCEN_RCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WD0_WCLK_posedge,
          TimingData              => Tmkr_WD0_WCLK_posedge,
          TestSignal              => WD0_ipd,
          TestSignalName          => "WD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD0_WCLK_posedge,
          TimingData              => Tmkr_WAD0_WCLK_posedge,
          TestSignal              => WAD0_ipd,
          TestSignalName          => "WAD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD1_WCLK_posedge,
          TimingData              => Tmkr_WAD1_WCLK_posedge,
          TestSignal              => WAD1_ipd,
          TestSignalName          => "WAD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD1_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD1_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD2_WCLK_posedge,
          TimingData              => Tmkr_WAD2_WCLK_posedge,
          TestSignal              => WAD2_ipd,
          TestSignalName          => "WAD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD2_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD2_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD2_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD3_WCLK_posedge,
          TimingData              => Tmkr_WAD3_WCLK_posedge,
          TestSignal              => WAD3_ipd,
          TestSignalName          => "WAD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD3_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD3_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD3_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD4_WCLK_posedge,
          TimingData              => Tmkr_WAD4_WCLK_posedge,
          TestSignal              => WAD4_ipd,
          TestSignalName          => "WAD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD4_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD4_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD4_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD5_WCLK_posedge,
          TimingData              => Tmkr_WAD5_WCLK_posedge,
          TestSignal              => WAD5_ipd,
          TestSignalName          => "WAD5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD5_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD5_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD5_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD5_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD6_WCLK_posedge,
          TimingData              => Tmkr_WAD6_WCLK_posedge,
          TestSignal              => WAD6_ipd,
          TestSignalName          => "WAD6",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD6_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD6_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD6_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD6_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD7_WCLK_posedge,
          TimingData              => Tmkr_WAD7_WCLK_posedge,
          TestSignal              => WAD7_ipd,
          TestSignalName          => "WAD7",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD7_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD7_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD7_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD7_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD8_WCLK_posedge,
          TimingData              => Tmkr_WAD8_WCLK_posedge,
          TestSignal              => WAD8_ipd,
          TestSignalName          => "WAD8",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD8_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD8_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD8_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD8_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD9_WCLK_posedge,
          TimingData              => Tmkr_WAD9_WCLK_posedge,
          TestSignal              => WAD9_ipd,
          TestSignalName          => "WAD9",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD9_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD9_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD9_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD9_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD10_WCLK_posedge,
          TimingData              => Tmkr_WAD10_WCLK_posedge,
          TestSignal              => WAD10_ipd,
          TestSignalName          => "WAD10",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD10_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD10_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD10_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD10_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD11_WCLK_posedge,
          TimingData              => Tmkr_WAD11_WCLK_posedge,
          TestSignal              => WAD11_ipd,
          TestSignalName          => "WAD11",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD11_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD11_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD11_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD11_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD12_WCLK_posedge,
          TimingData              => Tmkr_WAD12_WCLK_posedge,
          TestSignal              => WAD12_ipd,
          TestSignalName          => "WAD12",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD12_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD12_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD12_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD12_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD13_WCLK_posedge,
          TimingData              => Tmkr_WAD13_WCLK_posedge,
          TestSignal              => WAD13_ipd,
          TestSignalName          => "WAD13",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD13_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD13_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD13_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD13_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalRecoveryRemovalCheck (
          Violation               => Tviol_RST_RCLK_posedge_posedge,
          TimingData              => Tmkr_RST_RCLK_posedge_posedge,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName          => "RCLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_RST_RCLK_posedge_posedge,
          Removal                 => thold_RST_RCLK_posedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RCLK,
          PeriodData              => PInfo_RCLK,
          TestSignal              => RCLK_ipd,
          TestSignalName          => "RCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RCLK_posedge,
          PulseWidthLow           => tpw_RCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RST,
          PeriodData              => PInfo_RST,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RST_posedge,
          PulseWidthLow           => tpw_RST_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD0_RCLK_posedge,
          TimingData              => Tmkr_RAD0_RCLK_posedge,
          TestSignal              => RAD0_ipd,
          TestSignalName          => "RAD0",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD0_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD0_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD0_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD0_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD1_RCLK_posedge,
          TimingData              => Tmkr_RAD1_RCLK_posedge,
          TestSignal              => RAD1_ipd,
          TestSignalName          => "RAD1",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD1_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD1_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD1_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD1_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD2_RCLK_posedge,
          TimingData              => Tmkr_RAD2_RCLK_posedge,
          TestSignal              => RAD2_ipd,
          TestSignalName          => "RAD2",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD2_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD2_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD2_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD2_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD3_RCLK_posedge,
          TimingData              => Tmkr_RAD3_RCLK_posedge,
          TestSignal              => RAD3_ipd,
          TestSignalName          => "RAD3",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD3_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD3_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD3_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD3_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD4_RCLK_posedge,
          TimingData              => Tmkr_RAD4_RCLK_posedge,
          TestSignal              => RAD4_ipd,
          TestSignalName          => "RAD4",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD4_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD4_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD4_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD4_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD5_RCLK_posedge,
          TimingData              => Tmkr_RAD5_RCLK_posedge,
          TestSignal              => RAD5_ipd,
          TestSignalName          => "RAD5",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD5_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD5_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD5_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD5_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD6_RCLK_posedge,
          TimingData              => Tmkr_RAD6_RCLK_posedge,
          TestSignal              => RAD6_ipd,
          TestSignalName          => "RAD6",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD6_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD6_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD6_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD6_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD7_RCLK_posedge,
          TimingData              => Tmkr_RAD7_RCLK_posedge,
          TestSignal              => RAD7_ipd,
          TestSignalName          => "RAD7",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD7_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD7_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD7_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD7_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD8_RCLK_posedge,
          TimingData              => Tmkr_RAD8_RCLK_posedge,
          TestSignal              => RAD8_ipd,
          TestSignalName          => "RAD8",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD8_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD8_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD8_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD8_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD9_RCLK_posedge,
          TimingData              => Tmkr_RAD9_RCLK_posedge,
          TestSignal              => RAD9_ipd,
          TestSignalName          => "RAD9",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD9_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD9_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD9_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD9_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD10_RCLK_posedge,
          TimingData              => Tmkr_RAD10_RCLK_posedge,
          TestSignal              => RAD10_ipd,
          TestSignalName          => "RAD10",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD10_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD10_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD10_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD10_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD11_RCLK_posedge,
          TimingData              => Tmkr_RAD11_RCLK_posedge,
          TestSignal              => RAD11_ipd,
          TestSignalName          => "RAD11",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD11_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD11_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD11_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD11_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD12_RCLK_posedge,
          TimingData              => Tmkr_RAD12_RCLK_posedge,
          TestSignal              => RAD12_ipd,
          TestSignalName          => "RAD12",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD12_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD12_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD12_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD12_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD13_RCLK_posedge,
          TimingData              => Tmkr_RAD13_RCLK_posedge,
          TestSignal              => RAD13_ipd,
          TestSignalName          => "RAD13",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD13_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD13_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD13_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD13_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WCEN_WCLK_posedge or Tviol_WE_WCLK_posedge or 
                 Tviol_WCS0_WCLK_posedge or Tviol_WCS1_WCLK_posedge or 
                 Tviol_WAD0_WCLK_posedge or Tviol_WAD1_WCLK_posedge or 
                 Tviol_WAD2_WCLK_posedge or Tviol_WAD3_WCLK_posedge or 
                 Tviol_WAD4_WCLK_posedge or Tviol_WAD5_WCLK_posedge or 
                 Tviol_WAD6_WCLK_posedge or Tviol_WAD7_WCLK_posedge or 
                 Tviol_WAD8_WCLK_posedge or Tviol_WAD9_WCLK_posedge or 
                 Tviol_WAD10_WCLK_posedge or Tviol_WAD11_WCLK_posedge or 
                 Tviol_WAD12_WCLK_posedge or Tviol_WD0_WCLK_posedge or
                 Tviol_RAD0_RCLK_posedge or Tviol_RAD1_RCLK_posedge or 
                 Tviol_RAD2_RCLK_posedge or Tviol_RAD3_RCLK_posedge or 
                 Tviol_RAD4_RCLK_posedge or Tviol_RAD5_RCLK_posedge or 
                 Tviol_RAD6_RCLK_posedge or Tviol_RAD7_RCLK_posedge or 
                 Tviol_RAD8_RCLK_posedge or Tviol_RAD9_RCLK_posedge or 
                 Tviol_RAD10_RCLK_posedge or Tviol_RAD11_RCLK_posedge or 
                 Tviol_RAD12_RCLK_posedge or Tviol_RAD13_RCLK_posedge or 
                 Tviol_RST_RCLK_posedge_posedge or 
                 Pviol_WCLK or Pviol_RCLK or Pviol_RST;

    -------------------------
    --  Functionality Section
    -------------------------

	RD0_zd := RD(0);

    VitalPathDelay01 (
      OutSignal => RD0,
      GlitchData => O_GlitchData,
      OutSignalName => "RD0",
      OutTemp => RD0_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD0, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

wait on WCEN_ipd,WCLK_ipd, WE_ipd, WCS, RCLK_ipd, RCEN_ipd, RST_ipd, WD, WAD, RAD, RD;

      end process VITALBehavior;

	PDPRAM_INST: SC_PDPRAM_16K
	   generic map (
		WADDR_WIDTH    => 14,
		WDATA_WIDTH    => 1,
		RADDR_WIDTH    => 14,
		RDATA_WIDTH    => 1,
		MEM_INIT_FLAG  => RAM_INIT_FLAG,
		MEM_INIT_FILE  => RAM_INIT_FILE)
	   port map (
		WCEN => WCEN_ipd ,
		WCLK => WCLK_ipd ,
		WE   => WE_ipd ,
		WCS  => WCS,
		RCLK => RCLK_ipd,
		RCEN => RCEN_ipd,
		RST  => RST_ipd ,
		WD   => WD,
		WAD  => WAD,
		RAD  => RAD,
		RD   => RD
		);


end VITAL;

configuration CFG_RAMB16K_WX1_RX1_VITAL of RAMB16K_WX1_RX1 is
   for VITAL
   end for;
end CFG_RAMB16K_WX1_RX1_VITAL;



----- CELL RAMB16K_WX1_RX2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lc5kmx;
use lc5kmx.components.all;

-- entity declaration --
entity RAMB16K_WX1_RX2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      RAM_INIT_FILE   : string  := "";
      tpd_RCLK_RD0                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD1                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WCEN_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCEN_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;

      tsetup_RCEN_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RCEN_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WAD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD0_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD1_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD2_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD3_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD4_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD5_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD5_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD6_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD6_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD7_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD7_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD8_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD8_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD9_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD9_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD10_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD10_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD11_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD11_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD12_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD12_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD13_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD13_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_RAD0_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD0_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD1_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD1_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD2_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD2_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD3_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD3_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD4_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD4_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD5_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD5_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD6_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD6_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD7_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD7_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD8_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD8_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD9_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD9_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD10_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD10_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_RAD11_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD11_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_RAD12_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD12_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      trecovery_RST_RCLK_posedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_RST_RCLK_posedge_posedge     :	VitalDelayType   := 0.0 ns;

      tpw_WCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RST_posedge                    :	VitalDelayType   := 2.0 ns;
      tipd_WCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RST                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      WCEN                            :	in    STD_ULOGIC;
      WCLK                            :	in    STD_ULOGIC;
      WCS0                            :	in    STD_ULOGIC;
      WCS1                            :	in    STD_ULOGIC;
      WE                              :	in    STD_ULOGIC;
      RCEN                            :	in    STD_ULOGIC;
      RCLK                            :	in    STD_ULOGIC;
      RST                             :	in    STD_ULOGIC;
      WD0                            :	in    STD_ULOGIC;
      WAD0                            :	in    STD_ULOGIC;
      WAD1                            :	in    STD_ULOGIC;
      WAD2                            :	in    STD_ULOGIC;
      WAD3                            :	in    STD_ULOGIC;
      WAD4                            :	in    STD_ULOGIC;
      WAD5                            :	in    STD_ULOGIC;
      WAD6                            :	in    STD_ULOGIC;
      WAD7                            :	in    STD_ULOGIC;
      WAD8                            :	in    STD_ULOGIC;
      WAD9                            :	in    STD_ULOGIC;
      WAD10                           :	in    STD_ULOGIC;
      WAD11                           :	in    STD_ULOGIC;
      WAD12                           :	in    STD_ULOGIC;
      WAD13                           :	in    STD_ULOGIC;
      RAD0                            :	in    STD_ULOGIC;
      RAD1                            :	in    STD_ULOGIC;
      RAD2                            :	in    STD_ULOGIC;
      RAD3                            :	in    STD_ULOGIC;
      RAD4                            :	in    STD_ULOGIC;
      RAD5                            :	in    STD_ULOGIC;
      RAD6                            :	in    STD_ULOGIC;
      RAD7                            :	in    STD_ULOGIC;
      RAD8                            :	in    STD_ULOGIC;
      RAD9                            :	in    STD_ULOGIC;
      RAD10                           :	in    STD_ULOGIC;
      RAD11                           :	in    STD_ULOGIC;
      RAD12                           :	in    STD_ULOGIC;
      RD0                             :	out    STD_ULOGIC;
      RD1                             :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAMB16K_WX1_RX2 : entity is FALSE;
end RAMB16K_WX1_RX2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAMB16K_WX1_RX2 is
  attribute VITAL_LEVEL0 of VITAL : architecture is FALSE;

	component SC_PDPRAM_16K
	   generic (
		WADDR_WIDTH    : integer := 14;
		WDATA_WIDTH    : integer := 1;
		RADDR_WIDTH    : integer := 13;
		RDATA_WIDTH    : integer := 2;
		MEM_INIT_FLAG   : integer := 0;
		MEM_INIT_FILE   : string  := "dummy");
	   port (
		WCEN : in  STD_LOGIC ;
		WCLK : in  STD_LOGIC ;
		WE   : in  STD_LOGIC ;
		WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
		RCLK : in  STD_LOGIC;
		RCEN : in  STD_LOGIC;
		RST  : in  STD_LOGIC ;
		WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
		WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
		RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);
		RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
		);
	end component ;


      signal WCEN_ipd      : std_ulogic := 'X';
      signal WCLK_ipd      : std_ulogic := 'X';
      signal WCS0_ipd      : std_ulogic := 'X';
      signal WCS1_ipd      : std_ulogic := 'X';
      signal WE_ipd        : std_ulogic := 'X';

      signal RCEN_ipd      : std_ulogic := 'X';
      signal RCLK_ipd      : std_ulogic := 'X';
      signal RST_ipd       : std_ulogic := 'X';

      signal WD0_ipd      : std_logic_vector(0 downto 0) ;

      signal WAD0_ipd      : std_ulogic := 'X';
      signal WAD1_ipd      : std_ulogic := 'X';
      signal WAD2_ipd      : std_ulogic := 'X';
      signal WAD3_ipd      : std_ulogic := 'X';
      signal WAD4_ipd      : std_ulogic := 'X';
      signal WAD5_ipd      : std_ulogic := 'X';
      signal WAD6_ipd      : std_ulogic := 'X';
      signal WAD7_ipd      : std_ulogic := 'X';
      signal WAD8_ipd      : std_ulogic := 'X';
      signal WAD9_ipd      : std_ulogic := 'X';
      signal WAD10_ipd     : std_ulogic := 'X';
      signal WAD11_ipd     : std_ulogic := 'X';
      signal WAD12_ipd     : std_ulogic := 'X';
      signal WAD13_ipd     : std_ulogic := 'X';

      signal RAD0_ipd      : std_ulogic := 'X';
      signal RAD1_ipd      : std_ulogic := 'X';
      signal RAD2_ipd      : std_ulogic := 'X';
      signal RAD3_ipd      : std_ulogic := 'X';
      signal RAD4_ipd      : std_ulogic := 'X';
      signal RAD5_ipd      : std_ulogic := 'X';
      signal RAD6_ipd      : std_ulogic := 'X';
      signal RAD7_ipd      : std_ulogic := 'X';
      signal RAD8_ipd      : std_ulogic := 'X';
      signal RAD9_ipd      : std_ulogic := 'X';
      signal RAD10_ipd     : std_ulogic := 'X';
      signal RAD11_ipd     : std_ulogic := 'X';
      signal RAD12_ipd     : std_ulogic := 'X';

	signal WCS : std_logic_vector (1 downto 0);
	signal WD  : std_logic_vector (0 downto 0);
 	signal WAD : std_logic_vector (13 downto 0);
	signal RAD : std_logic_vector (12 downto 0);
	signal RD  : std_logic_vector (1 downto 0);

      CONSTANT  RAM_INIT_FLAG       :  integer := init_flag(RAM_INIT_FILE);

begin 

	WCS <= WCS1_ipd & WCS0_ipd;
	WD <= WD0_ipd;
	WAD <= WAD13_ipd & WAD12_ipd & WAD11_ipd & WAD10_ipd & WAD9_ipd & WAD8_ipd & WAD7_ipd & WAD6_ipd & WAD5_ipd & WAD4_ipd & WAD3_ipd & WAD2_ipd & WAD1_ipd & WAD0_ipd;
	RAD <= RAD12_ipd & RAD11_ipd & RAD10_ipd & RAD9_ipd & RAD8_ipd & RAD7_ipd & RAD6_ipd & RAD5_ipd & RAD4_ipd & RAD3_ipd & RAD2_ipd & RAD1_ipd & RAD0_ipd;

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin

        VitalWireDelay (WCEN_ipd, WCEN, tipd_WCEN);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
        VitalWireDelay (WCS0_ipd, WCS0, tipd_WCS0);
        VitalWireDelay (WCS1_ipd, WCS1, tipd_WCS1);
        VitalWireDelay (WE_ipd, WE, tipd_WE);

        VitalWireDelay (RCEN_ipd, RCEN, tipd_RCEN);
        VitalWireDelay (RCLK_ipd, RCLK, tipd_RCLK);

        VitalWireDelay (RST_ipd, RST, tipd_RST);

        VitalWireDelay (WD0_ipd(0), WD0, tipd_WD0);

        VitalWireDelay (WAD0_ipd, WAD0, tipd_WAD0);
        VitalWireDelay (WAD1_ipd, WAD1, tipd_WAD1);
        VitalWireDelay (WAD2_ipd, WAD2, tipd_WAD2);
        VitalWireDelay (WAD3_ipd, WAD3, tipd_WAD3);
        VitalWireDelay (WAD4_ipd, WAD4, tipd_WAD4);
        VitalWireDelay (WAD5_ipd, WAD5, tipd_WAD5);
        VitalWireDelay (WAD6_ipd, WAD6, tipd_WAD6);
        VitalWireDelay (WAD7_ipd, WAD7, tipd_WAD7);
        VitalWireDelay (WAD8_ipd, WAD8, tipd_WAD8);
        VitalWireDelay (WAD9_ipd, WAD9, tipd_WAD9);
        VitalWireDelay (WAD10_ipd, WAD10, tipd_WAD10);
        VitalWireDelay (WAD11_ipd, WAD11, tipd_WAD11);
        VitalWireDelay (WAD12_ipd, WAD12, tipd_WAD12);
        VitalWireDelay (WAD13_ipd, WAD13, tipd_WAD13);

        VitalWireDelay (RAD0_ipd, RAD0, tipd_RAD0);
        VitalWireDelay (RAD1_ipd, RAD1, tipd_RAD1);
        VitalWireDelay (RAD2_ipd, RAD2, tipd_RAD2);
        VitalWireDelay (RAD3_ipd, RAD3, tipd_RAD3);
        VitalWireDelay (RAD4_ipd, RAD4, tipd_RAD4);
        VitalWireDelay (RAD5_ipd, RAD5, tipd_RAD5);
        VitalWireDelay (RAD6_ipd, RAD6, tipd_RAD6);
        VitalWireDelay (RAD7_ipd, RAD7, tipd_RAD7);
        VitalWireDelay (RAD8_ipd, RAD8, tipd_RAD8);
        VitalWireDelay (RAD9_ipd, RAD9, tipd_RAD9);
        VitalWireDelay (RAD10_ipd, RAD10, tipd_RAD10);
        VitalWireDelay (RAD11_ipd, RAD11, tipd_RAD11);
        VitalWireDelay (RAD12_ipd, RAD12, tipd_RAD12);

      end block;

      --------------------
      --  Write Behavior
      --------------------
      VITALBehavior : process
        -- Local variables used for timing checks

        variable Tviol_WCEN_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS1_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WE_WCLK_posedge      : std_ulogic  := '0';

        variable Tviol_RCEN_RCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WD0_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WAD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD5_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD6_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD7_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD8_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD9_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD10_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD11_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD12_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD13_WCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RAD0_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD1_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD2_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD3_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD4_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD5_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD6_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD7_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD8_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD9_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD10_RCLK_posedge   : std_ulogic  := '0';
        variable Tviol_RAD11_RCLK_posedge   : std_ulogic  := '0';
        variable Tviol_RAD12_RCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RST_RCLK_posedge_posedge   : std_ulogic  := '0';

        variable Tmkr_WCEN_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RCEN_RCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WAD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD6_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD7_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD8_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD9_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD10_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD11_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD12_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD13_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RAD0_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD1_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD2_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD3_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD4_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD5_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD6_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD7_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD8_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD9_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD10_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD11_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD12_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RST_RCLK_posedge_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RCLK       : std_ulogic := '0';
        variable PInfo_RCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RST       : std_ulogic := '0';
        variable PInfo_RST       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality
        variable Violation       : std_ulogic := '0';
        variable RD0_zd          : std_ulogic := 'X';
        variable RD1_zd          : std_ulogic := 'X';
        variable O_GlitchData    : VitalGlitchDataType;

    begin

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WCEN_WCLK_posedge,
          TimingData              => Tmkr_WCEN_WCLK_posedge,
          TestSignal              => WCEN_ipd,
          TestSignalName          => "WCEN",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCEN_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCEN_WCLK_noedge_posedge,
          HoldLow                 => thold_WCEN_WCLK_noedge_posedge,
          HoldHigh                => thold_WCEN_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS0_WCLK_posedge,
          TimingData              => Tmkr_WCS0_WCLK_posedge,
          TestSignal              => WCS0_ipd,
          TestSignalName          => "WCS0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS0_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS0_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS1_WCLK_posedge,
          TimingData              => Tmkr_WCS1_WCLK_posedge,
          TestSignal              => WCS1_ipd,
          TestSignalName          => "WCS1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS1_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS1_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RCEN_RCLK_posedge,
          TimingData              => Tmkr_RCEN_RCLK_posedge,
          TestSignal              => RCEN_ipd,
          TestSignalName          => "RCEN",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RCEN_RCLK_noedge_posedge,
          SetupLow                => tsetup_RCEN_RCLK_noedge_posedge,
          HoldLow                 => thold_RCEN_RCLK_noedge_posedge,
          HoldHigh                => thold_RCEN_RCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WD0_WCLK_posedge,
          TimingData              => Tmkr_WD0_WCLK_posedge,
          TestSignal              => WD0_ipd,
          TestSignalName          => "WD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalSetupHoldCheck (
          Violation               => Tviol_WAD0_WCLK_posedge,
          TimingData              => Tmkr_WAD0_WCLK_posedge,
          TestSignal              => WAD0_ipd,
          TestSignalName          => "WAD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD1_WCLK_posedge,
          TimingData              => Tmkr_WAD1_WCLK_posedge,
          TestSignal              => WAD1_ipd,
          TestSignalName          => "WAD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD1_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD1_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD2_WCLK_posedge,
          TimingData              => Tmkr_WAD2_WCLK_posedge,
          TestSignal              => WAD2_ipd,
          TestSignalName          => "WAD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD2_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD2_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD2_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD3_WCLK_posedge,
          TimingData              => Tmkr_WAD3_WCLK_posedge,
          TestSignal              => WAD3_ipd,
          TestSignalName          => "WAD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD3_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD3_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD3_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD4_WCLK_posedge,
          TimingData              => Tmkr_WAD4_WCLK_posedge,
          TestSignal              => WAD4_ipd,
          TestSignalName          => "WAD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD4_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD4_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD4_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD5_WCLK_posedge,
          TimingData              => Tmkr_WAD5_WCLK_posedge,
          TestSignal              => WAD5_ipd,
          TestSignalName          => "WAD5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD5_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD5_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD5_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD5_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD6_WCLK_posedge,
          TimingData              => Tmkr_WAD6_WCLK_posedge,
          TestSignal              => WAD6_ipd,
          TestSignalName          => "WAD6",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD6_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD6_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD6_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD6_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD7_WCLK_posedge,
          TimingData              => Tmkr_WAD7_WCLK_posedge,
          TestSignal              => WAD7_ipd,
          TestSignalName          => "WAD7",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD7_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD7_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD7_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD7_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD8_WCLK_posedge,
          TimingData              => Tmkr_WAD8_WCLK_posedge,
          TestSignal              => WAD8_ipd,
          TestSignalName          => "WAD8",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD8_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD8_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD8_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD8_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD9_WCLK_posedge,
          TimingData              => Tmkr_WAD9_WCLK_posedge,
          TestSignal              => WAD9_ipd,
          TestSignalName          => "WAD9",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD9_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD9_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD9_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD9_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD10_WCLK_posedge,
          TimingData              => Tmkr_WAD10_WCLK_posedge,
          TestSignal              => WAD10_ipd,
          TestSignalName          => "WAD10",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD10_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD10_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD10_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD10_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD11_WCLK_posedge,
          TimingData              => Tmkr_WAD11_WCLK_posedge,
          TestSignal              => WAD11_ipd,
          TestSignalName          => "WAD11",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD11_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD11_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD11_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD11_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD12_WCLK_posedge,
          TimingData              => Tmkr_WAD12_WCLK_posedge,
          TestSignal              => WAD12_ipd,
          TestSignalName          => "WAD12",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD12_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD12_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD12_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD12_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD13_WCLK_posedge,
          TimingData              => Tmkr_WAD13_WCLK_posedge,
          TestSignal              => WAD13_ipd,
          TestSignalName          => "WAD13",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD13_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD13_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD13_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD13_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalRecoveryRemovalCheck (
          Violation               => Tviol_RST_RCLK_posedge_posedge,
          TimingData              => Tmkr_RST_RCLK_posedge_posedge,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName          => "RCLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_RST_RCLK_posedge_posedge,
          Removal                 => thold_RST_RCLK_posedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RCLK,
          PeriodData              => PInfo_RCLK,
          TestSignal              => RCLK_ipd,
          TestSignalName          => "RCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RCLK_posedge,
          PulseWidthLow           => tpw_RCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RST,
          PeriodData              => PInfo_RST,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RST_posedge,
          PulseWidthLow           => tpw_RST_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD0_RCLK_posedge,
          TimingData              => Tmkr_RAD0_RCLK_posedge,
          TestSignal              => RAD0_ipd,
          TestSignalName          => "RAD0",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD0_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD0_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD0_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD0_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD1_RCLK_posedge,
          TimingData              => Tmkr_RAD1_RCLK_posedge,
          TestSignal              => RAD1_ipd,
          TestSignalName          => "RAD1",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD1_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD1_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD1_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD1_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD2_RCLK_posedge,
          TimingData              => Tmkr_RAD2_RCLK_posedge,
          TestSignal              => RAD2_ipd,
          TestSignalName          => "RAD2",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD2_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD2_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD2_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD2_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD3_RCLK_posedge,
          TimingData              => Tmkr_RAD3_RCLK_posedge,
          TestSignal              => RAD3_ipd,
          TestSignalName          => "RAD3",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD3_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD3_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD3_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD3_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD4_RCLK_posedge,
          TimingData              => Tmkr_RAD4_RCLK_posedge,
          TestSignal              => RAD4_ipd,
          TestSignalName          => "RAD4",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD4_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD4_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD4_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD4_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD5_RCLK_posedge,
          TimingData              => Tmkr_RAD5_RCLK_posedge,
          TestSignal              => RAD5_ipd,
          TestSignalName          => "RAD5",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD5_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD5_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD5_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD5_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD6_RCLK_posedge,
          TimingData              => Tmkr_RAD6_RCLK_posedge,
          TestSignal              => RAD6_ipd,
          TestSignalName          => "RAD6",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD6_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD6_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD6_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD6_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD7_RCLK_posedge,
          TimingData              => Tmkr_RAD7_RCLK_posedge,
          TestSignal              => RAD7_ipd,
          TestSignalName          => "RAD7",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD7_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD7_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD7_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD7_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD8_RCLK_posedge,
          TimingData              => Tmkr_RAD8_RCLK_posedge,
          TestSignal              => RAD8_ipd,
          TestSignalName          => "RAD8",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD8_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD8_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD8_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD8_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD9_RCLK_posedge,
          TimingData              => Tmkr_RAD9_RCLK_posedge,
          TestSignal              => RAD9_ipd,
          TestSignalName          => "RAD9",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD9_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD9_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD9_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD9_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD10_RCLK_posedge,
          TimingData              => Tmkr_RAD10_RCLK_posedge,
          TestSignal              => RAD10_ipd,
          TestSignalName          => "RAD10",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD10_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD10_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD10_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD10_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD11_RCLK_posedge,
          TimingData              => Tmkr_RAD11_RCLK_posedge,
          TestSignal              => RAD11_ipd,
          TestSignalName          => "RAD11",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD11_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD11_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD11_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD11_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD12_RCLK_posedge,
          TimingData              => Tmkr_RAD12_RCLK_posedge,
          TestSignal              => RAD12_ipd,
          TestSignalName          => "RAD12",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD12_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD12_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD12_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD12_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX2",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


    end if;

    Violation := Tviol_WCEN_WCLK_posedge or Tviol_WE_WCLK_posedge or 
                 Tviol_WCS0_WCLK_posedge or Tviol_WCS1_WCLK_posedge or 
                 Tviol_WAD0_WCLK_posedge or Tviol_WAD1_WCLK_posedge or 
                 Tviol_WAD2_WCLK_posedge or Tviol_WAD3_WCLK_posedge or 
                 Tviol_WAD4_WCLK_posedge or Tviol_WAD5_WCLK_posedge or 
                 Tviol_WAD6_WCLK_posedge or Tviol_WAD7_WCLK_posedge or 
                 Tviol_WAD8_WCLK_posedge or Tviol_WAD9_WCLK_posedge or 
                 Tviol_WAD10_WCLK_posedge or Tviol_WAD11_WCLK_posedge or 
                 Tviol_WAD12_WCLK_posedge or Tviol_WD0_WCLK_posedge or
                 Tviol_RAD0_RCLK_posedge or Tviol_RAD1_RCLK_posedge or 
                 Tviol_RAD2_RCLK_posedge or Tviol_RAD3_RCLK_posedge or 
                 Tviol_RAD4_RCLK_posedge or Tviol_RAD5_RCLK_posedge or 
                 Tviol_RAD6_RCLK_posedge or Tviol_RAD7_RCLK_posedge or 
                 Tviol_RAD8_RCLK_posedge or Tviol_RAD9_RCLK_posedge or 
                 Tviol_RAD10_RCLK_posedge or Tviol_RAD11_RCLK_posedge or 
                 Tviol_RAD12_RCLK_posedge or 
                 Tviol_RST_RCLK_posedge_posedge or 
                 Pviol_WCLK or Pviol_RCLK or Pviol_RST;

    -------------------------
    --  Functionality Section
    -------------------------

wait on WCEN_ipd,WCLK_ipd, WE_ipd, WCS, RCLK_ipd, RCEN_ipd, RST_ipd, WD, WAD, RAD;


      end process VITALBehavior;
    VitalBehavior_RD0  : process
      variable RD0_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD0_zd := RD(0);

    VitalPathDelay01 (
      OutSignal => RD0,
      GlitchData => O_GlitchData,
      OutSignalName => "RD0",
      OutTemp => RD0_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD0, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD0, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(0);
      end process;

    VitalBehavior_RD1  : process
      variable RD1_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD1_zd := RD(1);

    VitalPathDelay01 (
      OutSignal => RD1,
      GlitchData => O_GlitchData,
      OutSignalName => "RD1",
      OutTemp => RD1_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD1, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD1, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(1);
      end process;

	PDPRAM_INST: SC_PDPRAM_16K
	   generic map (
		WADDR_WIDTH    => 14,
		WDATA_WIDTH    => 1,
		RADDR_WIDTH    => 13,
		RDATA_WIDTH    => 2,
		MEM_INIT_FLAG  => RAM_INIT_FLAG,
		MEM_INIT_FILE  => RAM_INIT_FILE)
	   port map (
		WCEN => WCEN_ipd ,
		WCLK => WCLK_ipd ,
		WE   => WE_ipd ,
		WCS  => WCS,
		RCLK => RCLK_ipd,
		RCEN => RCEN_ipd,
		RST  => RST_ipd ,
		WD   => WD,
		WAD  => WAD,
		RAD  => RAD,
		RD   => RD
		);

end VITAL;

configuration CFG_RAMB16K_WX1_RX2_VITAL of RAMB16K_WX1_RX2 is
   for VITAL
   end for;
end CFG_RAMB16K_WX1_RX2_VITAL;



----- CELL RAMB16K_WX1_RX4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lc5kmx;
use lc5kmx.components.all;

-- entity declaration --
entity RAMB16K_WX1_RX4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      RAM_INIT_FILE   : string  := "";
      tpd_RCLK_RD0                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD1                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD2                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD3                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_RST_RD0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tsetup_WCEN_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCEN_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;

      tsetup_RCEN_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RCEN_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WAD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD0_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD1_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD2_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD3_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD4_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD5_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD5_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD6_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD6_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD7_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD7_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD8_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD8_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD9_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD9_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD10_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD10_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD11_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD11_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD12_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD12_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD13_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD13_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_RAD0_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD0_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD1_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD1_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD2_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD2_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD3_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD3_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD4_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD4_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD5_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD5_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD6_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD6_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD7_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD7_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD8_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD8_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD9_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD9_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD10_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD10_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_RAD11_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD11_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      trecovery_RST_RCLK_posedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_RST_RCLK_posedge_posedge     :	VitalDelayType   := 0.0 ns;

      tpw_WCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RST_posedge                    :	VitalDelayType   := 2.0 ns;
      tipd_WCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RST                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      WCEN                            :	in    STD_ULOGIC;
      WCLK                            :	in    STD_ULOGIC;
      WCS0                            :	in    STD_ULOGIC;
      WCS1                            :	in    STD_ULOGIC;
      WE                              :	in    STD_ULOGIC;
      RCEN                            :	in    STD_ULOGIC;
      RCLK                            :	in    STD_ULOGIC;
      RST                             :	in    STD_ULOGIC;
      WD0                            :	in    STD_ULOGIC;
      WAD0                            :	in    STD_ULOGIC;
      WAD1                            :	in    STD_ULOGIC;
      WAD2                            :	in    STD_ULOGIC;
      WAD3                            :	in    STD_ULOGIC;
      WAD4                            :	in    STD_ULOGIC;
      WAD5                            :	in    STD_ULOGIC;
      WAD6                            :	in    STD_ULOGIC;
      WAD7                            :	in    STD_ULOGIC;
      WAD8                            :	in    STD_ULOGIC;
      WAD9                            :	in    STD_ULOGIC;
      WAD10                           :	in    STD_ULOGIC;
      WAD11                           :	in    STD_ULOGIC;
      WAD12                           :	in    STD_ULOGIC;
      WAD13                           :	in    STD_ULOGIC;
      RAD0                            :	in    STD_ULOGIC;
      RAD1                            :	in    STD_ULOGIC;
      RAD2                            :	in    STD_ULOGIC;
      RAD3                            :	in    STD_ULOGIC;
      RAD4                            :	in    STD_ULOGIC;
      RAD5                            :	in    STD_ULOGIC;
      RAD6                            :	in    STD_ULOGIC;
      RAD7                            :	in    STD_ULOGIC;
      RAD8                            :	in    STD_ULOGIC;
      RAD9                            :	in    STD_ULOGIC;
      RAD10                           :	in    STD_ULOGIC;
      RAD11                           :	in    STD_ULOGIC;
      RD0                             :	out    STD_ULOGIC;
      RD1                             :	out    STD_ULOGIC;
      RD2                             :	out    STD_ULOGIC;
      RD3                             :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAMB16K_WX1_RX4 : entity is FALSE;
end RAMB16K_WX1_RX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAMB16K_WX1_RX4 is
  attribute VITAL_LEVEL0 of VITAL : architecture is FALSE;

	component SC_PDPRAM_16K
	   generic (
		WADDR_WIDTH    : integer := 14;
		WDATA_WIDTH    : integer := 1;
		RADDR_WIDTH    : integer := 12;
		RDATA_WIDTH    : integer := 4;
		MEM_INIT_FLAG   : integer := 0;
		MEM_INIT_FILE   : string  := "dummy");
	   port (
		WCEN : in  STD_LOGIC ;
		WCLK : in  STD_LOGIC ;
		WE   : in  STD_LOGIC ;
		WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
		RCLK : in  STD_LOGIC;
		RCEN : in  STD_LOGIC;
		RST  : in  STD_LOGIC ;
		WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
		WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
		RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);
		RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
		);
	end component ;

      signal WCEN_ipd      : std_ulogic := 'X';
      signal WCLK_ipd      : std_ulogic := 'X';
      signal WCS0_ipd      : std_ulogic := 'X';
      signal WCS1_ipd      : std_ulogic := 'X';
      signal WE_ipd        : std_ulogic := 'X';

      signal RCEN_ipd      : std_ulogic := 'X';
      signal RCLK_ipd      : std_ulogic := 'X';
      signal RST_ipd       : std_ulogic := 'X';

      signal WD0_ipd      : std_logic_vector(0 downto 0);

      signal WAD0_ipd      : std_ulogic := 'X';
      signal WAD1_ipd      : std_ulogic := 'X';
      signal WAD2_ipd      : std_ulogic := 'X';
      signal WAD3_ipd      : std_ulogic := 'X';
      signal WAD4_ipd      : std_ulogic := 'X';
      signal WAD5_ipd      : std_ulogic := 'X';
      signal WAD6_ipd      : std_ulogic := 'X';
      signal WAD7_ipd      : std_ulogic := 'X';
      signal WAD8_ipd      : std_ulogic := 'X';
      signal WAD9_ipd      : std_ulogic := 'X';
      signal WAD10_ipd     : std_ulogic := 'X';
      signal WAD11_ipd     : std_ulogic := 'X';
      signal WAD12_ipd     : std_ulogic := 'X';
      signal WAD13_ipd     : std_ulogic := 'X';

      signal RAD0_ipd      : std_ulogic := 'X';
      signal RAD1_ipd      : std_ulogic := 'X';
      signal RAD2_ipd      : std_ulogic := 'X';
      signal RAD3_ipd      : std_ulogic := 'X';
      signal RAD4_ipd      : std_ulogic := 'X';
      signal RAD5_ipd      : std_ulogic := 'X';
      signal RAD6_ipd      : std_ulogic := 'X';
      signal RAD7_ipd      : std_ulogic := 'X';
      signal RAD8_ipd      : std_ulogic := 'X';
      signal RAD9_ipd      : std_ulogic := 'X';
      signal RAD10_ipd     : std_ulogic := 'X';
      signal RAD11_ipd     : std_ulogic := 'X';

	signal WCS : std_logic_vector (1 downto 0);
	signal WD  : std_logic_vector (0 downto 0);
 	signal WAD : std_logic_vector (13 downto 0);
	signal RAD : std_logic_vector (11 downto 0);
	signal RD  : std_logic_vector (3 downto 0);

      CONSTANT  RAM_INIT_FLAG       :  integer := init_flag(RAM_INIT_FILE);

begin 

	WCS <= WCS1_ipd & WCS0_ipd;
	WD <= WD0_ipd;
	WAD <= WAD13_ipd & WAD12_ipd & WAD11_ipd & WAD10_ipd & WAD9_ipd & WAD8_ipd & WAD7_ipd & WAD6_ipd & WAD5_ipd & WAD4_ipd & WAD3_ipd & WAD2_ipd & WAD1_ipd & WAD0_ipd;
	RAD <= RAD11_ipd & RAD10_ipd & RAD9_ipd & RAD8_ipd & RAD7_ipd & RAD6_ipd & RAD5_ipd & RAD4_ipd & RAD3_ipd & RAD2_ipd & RAD1_ipd & RAD0_ipd;

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin

        VitalWireDelay (WCEN_ipd, WCEN, tipd_WCEN);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
        VitalWireDelay (WCS0_ipd, WCS0, tipd_WCS0);
        VitalWireDelay (WCS1_ipd, WCS1, tipd_WCS1);
        VitalWireDelay (WE_ipd, WE, tipd_WE);

        VitalWireDelay (RCEN_ipd, RCEN, tipd_RCEN);
        VitalWireDelay (RCLK_ipd, RCLK, tipd_RCLK);

        VitalWireDelay (RST_ipd, RST, tipd_RST);

        VitalWireDelay (WD0_ipd(0), WD0, tipd_WD0);

        VitalWireDelay (WAD0_ipd, WAD0, tipd_WAD0);
        VitalWireDelay (WAD1_ipd, WAD1, tipd_WAD1);
        VitalWireDelay (WAD2_ipd, WAD2, tipd_WAD2);
        VitalWireDelay (WAD3_ipd, WAD3, tipd_WAD3);
        VitalWireDelay (WAD4_ipd, WAD4, tipd_WAD4);
        VitalWireDelay (WAD5_ipd, WAD5, tipd_WAD5);
        VitalWireDelay (WAD6_ipd, WAD6, tipd_WAD6);
        VitalWireDelay (WAD7_ipd, WAD7, tipd_WAD7);
        VitalWireDelay (WAD8_ipd, WAD8, tipd_WAD8);
        VitalWireDelay (WAD9_ipd, WAD9, tipd_WAD9);
        VitalWireDelay (WAD10_ipd, WAD10, tipd_WAD10);
        VitalWireDelay (WAD11_ipd, WAD11, tipd_WAD11);
        VitalWireDelay (WAD12_ipd, WAD12, tipd_WAD12);
        VitalWireDelay (WAD13_ipd, WAD13, tipd_WAD13);

        VitalWireDelay (RAD0_ipd, RAD0, tipd_RAD0);
        VitalWireDelay (RAD1_ipd, RAD1, tipd_RAD1);
        VitalWireDelay (RAD2_ipd, RAD2, tipd_RAD2);
        VitalWireDelay (RAD3_ipd, RAD3, tipd_RAD3);
        VitalWireDelay (RAD4_ipd, RAD4, tipd_RAD4);
        VitalWireDelay (RAD5_ipd, RAD5, tipd_RAD5);
        VitalWireDelay (RAD6_ipd, RAD6, tipd_RAD6);
        VitalWireDelay (RAD7_ipd, RAD7, tipd_RAD7);
        VitalWireDelay (RAD8_ipd, RAD8, tipd_RAD8);
        VitalWireDelay (RAD9_ipd, RAD9, tipd_RAD9);
        VitalWireDelay (RAD10_ipd, RAD10, tipd_RAD10);
        VitalWireDelay (RAD11_ipd, RAD11, tipd_RAD11);

      end block;

      --------------------
      --  Write Behavior
      --------------------
      VITALBehavior : process
        -- Local variables used for timing checks

        variable Tviol_WCEN_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS1_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WE_WCLK_posedge      : std_ulogic  := '0';

        variable Tviol_RCEN_RCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WD0_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WAD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD5_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD6_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD7_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD8_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD9_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD10_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD11_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD12_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD13_WCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RAD0_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD1_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD2_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD3_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD4_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD5_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD6_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD7_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD8_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD9_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD10_RCLK_posedge   : std_ulogic  := '0';
        variable Tviol_RAD11_RCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RST_RCLK_posedge_posedge   : std_ulogic  := '0';

        variable Tmkr_WCEN_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RCEN_RCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WAD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD6_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD7_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD8_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD9_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD10_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD11_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD12_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD13_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RAD0_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD1_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD2_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD3_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD4_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD5_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD6_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD7_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD8_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD9_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD10_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD11_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RST_RCLK_posedge_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RCLK       : std_ulogic := '0';
        variable PInfo_RCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RST       : std_ulogic := '0';
        variable PInfo_RST       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality
        variable Violation       : std_ulogic := '0';
        variable RD0_zd          : std_ulogic := 'X';
        variable RD1_zd          : std_ulogic := 'X';
        variable RD2_zd          : std_ulogic := 'X';
        variable RD3_zd          : std_ulogic := 'X';
        variable O_GlitchData    : VitalGlitchDataType;

    begin

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WCEN_WCLK_posedge,
          TimingData              => Tmkr_WCEN_WCLK_posedge,
          TestSignal              => WCEN_ipd,
          TestSignalName          => "WCEN",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCEN_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCEN_WCLK_noedge_posedge,
          HoldLow                 => thold_WCEN_WCLK_noedge_posedge,
          HoldHigh                => thold_WCEN_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS0_WCLK_posedge,
          TimingData              => Tmkr_WCS0_WCLK_posedge,
          TestSignal              => WCS0_ipd,
          TestSignalName          => "WCS0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS0_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS0_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS1_WCLK_posedge,
          TimingData              => Tmkr_WCS1_WCLK_posedge,
          TestSignal              => WCS1_ipd,
          TestSignalName          => "WCS1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS1_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS1_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RCEN_RCLK_posedge,
          TimingData              => Tmkr_RCEN_RCLK_posedge,
          TestSignal              => RCEN_ipd,
          TestSignalName          => "RCEN",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RCEN_RCLK_noedge_posedge,
          SetupLow                => tsetup_RCEN_RCLK_noedge_posedge,
          HoldLow                 => thold_RCEN_RCLK_noedge_posedge,
          HoldHigh                => thold_RCEN_RCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WD0_WCLK_posedge,
          TimingData              => Tmkr_WD0_WCLK_posedge,
          TestSignal              => WD0_ipd,
          TestSignalName          => "WD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalSetupHoldCheck (
          Violation               => Tviol_WAD0_WCLK_posedge,
          TimingData              => Tmkr_WAD0_WCLK_posedge,
          TestSignal              => WAD0_ipd,
          TestSignalName          => "WAD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD1_WCLK_posedge,
          TimingData              => Tmkr_WAD1_WCLK_posedge,
          TestSignal              => WAD1_ipd,
          TestSignalName          => "WAD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD1_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD1_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD2_WCLK_posedge,
          TimingData              => Tmkr_WAD2_WCLK_posedge,
          TestSignal              => WAD2_ipd,
          TestSignalName          => "WAD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD2_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD2_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD2_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD3_WCLK_posedge,
          TimingData              => Tmkr_WAD3_WCLK_posedge,
          TestSignal              => WAD3_ipd,
          TestSignalName          => "WAD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD3_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD3_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD3_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD4_WCLK_posedge,
          TimingData              => Tmkr_WAD4_WCLK_posedge,
          TestSignal              => WAD4_ipd,
          TestSignalName          => "WAD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD4_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD4_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD4_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD5_WCLK_posedge,
          TimingData              => Tmkr_WAD5_WCLK_posedge,
          TestSignal              => WAD5_ipd,
          TestSignalName          => "WAD5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD5_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD5_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD5_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD5_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD6_WCLK_posedge,
          TimingData              => Tmkr_WAD6_WCLK_posedge,
          TestSignal              => WAD6_ipd,
          TestSignalName          => "WAD6",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD6_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD6_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD6_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD6_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD7_WCLK_posedge,
          TimingData              => Tmkr_WAD7_WCLK_posedge,
          TestSignal              => WAD7_ipd,
          TestSignalName          => "WAD7",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD7_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD7_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD7_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD7_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD8_WCLK_posedge,
          TimingData              => Tmkr_WAD8_WCLK_posedge,
          TestSignal              => WAD8_ipd,
          TestSignalName          => "WAD8",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD8_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD8_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD8_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD8_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD9_WCLK_posedge,
          TimingData              => Tmkr_WAD9_WCLK_posedge,
          TestSignal              => WAD9_ipd,
          TestSignalName          => "WAD9",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD9_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD9_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD9_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD9_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD10_WCLK_posedge,
          TimingData              => Tmkr_WAD10_WCLK_posedge,
          TestSignal              => WAD10_ipd,
          TestSignalName          => "WAD10",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD10_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD10_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD10_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD10_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD11_WCLK_posedge,
          TimingData              => Tmkr_WAD11_WCLK_posedge,
          TestSignal              => WAD11_ipd,
          TestSignalName          => "WAD11",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD11_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD11_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD11_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD11_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD12_WCLK_posedge,
          TimingData              => Tmkr_WAD12_WCLK_posedge,
          TestSignal              => WAD12_ipd,
          TestSignalName          => "WAD12",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD12_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD12_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD12_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD12_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD13_WCLK_posedge,
          TimingData              => Tmkr_WAD13_WCLK_posedge,
          TestSignal              => WAD13_ipd,
          TestSignalName          => "WAD13",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD13_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD13_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD13_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD13_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalRecoveryRemovalCheck (
          Violation               => Tviol_RST_RCLK_posedge_posedge,
          TimingData              => Tmkr_RST_RCLK_posedge_posedge,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName          => "RCLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_RST_RCLK_posedge_posedge,
          Removal                 => thold_RST_RCLK_posedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RCLK,
          PeriodData              => PInfo_RCLK,
          TestSignal              => RCLK_ipd,
          TestSignalName          => "RCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RCLK_posedge,
          PulseWidthLow           => tpw_RCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RST,
          PeriodData              => PInfo_RST,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RST_posedge,
          PulseWidthLow           => tpw_RST_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD0_RCLK_posedge,
          TimingData              => Tmkr_RAD0_RCLK_posedge,
          TestSignal              => RAD0_ipd,
          TestSignalName          => "RAD0",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD0_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD0_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD0_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD0_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD1_RCLK_posedge,
          TimingData              => Tmkr_RAD1_RCLK_posedge,
          TestSignal              => RAD1_ipd,
          TestSignalName          => "RAD1",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD1_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD1_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD1_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD1_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD2_RCLK_posedge,
          TimingData              => Tmkr_RAD2_RCLK_posedge,
          TestSignal              => RAD2_ipd,
          TestSignalName          => "RAD2",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD2_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD2_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD2_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD2_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD3_RCLK_posedge,
          TimingData              => Tmkr_RAD3_RCLK_posedge,
          TestSignal              => RAD3_ipd,
          TestSignalName          => "RAD3",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD3_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD3_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD3_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD3_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD4_RCLK_posedge,
          TimingData              => Tmkr_RAD4_RCLK_posedge,
          TestSignal              => RAD4_ipd,
          TestSignalName          => "RAD4",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD4_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD4_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD4_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD4_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD5_RCLK_posedge,
          TimingData              => Tmkr_RAD5_RCLK_posedge,
          TestSignal              => RAD5_ipd,
          TestSignalName          => "RAD5",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD5_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD5_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD5_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD5_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD6_RCLK_posedge,
          TimingData              => Tmkr_RAD6_RCLK_posedge,
          TestSignal              => RAD6_ipd,
          TestSignalName          => "RAD6",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD6_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD6_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD6_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD6_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD7_RCLK_posedge,
          TimingData              => Tmkr_RAD7_RCLK_posedge,
          TestSignal              => RAD7_ipd,
          TestSignalName          => "RAD7",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD7_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD7_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD7_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD7_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD8_RCLK_posedge,
          TimingData              => Tmkr_RAD8_RCLK_posedge,
          TestSignal              => RAD8_ipd,
          TestSignalName          => "RAD8",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD8_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD8_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD8_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD8_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD9_RCLK_posedge,
          TimingData              => Tmkr_RAD9_RCLK_posedge,
          TestSignal              => RAD9_ipd,
          TestSignalName          => "RAD9",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD9_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD9_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD9_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD9_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD10_RCLK_posedge,
          TimingData              => Tmkr_RAD10_RCLK_posedge,
          TestSignal              => RAD10_ipd,
          TestSignalName          => "RAD10",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD10_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD10_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD10_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD10_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD11_RCLK_posedge,
          TimingData              => Tmkr_RAD11_RCLK_posedge,
          TestSignal              => RAD11_ipd,
          TestSignalName          => "RAD11",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD11_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD11_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD11_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD11_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


    end if;

    Violation := Tviol_WCEN_WCLK_posedge or Tviol_WE_WCLK_posedge or 
                 Tviol_WCS0_WCLK_posedge or Tviol_WCS1_WCLK_posedge or 
                 Tviol_WAD0_WCLK_posedge or Tviol_WAD1_WCLK_posedge or 
                 Tviol_WAD2_WCLK_posedge or Tviol_WAD3_WCLK_posedge or 
                 Tviol_WAD4_WCLK_posedge or Tviol_WAD5_WCLK_posedge or 
                 Tviol_WAD6_WCLK_posedge or Tviol_WAD7_WCLK_posedge or 
                 Tviol_WAD8_WCLK_posedge or Tviol_WAD9_WCLK_posedge or 
                 Tviol_WAD10_WCLK_posedge or Tviol_WAD11_WCLK_posedge or 
                 Tviol_WAD12_WCLK_posedge or Tviol_WD0_WCLK_posedge or
                 Tviol_RAD0_RCLK_posedge or Tviol_RAD1_RCLK_posedge or 
                 Tviol_RAD2_RCLK_posedge or Tviol_RAD3_RCLK_posedge or 
                 Tviol_RAD4_RCLK_posedge or Tviol_RAD5_RCLK_posedge or 
                 Tviol_RAD6_RCLK_posedge or Tviol_RAD7_RCLK_posedge or 
                 Tviol_RAD8_RCLK_posedge or Tviol_RAD9_RCLK_posedge or 
                 Tviol_RAD10_RCLK_posedge or Tviol_RAD11_RCLK_posedge or  
                 Tviol_RST_RCLK_posedge_posedge or 
                 Pviol_WCLK or Pviol_RCLK or Pviol_RST;

    -------------------------
    --  Functionality Section
    -------------------------



wait on WCEN_ipd,WCLK_ipd, WE_ipd, WCS, RCLK_ipd, RCEN_ipd, RST_ipd, WD, WAD, RAD, RD;


      end process VITALBehavior;

    VitalBehavior_RD0  : process
      variable RD0_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD0_zd := RD(0);

    VitalPathDelay01 (
      OutSignal => RD0,
      GlitchData => O_GlitchData,
      OutSignalName => "RD0",
      OutTemp => RD0_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD0, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD0, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(0);
      end process;

    VitalBehavior_RD1  : process
      variable RD1_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD1_zd := RD(1);

    VitalPathDelay01 (
      OutSignal => RD1,
      GlitchData => O_GlitchData,
      OutSignalName => "RD1",
      OutTemp => RD1_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD1, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD1, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(1);
      end process;

    VitalBehavior_RD2  : process
      variable RD2_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD2_zd := RD(2);

    VitalPathDelay01 (
      OutSignal => RD2,
      GlitchData => O_GlitchData,
      OutSignalName => "RD2",
      OutTemp => RD2_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD2, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD2, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(2);
      end process;

    VitalBehavior_RD3  : process
      variable RD3_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD3_zd := RD(3);

    VitalPathDelay01 (
      OutSignal => RD3,
      GlitchData => O_GlitchData,
      OutSignalName => "RD3",
      OutTemp => RD3_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD3, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD3, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(3);
      end process;



	PDPRAM_INST: SC_PDPRAM_16K
	   generic map (
		WADDR_WIDTH    => 14,
		WDATA_WIDTH    => 1,
		RADDR_WIDTH    => 12,
		RDATA_WIDTH    => 4,
		MEM_INIT_FLAG  => RAM_INIT_FLAG,
		MEM_INIT_FILE  => RAM_INIT_FILE)
	   port map (
		WCEN => WCEN_ipd ,
		WCLK => WCLK_ipd ,
		WE   => WE_ipd ,
		WCS  => WCS,
		RCLK => RCLK_ipd,
		RCEN => RCEN_ipd,
		RST  => RST_ipd ,
		WD   => WD,
		WAD  => WAD,
		RAD  => RAD,
		RD   => RD
		);

end VITAL;

configuration CFG_RAMB16K_WX1_RX4_VITAL of RAMB16K_WX1_RX4 is
   for VITAL
   end for;
end CFG_RAMB16K_WX1_RX4_VITAL;



----- CELL RAMB16K_WX1_RX8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lc5kmx;
use lc5kmx.components.all;

-- entity declaration --
entity RAMB16K_WX1_RX8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      RAM_INIT_FILE   : string  := "";
      tpd_RCLK_RD0                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD1                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD2                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD3                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD4                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD5                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD6                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD7                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_RST_RD0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tsetup_WCEN_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCEN_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;

      tsetup_RCEN_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RCEN_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WAD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD0_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD1_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD2_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD3_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD4_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD5_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD5_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD6_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD6_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD7_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD7_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD8_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD8_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD9_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD9_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD10_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD10_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD11_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD11_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD12_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD12_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD13_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD13_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_RAD0_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD0_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD1_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD1_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD2_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD2_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD3_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD3_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD4_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD4_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD5_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD5_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD6_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD6_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD7_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD7_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD8_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD8_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD9_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD9_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD10_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RAD10_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      trecovery_RST_RCLK_posedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_RST_RCLK_posedge_posedge     :	VitalDelayType   := 0.0 ns;

      tpw_WCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RST_posedge                    :	VitalDelayType   := 2.0 ns;
      tipd_WCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RST                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      WCEN                            :	in    STD_ULOGIC;
      WCLK                            :	in    STD_ULOGIC;
      WCS0                            :	in    STD_ULOGIC;
      WCS1                            :	in    STD_ULOGIC;
      WE                              :	in    STD_ULOGIC;
      RCEN                            :	in    STD_ULOGIC;
      RCLK                            :	in    STD_ULOGIC;
      RST                             :	in    STD_ULOGIC;
      WD0                            :	in    STD_ULOGIC;
      WAD0                            :	in    STD_ULOGIC;
      WAD1                            :	in    STD_ULOGIC;
      WAD2                            :	in    STD_ULOGIC;
      WAD3                            :	in    STD_ULOGIC;
      WAD4                            :	in    STD_ULOGIC;
      WAD5                            :	in    STD_ULOGIC;
      WAD6                            :	in    STD_ULOGIC;
      WAD7                            :	in    STD_ULOGIC;
      WAD8                            :	in    STD_ULOGIC;
      WAD9                            :	in    STD_ULOGIC;
      WAD10                           :	in    STD_ULOGIC;
      WAD11                           :	in    STD_ULOGIC;
      WAD12                           :	in    STD_ULOGIC;
      WAD13                           :	in    STD_ULOGIC;
      RAD0                            :	in    STD_ULOGIC;
      RAD1                            :	in    STD_ULOGIC;
      RAD2                            :	in    STD_ULOGIC;
      RAD3                            :	in    STD_ULOGIC;
      RAD4                            :	in    STD_ULOGIC;
      RAD5                            :	in    STD_ULOGIC;
      RAD6                            :	in    STD_ULOGIC;
      RAD7                            :	in    STD_ULOGIC;
      RAD8                            :	in    STD_ULOGIC;
      RAD9                            :	in    STD_ULOGIC;
      RAD10                           :	in    STD_ULOGIC;
      RD0                             :	out    STD_ULOGIC;
      RD1                             :	out    STD_ULOGIC;
      RD2                             :	out    STD_ULOGIC;
      RD3                             :	out    STD_ULOGIC;
      RD4                             :	out    STD_ULOGIC;
      RD5                             :	out    STD_ULOGIC;
      RD6                             :	out    STD_ULOGIC;
      RD7                             :	out    STD_ULOGIC);

attribute VITAL_LEVEL0 of RAMB16K_WX1_RX8 : entity is FALSE;
end RAMB16K_WX1_RX8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAMB16K_WX1_RX8 is
  attribute VITAL_LEVEL0 of VITAL : architecture is FALSE;

	component SC_PDPRAM_16K
	   generic (
		WADDR_WIDTH    : integer := 14;
		WDATA_WIDTH    : integer := 1;
		RADDR_WIDTH    : integer := 11;
		RDATA_WIDTH    : integer := 8;
		MEM_INIT_FLAG   : integer := 0;
		MEM_INIT_FILE   : string  := "dummy");
	   port (
		WCEN : in  STD_LOGIC ;
		WCLK : in  STD_LOGIC ;
		WE   : in  STD_LOGIC ;
		WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
		RCLK : in  STD_LOGIC;
		RCEN : in  STD_LOGIC;
		RST  : in  STD_LOGIC ;
		WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
		WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
		RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);
		RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
		);
	end component ;

      signal WCEN_ipd      : std_ulogic := 'X';
      signal WCLK_ipd      : std_ulogic := 'X';
      signal WCS0_ipd      : std_ulogic := 'X';
      signal WCS1_ipd      : std_ulogic := 'X';
      signal WE_ipd        : std_ulogic := 'X';

      signal RCEN_ipd      : std_ulogic := 'X';
      signal RCLK_ipd      : std_ulogic := 'X';
      signal RST_ipd       : std_ulogic := 'X';

      signal WD0_ipd      : std_logic_vector(0 downto 0);

      signal WAD0_ipd      : std_ulogic := 'X';
      signal WAD1_ipd      : std_ulogic := 'X';
      signal WAD2_ipd      : std_ulogic := 'X';
      signal WAD3_ipd      : std_ulogic := 'X';
      signal WAD4_ipd      : std_ulogic := 'X';
      signal WAD5_ipd      : std_ulogic := 'X';
      signal WAD6_ipd      : std_ulogic := 'X';
      signal WAD7_ipd      : std_ulogic := 'X';
      signal WAD8_ipd      : std_ulogic := 'X';
      signal WAD9_ipd      : std_ulogic := 'X';
      signal WAD10_ipd     : std_ulogic := 'X';
      signal WAD11_ipd     : std_ulogic := 'X';
      signal WAD12_ipd     : std_ulogic := 'X';
      signal WAD13_ipd     : std_ulogic := 'X';

      signal RAD0_ipd      : std_ulogic := 'X';
      signal RAD1_ipd      : std_ulogic := 'X';
      signal RAD2_ipd      : std_ulogic := 'X';
      signal RAD3_ipd      : std_ulogic := 'X';
      signal RAD4_ipd      : std_ulogic := 'X';
      signal RAD5_ipd      : std_ulogic := 'X';
      signal RAD6_ipd      : std_ulogic := 'X';
      signal RAD7_ipd      : std_ulogic := 'X';
      signal RAD8_ipd      : std_ulogic := 'X';
      signal RAD9_ipd      : std_ulogic := 'X';
      signal RAD10_ipd     : std_ulogic := 'X';

	signal WCS : std_logic_vector (1 downto 0);
	signal WD  : std_logic_vector (0 downto 0);
 	signal WAD : std_logic_vector (13 downto 0);
	signal RAD : std_logic_vector (10 downto 0);
	signal RD  : std_logic_vector (7 downto 0);

      CONSTANT  RAM_INIT_FLAG       :  integer := init_flag(RAM_INIT_FILE);
begin 

	WCS <= WCS1_ipd & WCS0_ipd;
	WD <= WD0_ipd;
	WAD <= WAD13_ipd & WAD12_ipd & WAD11_ipd & WAD10_ipd & WAD9_ipd & WAD8_ipd & WAD7_ipd & WAD6_ipd & WAD5_ipd & WAD4_ipd & WAD3_ipd & WAD2_ipd & WAD1_ipd & WAD0_ipd;
	RAD <= RAD10_ipd & RAD9_ipd & RAD8_ipd & RAD7_ipd & RAD6_ipd & RAD5_ipd & RAD4_ipd & RAD3_ipd & RAD2_ipd & RAD1_ipd & RAD0_ipd;

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin

        VitalWireDelay (WCEN_ipd, WCEN, tipd_WCEN);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
        VitalWireDelay (WCS0_ipd, WCS0, tipd_WCS0);
        VitalWireDelay (WCS1_ipd, WCS1, tipd_WCS1);
        VitalWireDelay (WE_ipd, WE, tipd_WE);

        VitalWireDelay (RCEN_ipd, RCEN, tipd_RCEN);
        VitalWireDelay (RCLK_ipd, RCLK, tipd_RCLK);

        VitalWireDelay (RST_ipd, RST, tipd_RST);

        VitalWireDelay (WD0_ipd(0), WD0, tipd_WD0);

        VitalWireDelay (WAD0_ipd, WAD0, tipd_WAD0);
        VitalWireDelay (WAD1_ipd, WAD1, tipd_WAD1);
        VitalWireDelay (WAD2_ipd, WAD2, tipd_WAD2);
        VitalWireDelay (WAD3_ipd, WAD3, tipd_WAD3);
        VitalWireDelay (WAD4_ipd, WAD4, tipd_WAD4);
        VitalWireDelay (WAD5_ipd, WAD5, tipd_WAD5);
        VitalWireDelay (WAD6_ipd, WAD6, tipd_WAD6);
        VitalWireDelay (WAD7_ipd, WAD7, tipd_WAD7);
        VitalWireDelay (WAD8_ipd, WAD8, tipd_WAD8);
        VitalWireDelay (WAD9_ipd, WAD9, tipd_WAD9);
        VitalWireDelay (WAD10_ipd, WAD10, tipd_WAD10);
        VitalWireDelay (WAD11_ipd, WAD11, tipd_WAD11);
        VitalWireDelay (WAD12_ipd, WAD12, tipd_WAD12);
        VitalWireDelay (WAD13_ipd, WAD13, tipd_WAD13);

        VitalWireDelay (RAD0_ipd, RAD0, tipd_RAD0);
        VitalWireDelay (RAD1_ipd, RAD1, tipd_RAD1);
        VitalWireDelay (RAD2_ipd, RAD2, tipd_RAD2);
        VitalWireDelay (RAD3_ipd, RAD3, tipd_RAD3);
        VitalWireDelay (RAD4_ipd, RAD4, tipd_RAD4);
        VitalWireDelay (RAD5_ipd, RAD5, tipd_RAD5);
        VitalWireDelay (RAD6_ipd, RAD6, tipd_RAD6);
        VitalWireDelay (RAD7_ipd, RAD7, tipd_RAD7);
        VitalWireDelay (RAD8_ipd, RAD8, tipd_RAD8);
        VitalWireDelay (RAD9_ipd, RAD9, tipd_RAD9);
        VitalWireDelay (RAD10_ipd, RAD10, tipd_RAD10);

      end block;

      --------------------
      --  Write Behavior
      --------------------
      VITALBehavior : process
        -- Local variables used for timing checks

        variable Tviol_WCEN_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS1_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WE_WCLK_posedge      : std_ulogic  := '0';

        variable Tviol_RCEN_RCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WD0_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WAD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD5_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD6_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD7_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD8_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD9_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD10_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD11_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD12_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD13_WCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RAD0_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD1_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD2_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD3_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD4_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD5_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD6_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD7_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD8_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD9_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD10_RCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RST_RCLK_posedge_posedge   : std_ulogic  := '0';

        variable Tmkr_WCEN_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RCEN_RCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WAD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD6_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD7_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD8_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD9_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD10_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD11_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD12_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD13_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RAD0_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD1_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD2_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD3_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD4_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD5_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD6_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD7_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD8_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD9_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD10_RCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RST_RCLK_posedge_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RCLK       : std_ulogic := '0';
        variable PInfo_RCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RST       : std_ulogic := '0';
        variable PInfo_RST       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality
        variable Violation       : std_ulogic := '0';
        variable RD0_zd          : std_ulogic := 'X';
        variable RD1_zd          : std_ulogic := 'X';
        variable RD2_zd          : std_ulogic := 'X';
        variable RD3_zd          : std_ulogic := 'X';
        variable RD4_zd          : std_ulogic := 'X';
        variable RD5_zd          : std_ulogic := 'X';
        variable RD6_zd          : std_ulogic := 'X';
        variable RD7_zd          : std_ulogic := 'X';
        variable O_GlitchData    : VitalGlitchDataType;

    begin

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WCEN_WCLK_posedge,
          TimingData              => Tmkr_WCEN_WCLK_posedge,
          TestSignal              => WCEN_ipd,
          TestSignalName          => "WCEN",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCEN_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCEN_WCLK_noedge_posedge,
          HoldLow                 => thold_WCEN_WCLK_noedge_posedge,
          HoldHigh                => thold_WCEN_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS0_WCLK_posedge,
          TimingData              => Tmkr_WCS0_WCLK_posedge,
          TestSignal              => WCS0_ipd,
          TestSignalName          => "WCS0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS0_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS0_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WCS1_WCLK_posedge,
          TimingData              => Tmkr_WCS1_WCLK_posedge,
          TestSignal              => WCS1_ipd,
          TestSignalName          => "WCS1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WCS1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WCS1_WCLK_noedge_posedge,
          HoldLow                 => thold_WCS1_WCLK_noedge_posedge,
          HoldHigh                => thold_WCS1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RCEN_RCLK_posedge,
          TimingData              => Tmkr_RCEN_RCLK_posedge,
          TestSignal              => RCEN_ipd,
          TestSignalName          => "RCEN",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RCEN_RCLK_noedge_posedge,
          SetupLow                => tsetup_RCEN_RCLK_noedge_posedge,
          HoldLow                 => thold_RCEN_RCLK_noedge_posedge,
          HoldHigh                => thold_RCEN_RCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WD0_WCLK_posedge,
          TimingData              => Tmkr_WD0_WCLK_posedge,
          TestSignal              => WD0_ipd,
          TestSignalName          => "WD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalSetupHoldCheck (
          Violation               => Tviol_WAD0_WCLK_posedge,
          TimingData              => Tmkr_WAD0_WCLK_posedge,
          TestSignal              => WAD0_ipd,
          TestSignalName          => "WAD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD0_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD0_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD1_WCLK_posedge,
          TimingData              => Tmkr_WAD1_WCLK_posedge,
          TestSignal              => WAD1_ipd,
          TestSignalName          => "WAD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD1_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD1_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD2_WCLK_posedge,
          TimingData              => Tmkr_WAD2_WCLK_posedge,
          TestSignal              => WAD2_ipd,
          TestSignalName          => "WAD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD2_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD2_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD2_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD3_WCLK_posedge,
          TimingData              => Tmkr_WAD3_WCLK_posedge,
          TestSignal              => WAD3_ipd,
          TestSignalName          => "WAD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD3_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD3_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD3_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD4_WCLK_posedge,
          TimingData              => Tmkr_WAD4_WCLK_posedge,
          TestSignal              => WAD4_ipd,
          TestSignalName          => "WAD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD4_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD4_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD4_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD5_WCLK_posedge,
          TimingData              => Tmkr_WAD5_WCLK_posedge,
          TestSignal              => WAD5_ipd,
          TestSignalName          => "WAD5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD5_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD5_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD5_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD5_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD6_WCLK_posedge,
          TimingData              => Tmkr_WAD6_WCLK_posedge,
          TestSignal              => WAD6_ipd,
          TestSignalName          => "WAD6",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD6_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD6_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD6_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD6_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD7_WCLK_posedge,
          TimingData              => Tmkr_WAD7_WCLK_posedge,
          TestSignal              => WAD7_ipd,
          TestSignalName          => "WAD7",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD7_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD7_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD7_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD7_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD8_WCLK_posedge,
          TimingData              => Tmkr_WAD8_WCLK_posedge,
          TestSignal              => WAD8_ipd,
          TestSignalName          => "WAD8",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD8_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD8_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD8_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD8_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD9_WCLK_posedge,
          TimingData              => Tmkr_WAD9_WCLK_posedge,
          TestSignal              => WAD9_ipd,
          TestSignalName          => "WAD9",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD9_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD9_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD9_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD9_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD10_WCLK_posedge,
          TimingData              => Tmkr_WAD10_WCLK_posedge,
          TestSignal              => WAD10_ipd,
          TestSignalName          => "WAD10",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD10_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD10_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD10_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD10_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD11_WCLK_posedge,
          TimingData              => Tmkr_WAD11_WCLK_posedge,
          TestSignal              => WAD11_ipd,
          TestSignalName          => "WAD11",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD11_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD11_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD11_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD11_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD12_WCLK_posedge,
          TimingData              => Tmkr_WAD12_WCLK_posedge,
          TestSignal              => WAD12_ipd,
          TestSignalName          => "WAD12",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD12_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD12_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD12_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD12_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WAD13_WCLK_posedge,
          TimingData              => Tmkr_WAD13_WCLK_posedge,
          TestSignal              => WAD13_ipd,
          TestSignalName          => "WAD13",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WAD13_WCLK_noedge_posedge,
          SetupLow                => tsetup_WAD13_WCLK_noedge_posedge,
          HoldLow                 => thold_WAD13_WCLK_noedge_posedge,
          HoldHigh                => thold_WAD13_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalRecoveryRemovalCheck (
          Violation               => Tviol_RST_RCLK_posedge_posedge,
          TimingData              => Tmkr_RST_RCLK_posedge_posedge,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName          => "RCLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_RST_RCLK_posedge_posedge,
          Removal                 => thold_RST_RCLK_posedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RCLK,
          PeriodData              => PInfo_RCLK,
          TestSignal              => RCLK_ipd,
          TestSignalName          => "RCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RCLK_posedge,
          PulseWidthLow           => tpw_RCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RST,
          PeriodData              => PInfo_RST,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RST_posedge,
          PulseWidthLow           => tpw_RST_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD0_RCLK_posedge,
          TimingData              => Tmkr_RAD0_RCLK_posedge,
          TestSignal              => RAD0_ipd,
          TestSignalName          => "RAD0",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD0_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD0_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD0_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD0_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD1_RCLK_posedge,
          TimingData              => Tmkr_RAD1_RCLK_posedge,
          TestSignal              => RAD1_ipd,
          TestSignalName          => "RAD1",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD1_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD1_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD1_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD1_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD2_RCLK_posedge,
          TimingData              => Tmkr_RAD2_RCLK_posedge,
          TestSignal              => RAD2_ipd,
          TestSignalName          => "RAD2",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD2_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD2_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD2_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD2_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD3_RCLK_posedge,
          TimingData              => Tmkr_RAD3_RCLK_posedge,
          TestSignal              => RAD3_ipd,
          TestSignalName          => "RAD3",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD3_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD3_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD3_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD3_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD4_RCLK_posedge,
          TimingData              => Tmkr_RAD4_RCLK_posedge,
          TestSignal              => RAD4_ipd,
          TestSignalName          => "RAD4",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD4_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD4_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD4_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD4_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD5_RCLK_posedge,
          TimingData              => Tmkr_RAD5_RCLK_posedge,
          TestSignal              => RAD5_ipd,
          TestSignalName          => "RAD5",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD5_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD5_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD5_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD5_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD6_RCLK_posedge,
          TimingData              => Tmkr_RAD6_RCLK_posedge,
          TestSignal              => RAD6_ipd,
          TestSignalName          => "RAD6",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD6_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD6_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD6_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD6_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD7_RCLK_posedge,
          TimingData              => Tmkr_RAD7_RCLK_posedge,
          TestSignal              => RAD7_ipd,
          TestSignalName          => "RAD7",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD7_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD7_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD7_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD7_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD8_RCLK_posedge,
          TimingData              => Tmkr_RAD8_RCLK_posedge,
          TestSignal              => RAD8_ipd,
          TestSignalName          => "RAD8",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD8_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD8_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD8_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD8_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD9_RCLK_posedge,
          TimingData              => Tmkr_RAD9_RCLK_posedge,
          TestSignal              => RAD9_ipd,
          TestSignalName          => "RAD9",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD9_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD9_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD9_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD9_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RAD10_RCLK_posedge,
          TimingData              => Tmkr_RAD10_RCLK_posedge,
          TestSignal              => RAD10_ipd,
          TestSignalName          => "RAD10",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RAD10_RCLK_noedge_posedge,
          SetupLow                => tsetup_RAD10_RCLK_noedge_posedge,
          HoldLow                 => thold_RAD10_RCLK_noedge_posedge,
          HoldHigh                => thold_RAD10_RCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB16K_WX1_RX8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


    end if;

    Violation := Tviol_WCEN_WCLK_posedge or Tviol_WE_WCLK_posedge or 
                 Tviol_WCS0_WCLK_posedge or Tviol_WCS1_WCLK_posedge or 
                 Tviol_WAD0_WCLK_posedge or Tviol_WAD1_WCLK_posedge or 
                 Tviol_WAD2_WCLK_posedge or Tviol_WAD3_WCLK_posedge or 
                 Tviol_WAD4_WCLK_posedge or Tviol_WAD5_WCLK_posedge or 
                 Tviol_WAD6_WCLK_posedge or Tviol_WAD7_WCLK_posedge or 
                 Tviol_WAD8_WCLK_posedge or Tviol_WAD9_WCLK_posedge or 
                 Tviol_WAD10_WCLK_posedge or Tviol_WAD11_WCLK_posedge or 
                 Tviol_WAD12_WCLK_posedge or Tviol_WD0_WCLK_posedge or
                 Tviol_RAD0_RCLK_posedge or Tviol_RAD1_RCLK_posedge or 
                 Tviol_RAD2_RCLK_posedge or Tviol_RAD3_RCLK_posedge or 
                 Tviol_RAD4_RCLK_posedge or Tviol_RAD5_RCLK_posedge or 
                 Tviol_RAD6_RCLK_posedge or Tviol_RAD7_RCLK_posedge or 
                 Tviol_RAD8_RCLK_posedge or Tviol_RAD9_RCLK_posedge or 
                 Tviol_RAD10_RCLK_posedge or 
                 Tviol_RST_RCLK_posedge_posedge or 
                 Pviol_WCLK or Pviol_RCLK or Pviol_RST;

    -------------------------
    --  Functionality Section
    -------------------------

wait on WCEN_ipd,WCLK_ipd, WE_ipd, WCS, RCLK_ipd, RCEN_ipd, RST_ipd, WD, WAD, RAD;


      end process VITALBehavior;

    VitalBehavior_RD0  : process
      variable RD0_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD0_zd := RD(0);

    VitalPathDelay01 (
      OutSignal => RD0,
      GlitchData => O_GlitchData,
      OutSignalName => "RD0",
      OutTemp => RD0_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD0, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD0, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(0);
      end process;

    VitalBehavior_RD1  : process
      variable RD1_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD1_zd := RD(1);

    VitalPathDelay01 (
      OutSignal => RD1,
      GlitchData => O_GlitchData,
      OutSignalName => "RD1",
      OutTemp => RD1_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD1, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD1, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(1);
      end process;

    VitalBehavior_RD2  : process
      variable RD2_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD2_zd := RD(2);

    VitalPathDelay01 (
      OutSignal => RD2,
      GlitchData => O_GlitchData,
      OutSignalName => "RD2",
      OutTemp => RD2_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD2, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD2, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(2);
      end process;

    VitalBehavior_RD3  : process
      variable RD3_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD3_zd := RD(3);

    VitalPathDelay01 (
      OutSignal => RD3,
      GlitchData => O_GlitchData,
      OutSignalName => "RD3",
      OutTemp => RD3_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD3, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD3, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(3);
      end process;

    VitalBehavior_RD4  : process
      variable RD4_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD4_zd := RD(4);

    VitalPathDelay01 (
      OutSignal => RD4,
      GlitchData => O_GlitchData,
      OutSignalName => "RD4",
      OutTemp => RD4_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD4, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD4, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(4);
      end process;

    VitalBehavior_RD5  : process
      variable RD5_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD5_zd := RD(5);

    VitalPathDelay01 (
      OutSignal => RD5,
      GlitchData => O_GlitchData,
      OutSignalName => "RD5",
      OutTemp => RD5_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD5, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD5, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(5);
      end process;

    VitalBehavior_RD6  : process
      variable RD6_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD6_zd := RD(6);

    VitalPathDelay01 (
      OutSignal => RD6,
      GlitchData => O_GlitchData,
      OutSignalName => "RD6",
      OutTemp => RD6_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD6, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD6, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(6);
      end process;

    VitalBehavior_RD7  : process
      variable RD7_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      RD7_zd := RD(7);

    VitalPathDelay01 (
      OutSignal => RD7,
      GlitchData => O_GlitchData,
      OutSignalName => "RD7",
      OutTemp => RD7_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_RD7, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_RD7, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on RD(7);
      end process;



	PDPRAM_INST: SC_PDPRAM_16K
	   generic map (
		WADDR_WIDTH    => 14,
		WDATA_WIDTH    => 1,
		RADDR_WIDTH    => 11,
		RDATA_WIDTH    => 8,
		MEM_INIT_FLAG  => RAM_INIT_FLAG,
		MEM_INIT_FILE  => RAM_INIT_FILE)
	   port map (
		WCEN => WCEN_ipd ,
		WCLK => WCLK_ipd ,
		WE   => WE_ipd ,
		WCS  => WCS,
		RCLK => RCLK_ipd,
		RCEN => RCEN_ipd,
		RST  => RST_ipd ,
		WD   => WD,
		WAD  => WAD,
		RAD  => RAD,
		RD   => RD
		);


end VITAL;

configuration CFG_RAMB16K_WX1_RX8_VITAL of RAMB16K_WX1_RX8 is
   for VITAL
   end for;
end CFG_RAMB16K_WX1_RX8_VITAL;



----- CELL RAMB16K_WX1_RX16 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lc5kmx;
use lc5kmx.components.all;

-- entity declaration --
entity RAMB16K_WX1_RX16 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      RAM_INIT_FILE   : string  := "";
      tpd_RCLK_RD0                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD1                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD2                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD3                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD4                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD5                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD6                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD7                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD8                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD9                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD10                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD11                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD12                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD13                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD14                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_RD15                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_RST_RD0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD10                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD11                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD12                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD13                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD14                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_RD15                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tsetup_WCEN_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCEN_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WCS1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WCS1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;

      tsetup_RCEN_RCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_RCEN_RCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_WAD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD0_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD1_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD2_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD3_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD4_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD5_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD5_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD6_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD6_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD7_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD7_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD8_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD8_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD9_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WAD9_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WAD10_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD10_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD11_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD11_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD12_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD12_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WAD13_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_WAD13_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;

      tsetup_RAD0_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD0_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD1_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD1_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD2_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD2_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD3_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD3_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD4_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD4_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD5_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD5_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD6_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD6_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD7_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD7_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD8_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD8_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_RAD9_RCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_RAD9_RCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;

      trecovery_RST_RCLK_posedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_RST_RCLK_posedge_posedge     :	VitalDelayType   := 0.0 ns;

      tpw_WCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RST_posedge                    :	VitalDelayType   := 2.0 ns;
      tipd_WCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCS1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCEN                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RST                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WAD13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RAD9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      WCEN                            :	in    STD_ULOGIC;
      WCLK                            :	in    STD_ULOGIC;
      WCS0                            :	in    STD_ULOGIC;
      WCS1                            :	in    STD_ULOGIC;
      WE                              :	in    STD_ULOGIC;
      RCEN                            :	in    STD_ULOGIC;
      RCLK                            :	in    STD_ULOGIC;
      RST                             :	in    STD_ULOGIC;
      WD0                            :	in    STD_ULOGIC;
      WAD0                            :	in    STD_ULOGIC;
      WAD1                            :	in    STD_ULOGIC;
      WAD2                            :	in    STD_ULOGIC;
      WAD3                            :	in    STD_ULOGIC;
      WAD4                            :	in    STD_ULOGIC;
      WAD5                            :	in    STD_ULOGIC;
      WAD6                            :	in    STD_ULOGIC;
      WAD7                            :	in    STD_ULOGIC;
      WAD8                            :	in    STD_ULOGIC;
      WAD9                            :	in    STD_ULOGIC;
      WAD10                           :	in    STD_ULOGIC;
      WAD11                           :	in    STD_ULOGIC;
      WAD12                           :	in    STD_ULOGIC;
      WAD13                           :	in    STD_ULOGIC;
      RAD0                            :	in    STD_ULOGIC;
      RAD1                            :	in    STD_ULOGIC;
      RAD2                            :	in    STD_ULOGIC;
      RAD3                            :	in    STD_ULOGIC;
      RAD4                            :	in    STD_ULOGIC;
      RAD5                            :	in    STD_ULOGIC;
      RAD6                            :	in    STD_ULOGIC;
      RAD7                            :	in    STD_ULOGIC;
      RAD8                            :	in    STD_ULOGIC;
      RAD9                            :	in    STD_ULOGIC;
      RD0                             :	out    STD_ULOGIC;
      RD1                             :	out    STD_ULOGIC;
      RD2                             :	out    STD_ULOGIC;
      RD3                             :	out    STD_ULOGIC;
      RD4                             :	out    STD_ULOGIC;
      RD5                             :	out    STD_ULOGIC;
      RD6                             :	out    STD_ULOGIC;
      RD7                             :	out    STD_ULOGIC;
      RD8                             :	out    STD_ULOGIC;
      RD9                             :	out    STD_ULOGIC;
      RD10                            :	out    STD_ULOGIC;
      RD11                            :	out    STD_ULOGIC;
      RD12                            :	out    STD_ULOGIC;
      RD13                            :	out    STD_ULOGIC;
      RD14                            :	out    STD_ULOGIC;
      RD15                            :	out    STD_ULOGIC);

attribute VITAL_LEVEL0 of RAMB16K_WX1_RX16 : entity is FALSE;
end RAMB16K_WX1_RX16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAMB16K_WX1_RX16 is
  attribute VITAL_LEVEL0 of VITAL : architecture is FALSE;

	component SC_PDPRAM_16K
	   generic (
		WADDR_WIDTH    : integer := 14;
		WDATA_WIDTH    : integer := 1;
		RADDR_WIDTH    : integer := 10;
		RDATA_WIDTH    : integer := 16;
		MEM_INIT_FLAG   : integer := 0;
		MEM_INIT_FILE   : string  := "dummy");
	   port (
		WCEN : in  STD_LOGIC ;
		WCLK : in  STD_LOGIC ;
		WE   : in  STD_LOGIC ;
		WCS  : in  STD_LOGIC_VECTOR (1 downto 0);
		RCLK : in  STD_LOGIC;
		RCEN : in  STD_LOGIC;
		RST  : in  STD_LOGIC ;
		WD   : in  STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
		WAD  : in  STD_LOGIC_VECTOR (WADDR_WIDTH -1 downto 0);
		RAD  : in  STD_LOGIC_VECTOR (RADDR_WIDTH -1 downto 0);
		RD   : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
		);
	end component ;

      signal WCEN_ipd      : std_ulogic := 'X';
      signal WCLK_ipd      : std_ulogic := 'X';
      signal WCS0_ipd      : std_ulogic := 'X';
      signal WCS1_ipd      : std_ulogic := 'X';
      signal WE_ipd        : std_ulogic := 'X';

      signal RCEN_ipd      : std_ulogic := 'X';
      signal RCLK_ipd      : std_ulogic := 'X';
      signal RST_ipd       : std_ulogic := 'X';

      signal WD0_ipd      : std_logic_vector(0 downto 0);

      signal WAD0_ipd      : std_ulogic := 'X';
      signal WAD1_ipd      : std_ulogic := 'X';
      signal WAD2_ipd      : std_ulogic := 'X';
      signal WAD3_ipd      : std_ulogic := 'X';
      signal WAD4_ipd      : std_ulogic := 'X';
      signal WAD5_ipd      : std_ulogic := 'X';
      signal WAD6_ipd      : std_ulogic := 'X';
      signal WAD7_ipd      : std_ulogic := 'X';
      signal WAD8_ipd      : std_ulogic := 'X';
      signal WAD9_ipd      : std_ulogic := 'X';
      signal WAD10_ipd     : std_ulogic := 'X';
      signal WAD11_ipd     : std_ulogic := 'X';
      signal WAD12_ipd     : std_ulogic := 'X';
      signal WAD13_ipd     : std_ulogic := 'X';

      signal RAD0_ipd      : std_ulogic := 'X';
      signal RAD1_ipd      : std_ulogic := 'X';
      signal RAD2_ipd      : std_ulogic := 'X';
      signal RAD3_ipd      : std_ulogic := 'X';
      signal RAD4_ipd      : std_ulogic := 'X';
      signal RAD5_ipd      : std_ulogic := 'X';
      signal RAD6_ipd      : std_ulogic := 'X';
      signal RAD7_ipd      : std_ulogic := 'X';
      signal RAD8_ipd      : std_ulogic := 'X';
      signal RAD9_ipd      : std_ulogic := 'X';

	signal WCS : std_logic_vector (1 downto 0);
	signal WD  : std_logic_vector (0 downto 0);
 	signal WAD : std_logic_vector (13 downto 0);
	signal RAD : std_logic_vector (9 downto 0);
	signal RD  : std_logic_vector (15 downto 0);

      CONSTANT  RAM_INIT_FLAG       :  integer := init_flag(RAM_INIT_FILE);
begin 

	WCS <= WCS1_ipd & WCS0_ipd;
	WD <= WD0_ipd;
	WAD <= WAD13_ipd & WAD12_ipd & WAD11_ipd & WAD10_ipd & WAD9_ipd & WAD8_ipd & WAD7_ipd & WAD6_ipd & WAD5_ipd & WAD4_ipd & WAD3_ipd & WAD2_ipd & WAD1_ipd & WAD0_ipd;
	RAD <= RAD9_ipd & RAD8_ipd & RAD7_ipd & RAD6_ipd & RAD5_ipd & RAD4_ipd & RAD3_ipd & RAD2_ipd & RAD1_ipd & RAD0_ipd;


  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin

        VitalWireDelay (WCEN_ipd, WCEN, tipd_WCEN);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
        VitalWireDelay (WCS0_ipd, WCS0, tipd_WCS0);
        VitalWireDelay (WCS1_ipd, WCS1, tipd_WCS1);
        VitalWireDelay (WE_ipd, WE, tipd_WE);

        VitalWireDelay (RCEN_ipd, RCEN, tipd_RCEN);
        VitalWireDelay (RCLK_ipd, RCLK, tipd_RCLK);

        VitalWireDelay (RST_ipd, RST, tipd_RST);

        VitalWireDelay (WD0_ipd(0), WD0, tipd_WD0);

        VitalWireDelay (WAD0_ipd, WAD0, tipd_WAD0);
        VitalWireDelay (WAD1_ipd, WAD1, tipd_WAD1);
        VitalWireDelay (WAD2_ipd, WAD2, tipd_WAD2);
        VitalWireDelay (WAD3_ipd, WAD3, tipd_WAD3);
        VitalWireDelay (WAD4_ipd, WAD4, tipd_WAD4);
        VitalWireDelay (WAD5_ipd, WAD5, tipd_WAD5);
        VitalWireDelay (WAD6_ipd, WAD6, tipd_WAD6);
        VitalWireDelay (WAD7_ipd, WAD7, tipd_WAD7);
        VitalWireDelay (WAD8_ipd, WAD8, tipd_WAD8);
        VitalWireDelay (WAD9_ipd, WAD9, tipd_WAD9);
        VitalWireDelay (WAD10_ipd, WAD10, tipd_WAD10);
        VitalWireDelay (WAD11_ipd, WAD11, tipd_WAD11);
        VitalWireDelay (WAD12_ipd, WAD12, tipd_WAD12);
        VitalWireDelay (WAD13_ipd, WAD13, tipd_WAD13);

        VitalWireDelay (RAD0_ipd, RAD0, tipd_RAD0);
        VitalWireDelay (RAD1_ipd, RAD1, tipd_RAD1);
        VitalWireDelay (RAD2_ipd, RAD2, tipd_RAD2);
        VitalWireDelay (RAD3_ipd, RAD3, tipd_RAD3);
        VitalWireDelay (RAD4_ipd, RAD4, tipd_RAD4);
        VitalWireDelay (RAD5_ipd, RAD5, tipd_RAD5);
        VitalWireDelay (RAD6_ipd, RAD6, tipd_RAD6);
        VitalWireDelay (RAD7_ipd, RAD7, tipd_RAD7);
        VitalWireDelay (RAD8_ipd, RAD8, tipd_RAD8);
        VitalWireDelay (RAD9_ipd, RAD9, tipd_RAD9);

      end block;

      --------------------
      --  Write Behavior
      --------------------
      VITALBehavior : process
        -- Local variables used for timing checks

        variable Tviol_WCEN_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WCS1_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WE_WCLK_posedge      : std_ulogic  := '0';

        variable Tviol_RCEN_RCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WD0_WCLK_posedge    : std_ulogic  := '0';

        variable Tviol_WAD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD5_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD6_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD7_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD8_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD9_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_WAD10_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD11_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD12_WCLK_posedge   : std_ulogic  := '0';
        variable Tviol_WAD13_WCLK_posedge   : std_ulogic  := '0';

        variable Tviol_RAD0_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD1_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD2_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD3_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD4_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD5_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD6_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD7_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD8_RCLK_posedge    : std_ulogic  := '0';
        variable Tviol_RAD9_RCLK_posedge    : std_ulogic  := '0';

        variable Tviol_RST_RCLK_posedge_posedge   : std_ulogic  := '0';

        variable Tmkr_WCEN_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WCS1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RCEN_RCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_WAD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD6_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD7_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD8_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD9_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD10_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD11_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD12_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WAD13_WCLK_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RAD0_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD1_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD2_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD3_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD4_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD5_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD6_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD7_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RAD8_RCLK_po